/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractRangeExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BetweenExpression
extends AbstractRangeExpression {
    private AbstractExpression expression;
    private String notIdentifier;

    public BetweenExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent, "BETWEEN");
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
        super.acceptChildren(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
        super.addChildrenTo(children);
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.hasExpression()) {
            children.add(this.expression);
            children.add(this.buildStringExpression(' '));
        }
        if (this.notIdentifier != null) {
            children.add(this.buildStringExpression("NOT"));
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedChildrenTo(children);
    }

    @Override
    protected String boundExpressionQueryBNFId() {
        return "internal_between_expression";
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        return this.notIdentifier != null ? "NOT BETWEEN" : "BETWEEN";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("between_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasNot() {
        return this.notIdentifier != null;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIgnoreCase('N')) {
            this.notIdentifier = wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        super.parse(wordParser, tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.hasExpression()) {
            this.expression.toParsedText(writer, actual);
            writer.append(' ');
        }
        if (this.notIdentifier != null) {
            writer.append(actual ? this.notIdentifier : "NOT");
            writer.append(' ');
        }
        super.toParsedText(writer, actual);
    }
}

