/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXML;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXMLMappings;
import org.eclipse.persistence.oxm.XMLContext;

public class PersistenceUnitReader {
    protected MetadataMirrorFactory factory;
    protected ProcessingEnvironment processingEnv;

    public PersistenceUnitReader(MetadataMirrorFactory factory) throws IOException {
        this.factory = factory;
        this.processingEnv = factory.getProcessingEnvironment();
        if (Boolean.valueOf(CanonicalModelProperties.getOption((String)"eclipselink.canonicalmodel.load_xml", (String)"true", this.processingEnv.getOptions())).booleanValue()) {
            this.initPersistenceUnits();
        }
    }

    protected void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
    }

    protected FileObject getFileObject(String filename, ProcessingEnvironment processingEnv) throws IOException {
        return processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
    }

    protected InputStream getInputStream(String filename, boolean loadingPersistenceXML) {
        InputStream inputStream;
        block5: {
            inputStream = null;
            try {
                FileObject fileObject = this.getFileObject(filename, this.processingEnv);
                inputStream = fileObject.openInputStream();
            }
            catch (Exception ioe) {
                try {
                    inputStream = new FileInputStream(filename);
                }
                catch (IOException e) {
                    if (loadingPersistenceXML) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "The persistence xml file [" + filename + "] was not found. NO GENERATION will occur!! Please ensure a persistence xml file is available either from the CLASS_OUTPUT directory [META-INF/persistence.xml] or using the eclipselink.persistencexml property to specify its location. ");
                        break block5;
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Optional file was not found: " + filename + " continuing with generation.");
                }
            }
        }
        return inputStream;
    }

    protected HashSet<String> getPersistenceUnitList(ProcessingEnvironment processingEnv) {
        String persistenceUnits = processingEnv.getOptions().get("eclipselink.persistenceunits");
        HashSet<String> persistenceUnitList = null;
        if (persistenceUnits != null) {
            persistenceUnitList = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(persistenceUnits, ",");
            while (st.hasMoreTokens()) {
                persistenceUnitList.add(st.nextToken().trim());
            }
        }
        return persistenceUnitList;
    }

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.factory.getPersistenceUnits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPersistenceUnits() {
        for (String optionKey : this.processingEnv.getOptions().keySet()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Found Option : " + optionKey + ", with value: " + this.processingEnv.getOptions().get(optionKey));
        }
        String filename = CanonicalModelProperties.getOption((String)"eclipselink.persistencexml", (String)"META-INF/persistence.xml", this.processingEnv.getOptions());
        HashSet<String> persistenceUnitList = this.getPersistenceUnitList(this.processingEnv);
        InputStream inStream = null;
        try {
            XMLContext context = PersistenceXMLMappings.createXMLContext();
            inStream = this.getInputStream(filename, true);
            if (inStream != null) {
                PersistenceXML persistenceXML = (PersistenceXML)context.createUnmarshaller().unmarshal(inStream);
                for (SEPersistenceUnitInfo puInfo : persistenceXML.getPersistenceUnitInfos()) {
                    if (persistenceUnitList != null && !persistenceUnitList.contains(puInfo.getPersistenceUnitName())) continue;
                    this.factory.addPersistenceUnit(puInfo, new PersistenceUnit(puInfo, this.factory, this));
                }
            }
            this.closeInputStream(inStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inStream);
            throw throwable;
        }
    }
}

