/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.PersistenceException;
import javax.persistence.ValidationMode;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.StaticWeaveInfo;
import org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.weaving.PersistenceWeaver;
import org.eclipse.persistence.internal.jpa.weaving.TransformerFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.jpa.metadata.FileBasedProjectCache;
import org.eclipse.persistence.jpa.metadata.MetadataSource;
import org.eclipse.persistence.jpa.metadata.ProjectCache;
import org.eclipse.persistence.jpa.metadata.XMLMetadataSource;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.database.events.DatabaseEventListener;
import org.eclipse.persistence.platform.database.partitioning.DataPartitioningCallback;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.MetadataRefreshListener;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSPublishingTransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceMonitor;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.profiler.QueryMonitor;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class EntityManagerSetupImpl
implements MetadataRefreshListener {
    protected String persistenceUnitUniqueName;
    protected String sessionName;
    protected MetadataProcessor processor = null;
    protected PersistenceWeaver weaver = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected int factoryCount = 0;
    protected DatabaseSessionImpl session = null;
    protected boolean isInContainerMode = false;
    protected boolean isSessionLoadedFromSessionsXML = false;
    protected ProjectCache projectCacheAccessor = null;
    protected boolean shouldBuildProject = true;
    protected Boolean enableWeaving = null;
    protected boolean isWeavingStatic = false;
    protected StaticWeaveInfo staticWeaveInfo;
    protected SecurableObjectHolder securableObjectHolder = new SecurableObjectHolder();
    protected ConcurrencyManager deployLock = new ConcurrencyManager();
    private Metamodel metaModel;
    protected List<StructConverter> structConverters = null;
    public static final String STATE_INITIAL = "Initial";
    public static final String STATE_PREDEPLOYED = "Predeployed";
    public static final String STATE_HALF_DEPLOYED = "HalfDeployed";
    public static final String STATE_DEPLOYED = "Deployed";
    public static final String STATE_PREDEPLOY_FAILED = "PredeployFailed";
    public static final String STATE_DEPLOY_FAILED = "DeployFailed";
    public static final String STATE_UNDEPLOYED = "Undeployed";
    public static final String STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER = "HalfPredeployedCompositeMember";
    protected String state = "Initial";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";
    public static String[] connectionPropertyNames = new String[]{"javax.persistence.transactionType", "javax.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "javax.persistence.jdbc.url", "javax.persistence.jdbc.user", "eclipselink.nosql.connection-factory"};
    protected EntityManagerSetupImpl compositeEmSetupImpl;
    protected Set<EntityManagerSetupImpl> compositeMemberEmSetupImpls;
    PersistenceUnitProcessor.Mode mode;
    boolean throwExceptionOnFail;
    boolean weaveChangeTracking;
    boolean weaveLazy;
    boolean weaveEager;
    boolean weaveFetchGroups;
    boolean weaveInternal;
    boolean weaveRest;
    protected boolean isMetadataExpired = false;
    protected PersistenceException persistenceException;

    public EntityManagerSetupImpl(String persistenceUnitUniqueName, String sessionName) {
        this.persistenceUnitUniqueName = persistenceUnitUniqueName;
        this.sessionName = sessionName;
    }

    public EntityManagerSetupImpl() {
        this("", "");
    }

    public static String getOrBuildSessionName(Map properties, PersistenceUnitInfo puInfo, String persistenceUnitUniqueName) {
        String sessionName = (String)properties.get("eclipselink.session-name");
        if (sessionName == null) {
            sessionName = (String)puInfo.getProperties().get("eclipselink.session-name");
        }
        if (sessionName != null && sessionName.length() > 0) {
            return sessionName;
        }
        String applicationId = (String)properties.get("weblogic.application-id");
        if (EntityManagerSetupImpl.isComposite(puInfo)) {
            if (applicationId != null) {
                return String.valueOf(applicationId) + persistenceUnitUniqueName;
            }
            return persistenceUnitUniqueName;
        }
        if (applicationId != null) {
            return String.valueOf(applicationId) + persistenceUnitUniqueName + EntityManagerSetupImpl.buildSessionNameSuffixFromConnectionProperties(properties);
        }
        return String.valueOf(persistenceUnitUniqueName) + EntityManagerSetupImpl.buildSessionNameSuffixFromConnectionProperties(properties);
    }

    protected static String buildSessionNameSuffixFromConnectionProperties(Map properties) {
        String suffix = "";
        int i = 0;
        while (i < connectionPropertyNames.length) {
            String name = connectionPropertyNames[i];
            Object value = properties.get(name);
            if (value != null) {
                String strValue = null;
                strValue = value instanceof String ? (String)value : (value instanceof DataSource ? Integer.toString(System.identityHashCode(value)) : (value instanceof PersistenceUnitTransactionType ? value.toString() : Integer.toString(System.identityHashCode(value))));
                if (strValue.length() > 0) {
                    suffix = String.valueOf(suffix) + "_" + Helper.getShortClassName((String)name) + "=" + strValue;
                }
            }
            ++i;
        }
        return suffix;
    }

    public void changeSessionName(String newSessionName) {
        if (!this.session.getName().equals(newSessionName)) {
            this.session.log(1, "properties", "session_name_change", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), newSessionName});
            this.sessionName = newSessionName;
            this.session.setName(newSessionName);
        }
    }

    protected void removeSessionFromGlobalSessionManager() {
        if (this.session != null) {
            try {
                if (this.session.isConnected()) {
                    this.session.logout();
                }
            }
            finally {
                SessionManager.getManager().getSessions().remove(this.session.getName(), this.session);
            }
        }
    }

    public DatabaseSessionImpl deploy(ClassLoader realClassLoader, Map additionalProperties) {
        DatabaseSessionImpl databaseSessionImpl;
        if (this.state != STATE_PREDEPLOYED && this.state != STATE_DEPLOYED && this.state != STATE_HALF_DEPLOYED) {
            if (this.mustBeCompositeMember()) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.compositeMemberCannotBeUsedStandalone((String)this.persistenceUnitInfo.getPersistenceUnitName()));
            }
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)this.state, (Exception)((Object)this.persistenceException)));
        }
        this.session.log(1, "jpa", "deploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        ClassLoader classLoaderToUse = realClassLoader;
        if (additionalProperties.containsKey("eclipselink.classloader")) {
            classLoaderToUse = (ClassLoader)additionalProperties.get("eclipselink.classloader");
        }
        boolean isLockAcquired = false;
        try {
            Map deployProperties = EntityManagerFactoryProvider.mergeMaps(additionalProperties, this.persistenceUnitInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(deployProperties, (AbstractSession)this.session);
            if (this.isComposite()) {
                this.updateCompositeMembersProperties(deployProperties);
            }
            if (this.state == STATE_PREDEPLOYED) {
                this.deployLock.acquire();
                isLockAcquired = true;
                if (this.state == STATE_PREDEPLOYED) {
                    if (this.shouldBuildProject && !this.isSessionLoadedFromSessionsXML) {
                        if (this.isComposite()) {
                            this.deployCompositeMembers(deployProperties, classLoaderToUse);
                        } else {
                            Map<String, Object> metadataProperties;
                            if (this.processor.getMetadataSource() != null && (metadataProperties = this.processor.getMetadataSource().getPropertyOverrides(deployProperties, classLoaderToUse, this.session.getSessionLog())) != null && !metadataProperties.isEmpty()) {
                                EntityManagerFactoryProvider.translateOldProperties(metadataProperties, (AbstractSession)this.session);
                                deployProperties = EntityManagerFactoryProvider.mergeMaps(metadataProperties, deployProperties);
                            }
                            this.processor.setClassLoader(classLoaderToUse);
                            this.processor.createDynamicClasses();
                            this.processor.createRestInterfaces();
                            this.processor.addEntityListeners();
                            if (this.projectCacheAccessor != null) {
                                this.projectCacheAccessor.storeProject(this.session.getProject(), deployProperties, this.session.getSessionLog());
                            }
                            this.session.getProject().convertClassNamesToClasses(classLoaderToUse);
                            if (!this.isCompositeMember()) {
                                this.addBeanValidationListeners(deployProperties, classLoaderToUse);
                            }
                            this.processor.processCustomizers();
                        }
                        this.processor = null;
                    } else {
                        this.session.getProject().convertClassNamesToClasses(classLoaderToUse);
                        if (!this.shouldBuildProject) {
                            if (!this.isCompositeMember()) {
                                this.addBeanValidationListeners(deployProperties, classLoaderToUse);
                            }
                            this.processDescriptorsFromCachedProject(classLoaderToUse);
                        }
                    }
                    this.finishProcessingDescriptorEvents(classLoaderToUse);
                    this.structConverters = this.getStructConverters(classLoaderToUse);
                    this.initSession();
                    if (this.session.getIntegrityChecker().hasErrors()) {
                        this.session.handleException((RuntimeException)new IntegrityException(this.session.getIntegrityChecker()));
                    }
                    this.session.getDatasourcePlatform().getConversionManager().setLoader(classLoaderToUse);
                    this.state = STATE_HALF_DEPLOYED;
                } else {
                    this.deployLock.release();
                    isLockAcquired = false;
                    if (this.state == STATE_DEPLOY_FAILED) {
                        throw this.persistenceException;
                    }
                }
            }
            if (!this.isCompositeMember()) {
                if (!this.session.isConnected()) {
                    if (!isLockAcquired) {
                        this.deployLock.acquire();
                        isLockAcquired = true;
                    }
                    if (!this.session.isConnected()) {
                        if (this.state == STATE_DEPLOY_FAILED) {
                            throw this.persistenceException;
                        }
                        this.session.setProperties(deployProperties);
                        this.updateSession(deployProperties, classLoaderToUse);
                        if (this.isValidationOnly(deployProperties, false)) {
                            if (this.state == STATE_HALF_DEPLOYED) {
                                this.session.initializeDescriptors();
                                this.state = STATE_DEPLOYED;
                            }
                        } else {
                            try {
                                if (this.isSessionLoadedFromSessionsXML) {
                                    this.session.login();
                                } else {
                                    EntityManagerFactoryProvider.login(this.session, deployProperties);
                                }
                                this.state = STATE_DEPLOYED;
                            }
                            catch (Throwable loginException) {
                                if (this.state == STATE_HALF_DEPLOYED && this.session.isConnected()) {
                                    try {
                                        this.session.logout();
                                    }
                                    catch (Throwable throwable) {}
                                    this.state = STATE_DEPLOY_FAILED;
                                }
                                throw loginException;
                            }
                            if (!this.isSessionLoadedFromSessionsXML) {
                                this.addStructConverters();
                            }
                            this.generateDDL(deployProperties);
                        }
                    }
                    this.deployLock.release();
                    isLockAcquired = false;
                }
                try {
                    this.getMetamodel();
                }
                catch (Exception e) {
                    this.session.log(1, "metamodel", "metamodel_init_failed", new Object[]{e.getMessage()});
                }
            }
            if (this.weaver != null) {
                this.weaver.clear();
                this.weaver = null;
            }
            databaseSessionImpl = this.session;
        }
        catch (Throwable exception) {
            try {
                if (this.state == STATE_PREDEPLOYED) {
                    this.state = STATE_DEPLOY_FAILED;
                }
                PersistenceException persistenceEx = this.state == STATE_DEPLOY_FAILED ? (exception == this.persistenceException ? new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)this.state, (Exception)((Object)this.persistenceException))) : this.createDeployFailedPersistenceException(exception)) : (exception instanceof PersistenceException ? (PersistenceException)exception : new PersistenceException(exception));
                if (isLockAcquired) {
                    this.deployLock.release();
                }
                this.session.logThrowable(7, "ejb", exception);
                throw persistenceEx;
            }
            catch (Throwable throwable) {
                this.session.log(1, "jpa", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                throw throwable;
            }
        }
        this.session.log(1, "jpa", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        return databaseSessionImpl;
    }

    private void processDescriptorsFromCachedProject(ClassLoader realClassLoader) throws ClassNotFoundException, PrivilegedActionException, IllegalAccessException, InstantiationException {
        for (ClassDescriptor descriptor : this.session.getProject().getDescriptors().values()) {
            if (descriptor.getDescriptorCustomizerClassName() == null) continue;
            Class listenerClass = EntityManagerSetupImpl.findClass(descriptor.getDescriptorCustomizerClassName(), realClassLoader);
            DescriptorCustomizer customizer = (DescriptorCustomizer)EntityManagerSetupImpl.buildObjectForClass(listenerClass, DescriptorCustomizer.class);
            try {
                customizer.customize(descriptor);
            }
            catch (Exception e) {
                this.session.getSessionLog().logThrowable(2, "metadata", (Throwable)e);
            }
        }
    }

    private void finishProcessingDescriptorEvents(ClassLoader realClassLoader) {
        for (ClassDescriptor descriptor : this.session.getProject().getDescriptors().values()) {
            if (!descriptor.hasEventManager()) continue;
            descriptor.getEventManager().processDescriptorEventHolders(realClassLoader);
        }
    }

    protected PersistenceException createDeployFailedPersistenceException(Throwable ex) {
        PersistenceException perEx = new PersistenceException((Throwable)EntityManagerSetupException.deployFailed((String)this.persistenceUnitInfo.getPersistenceUnitName(), (Throwable)ex));
        if (this.persistenceException == null) {
            this.persistenceException = perEx;
        }
        return perEx;
    }

    protected void addProjectToSession(ServerSession session, Project project) {
        DatasourcePlatform sessionPlatform = (DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform projectPlatform = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!sessionPlatform.hasDefaultSequence() && projectPlatform.hasDefaultSequence()) {
            sessionPlatform.setDefaultSequence(projectPlatform.getDefaultSequence());
        }
        if (sessionPlatform.getSequences() == null || sessionPlatform.getSequences().isEmpty()) {
            if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
                sessionPlatform.setSequences(projectPlatform.getSequences());
            }
        } else if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
            for (Sequence sequence : projectPlatform.getSequences().values()) {
                if (sessionPlatform.getSequences().containsKey(sequence.getName())) continue;
                sessionPlatform.addSequence(sequence);
            }
        }
        session.addDescriptors(project);
    }

    protected void addSessionToGlobalSessionManager() {
        AbstractSession oldSession = (AbstractSession)SessionManager.getManager().getSessions().get(this.session.getName());
        if (oldSession != null) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.attemptedRedeployWithoutClose((String)this.session.getName()));
        }
        SessionManager.getManager().addSession((Session)this.session);
    }

    public void addStructConverters() {
        if (this.compositeMemberEmSetupImpls == null) {
            for (StructConverter structConverter : this.structConverters) {
                if (this.session.getPlatform().getTypeConverters().get(structConverter.getJavaType()) != null) {
                    throw ValidationException.twoStructConvertersAddedForSameClass((String)structConverter.getJavaType().getName());
                }
                this.session.getPlatform().addStructConverter(structConverter);
            }
        } else {
            for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                if (compositeMemberEmSetupImpl.structConverters.isEmpty()) continue;
                String compositeMemberPuName = compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName();
                compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_begin_call", new Object[]{"addStructConverters", compositeMemberPuName, this.state});
                compositeMemberEmSetupImpl.addStructConverters();
                compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_end_call", new Object[]{"addStructConverters", compositeMemberPuName, this.state});
            }
        }
    }

    protected void assignCMP3Policy() {
        Project project = this.session.getProject();
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            OptimisticLockingPolicy olp;
            if (descriptor.getCMPPolicy() == null) {
                descriptor.setCMPPolicy((CMPPolicy)new CMP3Policy());
            }
            if ((olp = descriptor.getOptimisticLockingPolicy()) == null || olp.getLockOnChangeMode() != null) continue;
            olp.setLockOnChangeMode(OptimisticLockingPolicy.LockOnChange.OWNING);
        }
    }

    protected boolean updateServerPlatform(Map m, ClassLoader loader) {
        String serverPlatformClassName = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.target-server", (Map)m, (AbstractSession)this.session);
        if (serverPlatformClassName == null) {
            return false;
        }
        ServerPlatform originalServerPlatform = this.session.getServerPlatform();
        String originalServerPlatformClassName = originalServerPlatform.getClass().getName();
        if (originalServerPlatformClassName.equals(serverPlatformClassName)) {
            return false;
        }
        ServerPlatform serverPlatform = null;
        Class cls = EntityManagerSetupImpl.findClassForProperty(serverPlatformClassName, "eclipselink.target-server", loader);
        try {
            Constructor constructor = cls.getConstructor(DatabaseSession.class);
            serverPlatform = (ServerPlatform)constructor.newInstance(this.session);
        }
        catch (Exception ex) {
            if (ExternalTransactionController.class.isAssignableFrom(cls)) {
                if (originalServerPlatform.getClass().equals(CustomServerPlatform.class)) {
                    CustomServerPlatform originalCustomServerPlatform = (CustomServerPlatform)originalServerPlatform;
                    if (!cls.equals(originalCustomServerPlatform.getExternalTransactionControllerClass())) {
                        originalCustomServerPlatform.setExternalTransactionControllerClass(cls);
                    }
                } else {
                    CustomServerPlatform customServerPlatform = new CustomServerPlatform((DatabaseSession)this.session);
                    customServerPlatform.setExternalTransactionControllerClass(cls);
                    serverPlatform = customServerPlatform;
                }
            }
            throw EntityManagerSetupException.failedToInstantiateServerPlatform((String)serverPlatformClassName, (String)"eclipselink.target-server", (Exception)ex);
        }
        if (serverPlatform != null) {
            this.session.setServerPlatform(serverPlatform);
            return true;
        }
        return false;
    }

    protected void updatePartitioning(Map m, ClassLoader loader) {
        String callbackClassName;
        String partitioning = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.partitioning", m, (AbstractSession)this.session);
        if (partitioning != null) {
            PartitioningPolicy partitioningPolicy = this.session.getProject().getPartitioningPolicy(partitioning);
            if (partitioningPolicy == null) {
                throw DescriptorException.missingPartitioningPolicy((String)partitioning, null, null);
            }
            this.session.setPartitioningPolicy(partitioningPolicy);
        }
        if ((callbackClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.partitioning.callback", m, (AbstractSession)this.session)) != null) {
            Class cls = EntityManagerSetupImpl.findClassForProperty(callbackClassName, "eclipselink.partitioning.callback", loader);
            DataPartitioningCallback callback = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                callback = (DataPartitioningCallback)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateProperty((String)callbackClassName, (String)"eclipselink.partitioning.callback", (Exception)exception);
            }
            this.session.getLogin().setPartitioningCallback(callback);
        }
    }

    protected void updateDatabaseEventListener(Map m, ClassLoader loader) {
        String listenerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.database-event-listener", m, (AbstractSession)this.session);
        if (listenerClassName != null) {
            if (listenerClassName.equalsIgnoreCase("DCN") || listenerClassName.equalsIgnoreCase("QCN")) {
                listenerClassName = "org.eclipse.persistence.platform.database.oracle.dcn.OracleChangeNotificationListener";
            }
            Class cls = EntityManagerSetupImpl.findClassForProperty(listenerClassName, "eclipselink.cache.database-event-listener", loader);
            DatabaseEventListener listener = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                listener = (DatabaseEventListener)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateProperty((String)listenerClassName, (String)"eclipselink.cache.database-event-listener", (Exception)exception);
            }
            this.session.setDatabaseEventListener(listener);
        }
    }

    protected void updateLoggers(Map persistenceProperties, boolean serverPlatformChanged, ClassLoader loader) {
        block15: {
            String loggerClassName = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.logging.logger", (Map)persistenceProperties, (AbstractSession)this.session);
            SessionLog singletonLog = null;
            SessionLog sessionLog = null;
            if (loggerClassName != null) {
                SessionLog currentLog = this.session.getSessionLog();
                if (loggerClassName.equals("ServerLogger")) {
                    ServerPlatform serverPlatform = this.session.getServerPlatform();
                    singletonLog = serverPlatform.getServerLog();
                    sessionLog = serverPlatform.getServerLog();
                } else if (!currentLog.getClass().getName().equals(loggerClassName)) {
                    Class sessionLogClass = EntityManagerSetupImpl.findClassForProperty(loggerClassName, "eclipselink.logging.logger", loader);
                    try {
                        singletonLog = (SessionLog)sessionLogClass.newInstance();
                        sessionLog = (SessionLog)sessionLogClass.newInstance();
                    }
                    catch (Exception ex) {
                        throw EntityManagerSetupException.failedToInstantiateLogger((String)loggerClassName, (String)"eclipselink.logging.logger", (Exception)ex);
                    }
                }
            } else if (serverPlatformChanged) {
                ServerPlatform serverPlatform = this.session.getServerPlatform();
                singletonLog = serverPlatform.getServerLog();
                sessionLog = serverPlatform.getServerLog();
            }
            if (singletonLog != null && sessionLog != null) {
                AbstractSessionLog.setLog(singletonLog);
                this.session.setSessionLog(sessionLog);
            }
            this.initOrUpdateLogging(persistenceProperties, AbstractSessionLog.getLog());
            this.initOrUpdateLogging(persistenceProperties, this.session.getSessionLog());
            String loggingFileString = (String)persistenceProperties.get("eclipselink.logging.file");
            if (loggingFileString != null) {
                if (!loggingFileString.trim().equals("")) {
                    try {
                        if (sessionLog == null) break block15;
                        if (sessionLog instanceof AbstractSessionLog) {
                            FileOutputStream fos = new FileOutputStream(loggingFileString);
                            ((AbstractSessionLog)sessionLog).setWriter((OutputStream)fos);
                            break block15;
                        }
                        FileWriter fw = new FileWriter(loggingFileString);
                        sessionLog.setWriter((Writer)fw);
                    }
                    catch (IOException e) {
                        this.session.handleException((RuntimeException)ValidationException.invalidLoggingFile((String)loggingFileString, (Exception)e));
                    }
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidLoggingFile());
                }
            }
        }
    }

    protected void updateProfiler(Map persistenceProperties, ClassLoader loader) {
        String newProfilerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.profiler", persistenceProperties, (AbstractSession)this.session);
        if (newProfilerClassName == null) {
            ((ServerPlatformBase)this.session.getServerPlatform()).configureProfiler((Session)this.session);
        } else {
            if (newProfilerClassName.equals("NoProfiler")) {
                this.session.setProfiler(null);
                return;
            }
            if (newProfilerClassName.equals("QueryMonitor")) {
                this.session.setProfiler(null);
                QueryMonitor.shouldMonitor = true;
                return;
            }
            if (newProfilerClassName.equals("PerformanceProfiler")) {
                this.session.setProfiler((SessionProfiler)new PerformanceProfiler());
                return;
            }
            if (newProfilerClassName.equals("PerformanceMonitor")) {
                this.session.setProfiler((SessionProfiler)new PerformanceMonitor());
                return;
            }
            if (newProfilerClassName.equals("DMSProfiler")) {
                newProfilerClassName = "org.eclipse.persistence.tools.profiler.oracle.DMSPerformanceProfiler";
            }
            String originalProfilerClassNamer = null;
            if (this.session.getProfiler() != null && (originalProfilerClassNamer = this.session.getProfiler().getClass().getName()).equals(newProfilerClassName)) {
                return;
            }
            try {
                Class newProfilerClass = EntityManagerSetupImpl.findClassForProperty(newProfilerClassName, "eclipselink.profiler", loader);
                SessionProfiler sessionProfiler = (SessionProfiler)EntityManagerSetupImpl.buildObjectForClass(newProfilerClass, SessionProfiler.class);
                if (sessionProfiler != null) {
                    this.session.setProfiler(sessionProfiler);
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidProfilerClass((String)newProfilerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateProfilerClass((String)newProfilerClassName, (Exception)e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateProfilerClass((String)newProfilerClassName, (Exception)e));
            }
            catch (InstantiationException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateProfilerClass((String)newProfilerClassName, (Exception)e));
            }
        }
    }

    protected static Class findClass(String className, ClassLoader loader) throws ClassNotFoundException, PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, loader));
        }
        return PrivilegedAccessHelper.getClassForName((String)className, (boolean)true, (ClassLoader)loader);
    }

    protected static Class findClassForProperty(String className, String propertyName, ClassLoader loader) {
        try {
            return EntityManagerSetupImpl.findClass(className, loader);
        }
        catch (PrivilegedActionException exception1) {
            throw EntityManagerSetupException.classNotFoundForProperty((String)className, (String)propertyName, (Exception)exception1.getException());
        }
        catch (ClassNotFoundException exception2) {
            throw EntityManagerSetupException.classNotFoundForProperty((String)className, (String)propertyName, (Exception)exception2);
        }
    }

    protected List<StructConverter> getStructConverters(ClassLoader realClassLoader) {
        ArrayList<StructConverter> structConverters = new ArrayList<StructConverter>();
        if (this.session.getProject().getStructConverters() != null) {
            for (String converter : this.session.getProject().getStructConverters()) {
                Class clazz = null;
                try {
                    clazz = EntityManagerSetupImpl.findClass(converter, realClassLoader);
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass((String)converter, (Exception)exception.getException());
                }
                catch (ClassNotFoundException exception) {
                    throw ValidationException.unableToLoadClass((String)converter, (Exception)exception);
                }
                try {
                    structConverters.add((StructConverter)EntityManagerSetupImpl.buildObjectForClass(clazz, clazz));
                }
                catch (PrivilegedActionException e) {
                    throw ValidationException.errorInstantiatingClass((Object)clazz, (Exception)e.getException());
                }
                catch (IllegalAccessException e) {
                    throw ValidationException.errorInstantiatingClass((Object)clazz, (Exception)e);
                }
                catch (InstantiationException e) {
                    throw ValidationException.errorInstantiatingClass((Object)clazz, (Exception)e);
                }
            }
        }
        return structConverters;
    }

    public DatabaseSessionImpl getSession() {
        return this.session;
    }

    protected static Object buildObjectForClass(Class clazz, Class mustBeImplementedInterface) throws IllegalAccessException, PrivilegedActionException, InstantiationException {
        if (clazz != null && Helper.classImplementsInterface((Class)clazz, (Class)mustBeImplementedInterface)) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
            }
            return PrivilegedAccessHelper.newInstanceFromClass((Class)clazz);
        }
        return null;
    }

    protected void updateDescriptorCacheSettings(Map m, ClassLoader loader) {
        Map typeMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.cache.type.", (Map)m, (AbstractSession)this.session);
        Map sizeMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.cache.size.", (Map)m, (AbstractSession)this.session);
        Map sharedMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.cache.shared.", (Map)m, (AbstractSession)this.session);
        if (typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty()) {
            return;
        }
        String defaultTypeName = (String)typeMap.remove("default");
        if (defaultTypeName != null) {
            Class defaultType = EntityManagerSetupImpl.findClassForProperty(defaultTypeName, "eclipselink.cache.type.default", this.getClass().getClassLoader());
            this.session.getProject().setDefaultIdentityMapClass(defaultType);
        }
        String value = null;
        try {
            String defaultSharedString;
            String defaultSizeString = (String)sizeMap.remove("default");
            if (defaultSizeString != null) {
                value = defaultSizeString;
                int defaultSize = Integer.parseInt(defaultSizeString);
                this.session.getProject().setDefaultIdentityMapSize(defaultSize);
            }
            if ((defaultSharedString = (String)sharedMap.remove("default")) != null) {
                boolean defaultShared = Boolean.parseBoolean(defaultSharedString);
                this.session.getProject().setDefaultIsIsolated(!defaultShared);
            }
            Iterator it = this.session.getDescriptors().values().iterator();
            while (!(!it.hasNext() || typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty())) {
                String sharedString;
                String sizeString;
                ClassDescriptor descriptor = (ClassDescriptor)it.next();
                if (descriptor.isDescriptorTypeAggregate()) continue;
                String entityName = descriptor.getAlias();
                String className = descriptor.getJavaClass().getName();
                String name = entityName;
                String typeName = (String)typeMap.remove(name);
                if (typeName == null) {
                    name = className;
                    typeName = (String)typeMap.remove(name);
                }
                if (typeName != null) {
                    Class type = EntityManagerSetupImpl.findClassForProperty(typeName, "eclipselink.cache.type." + name, this.getClass().getClassLoader());
                    descriptor.setIdentityMapClass(type);
                }
                if ((sizeString = (String)sizeMap.remove(name = entityName)) == null) {
                    name = className;
                    sizeString = (String)sizeMap.remove(name);
                }
                if (sizeString != null) {
                    value = sizeString;
                    int size = Integer.parseInt(sizeString);
                    descriptor.setIdentityMapSize(size);
                }
                if ((sharedString = (String)sharedMap.remove(name = entityName)) == null) {
                    name = className;
                    sharedString = (String)sharedMap.remove(name);
                }
                if (sharedString == null) continue;
                boolean shared = Boolean.parseBoolean(sharedString);
                descriptor.setIsIsolated(!shared);
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty(value, (String)"eclipselink.cache.size.", (Exception)exception));
        }
    }

    protected void updateConnectionSettings(ServerSession serverSession, Map properties) {
        Map connectionsMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.connection-pool.", (Map)properties, (AbstractSession)serverSession);
        if (connectionsMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : connectionsMap.entrySet()) {
            String poolName = "default";
            String attribute = null;
            try {
                boolean shared;
                if (((String)entry.getKey()).indexOf(".") == -1) {
                    attribute = (String)entry.getKey();
                } else {
                    poolName = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("."));
                    attribute = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(".") + 1, ((String)entry.getKey()).length());
                }
                Object pool = null;
                if (poolName.equals("write")) {
                    poolName = "default";
                }
                if (poolName.equals("read")) {
                    pool = serverSession.getReadConnectionPool();
                    if (pool == null || pool == serverSession.getDefaultConnectionPool()) {
                        pool = this.session.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                        serverSession.setReadConnectionPool(pool);
                    }
                } else if (poolName.equals("sequence")) {
                    pool = this.session.getSequencingControl().getConnectionPool();
                    if (pool == null) {
                        pool = this.session.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                        this.session.getSequencingControl().setConnectionPool(pool);
                    }
                } else {
                    pool = serverSession.getConnectionPool(poolName);
                    if (pool == null) {
                        pool = this.session.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                        serverSession.addConnectionPool(pool);
                    }
                }
                if (attribute.equals("initial")) {
                    pool.setInitialNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("min")) {
                    pool.setMinNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("max")) {
                    pool.setMaxNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("url")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setURL((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("nonJtaDataSource")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).useDataSource((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("jtaDataSource")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).useDataSource((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("user")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setUserName((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("password")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setPassword((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("wait")) {
                    pool.setWaitTimeout(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("failover")) {
                    String failoverPools = (String)entry.getValue();
                    if (failoverPools.indexOf(44) != -1 || failoverPools.indexOf(32) != -1) {
                        StringTokenizer tokenizer = new StringTokenizer(failoverPools, " ,");
                        while (tokenizer.hasMoreTokens()) {
                            pool.addFailoverConnectionPool(tokenizer.nextToken());
                        }
                        continue;
                    }
                    pool.addFailoverConnectionPool((String)entry.getValue());
                    continue;
                }
                if (!poolName.equals("read") || !attribute.equals("shared") || !(shared = Boolean.parseBoolean((String)entry.getValue()))) continue;
                ReadConnectionPool readPool = new ReadConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                readPool.setInitialNumberOfConnections(pool.getInitialNumberOfConnections());
                readPool.setMinNumberOfConnections(pool.getMinNumberOfConnections());
                readPool.setMaxNumberOfConnections(pool.getMaxNumberOfConnections());
                readPool.setWaitTimeout(pool.getWaitTimeout());
                readPool.setLogin(pool.getLogin());
                serverSession.setReadConnectionPool((ConnectionPool)readPool);
            }
            catch (RuntimeException exception) {
                this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty(entry.getValue(), (String)((String)entry.getKey()), (Exception)exception));
            }
        }
    }

    protected void updateConnectionPolicy(ServerSession serverSession, Map m) {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", m, (AbstractSession)this.session);
        if (isLazyString != null) {
            serverSession.getDefaultConnectionPolicy().setIsLazy(Boolean.parseBoolean(isLazyString));
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(m, (AbstractSession)this.session, true)) != null) {
            serverSession.getDefaultConnectionPolicy().setExclusiveMode(exclusiveMode);
        }
    }

    public static ConnectionPolicy.ExclusiveMode getConnectionPolicyExclusiveModeFromProperties(Map m, AbstractSession abstractSession, boolean useSystemAsDefault) {
        String exclusiveConnectionModeString = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.jdbc.exclusive-connection.mode", (Map)m, (AbstractSession)abstractSession, (boolean)useSystemAsDefault);
        if (exclusiveConnectionModeString != null) {
            if (exclusiveConnectionModeString == "Isolated") {
                return ConnectionPolicy.ExclusiveMode.Isolated;
            }
            if (exclusiveConnectionModeString == "Always") {
                return ConnectionPolicy.ExclusiveMode.Always;
            }
            return ConnectionPolicy.ExclusiveMode.Transactional;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized ClassTransformer predeploy(PersistenceUnitInfo info, Map extendedProperties) {
        ClassLoader classLoaderToUse = null;
        if (this.state == STATE_DEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotPredeploy((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)this.state, (Exception)((Object)this.persistenceException)));
        }
        if (this.state == STATE_PREDEPLOYED || this.state == STATE_DEPLOYED || this.state == STATE_HALF_DEPLOYED) {
            this.session.log(1, "jpa", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            ++this.factoryCount;
            this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            return null;
        }
        if (this.state == STATE_INITIAL) {
            this.persistenceUnitInfo = info;
            if (!this.isCompositeMember() && EntityManagerSetupImpl.mustBeCompositeMember(this.persistenceUnitInfo)) {
                if (this.staticWeaveInfo == null) {
                    return null;
                }
                throw new PersistenceException((Throwable)EntityManagerSetupException.compositeMemberCannotBeUsedStandalone((String)this.persistenceUnitInfo.getPersistenceUnitName()));
            }
        } else if (this.state == STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
            this.session.log(1, "jpa", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), String.valueOf(this.state) + " " + (Object)((Object)this.mode), this.factoryCount});
        }
        try {
            Map predeployProperties = null;
            boolean isComposite = false;
            if (this.state != STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
                Project project;
                classLoaderToUse = this.persistenceUnitInfo.getClassLoader();
                predeployProperties = EntityManagerFactoryProvider.mergeMaps(extendedProperties, this.persistenceUnitInfo.getProperties());
                EntityManagerFactoryProvider.translateOldProperties(predeployProperties, null);
                String sessionsXMLStr = (String)predeployProperties.get("eclipselink.sessions-xml");
                if (sessionsXMLStr != null) {
                    this.isSessionLoadedFromSessionsXML = true;
                }
                if (isComposite = EntityManagerSetupImpl.isComposite(this.persistenceUnitInfo)) {
                    if (this.isSessionLoadedFromSessionsXML) {
                        throw EntityManagerSetupException.compositeIncompatibleWithSessionsXml((String)this.persistenceUnitInfo.getPersistenceUnitName());
                    }
                    this.session = new SessionBroker();
                    ((SessionBroker)this.session).setShouldUseDescriptorAliases(true);
                } else {
                    this.session = new ServerSession(new Project(new DatabaseLogin()));
                    this.session.setRefreshMetadataListener((MetadataRefreshListener)this);
                }
                this.session.setName(this.sessionName);
                if (this.compositeEmSetupImpl == null) {
                    if (this.staticWeaveInfo == null) {
                        this.updateServerPlatform(predeployProperties, classLoaderToUse);
                        this.updateLoggers(predeployProperties, true, classLoaderToUse);
                        this.updateProfiler(predeployProperties, classLoaderToUse);
                    } else {
                        Writer writer = this.staticWeaveInfo.getLogWriter();
                        if (writer != null) {
                            ((DefaultSessionLog)this.session.getSessionLog()).setWriter(writer);
                        }
                        this.session.setLogLevel(this.staticWeaveInfo.getLogLevel());
                    }
                } else {
                    this.session.setSessionLog(this.compositeEmSetupImpl.session.getSessionLog());
                    this.session.setProfiler(this.compositeEmSetupImpl.session.getProfiler());
                }
                this.session.log(1, "jpa", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                this.updateProjectCache(predeployProperties, classLoaderToUse);
                if (this.projectCacheAccessor != null && (project = this.projectCacheAccessor.retrieveProject(predeployProperties, classLoaderToUse, this.session.getSessionLog())) != null) {
                    try {
                        DatabaseSessionImpl tempSession = (DatabaseSessionImpl)project.createServerSession();
                        tempSession.setName(this.sessionName);
                        tempSession.setSessionLog(this.session.getSessionLog());
                        tempSession.getSessionLog().setSession((Session)tempSession);
                        if (this.staticWeaveInfo != null) {
                            tempSession.setLogLevel(this.staticWeaveInfo.getLogLevel());
                        }
                        tempSession.setProfiler(this.session.getProfiler());
                        tempSession.setRefreshMetadataListener((MetadataRefreshListener)this);
                        this.session = tempSession;
                        this.updateServerPlatform(predeployProperties, classLoaderToUse);
                        this.shouldBuildProject = false;
                    }
                    catch (Exception e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }
                if (this.isSessionLoadedFromSessionsXML) {
                    if (this.compositeEmSetupImpl == null && this.staticWeaveInfo == null) {
                        JPAClassLoaderHolder privateClassLoaderHolder = this.session.getServerPlatform().getNewTempClassLoader(this.persistenceUnitInfo);
                        classLoaderToUse = privateClassLoaderHolder.getClassLoader();
                    } else {
                        classLoaderToUse = this.persistenceUnitInfo.getNewTempClassLoader();
                    }
                    String tempSessionName = this.sessionName;
                    if (this.isCompositeMember()) {
                        tempSessionName = (String)predeployProperties.get("eclipselink.session-name");
                    }
                    this.session.log(1, "properties", "loading_session_xml", (Object)sessionsXMLStr, (Object)tempSessionName);
                    if (tempSessionName == null) {
                        throw EntityManagerSetupException.sessionNameNeedBeSpecified((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)sessionsXMLStr);
                    }
                    XMLSessionConfigLoader xmlLoader = new XMLSessionConfigLoader(sessionsXMLStr);
                    AbstractSession tempSession = new SessionManager().getSession(xmlLoader, tempSessionName, classLoaderToUse, false, false);
                    this.session.log(1, "properties", "sessions_xml_path_where_session_load_from", (Object)xmlLoader.getSessionName(), (Object)xmlLoader.getResourcePath());
                    if (tempSession == null) {
                        throw ValidationException.noSessionFound((String)this.sessionName, (String)sessionsXMLStr);
                    }
                    if (tempSession.isServerSession() || tempSession.isSessionBroker()) {
                        this.session = (DatabaseSessionImpl)tempSession;
                        if (tempSessionName != this.sessionName) {
                            this.session.setName(this.sessionName);
                        }
                    } else {
                        throw EntityManagerSetupException.sessionLoadedFromSessionsXMLMustBeServerSession((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)((String)predeployProperties.get("eclipselink.sessions-xml")), (Object)tempSession);
                    }
                    if (this.staticWeaveInfo == null) {
                        this.updateServerPlatform(predeployProperties, classLoaderToUse);
                        this.updateLoggers(predeployProperties, true, classLoaderToUse);
                    }
                } else {
                    classLoaderToUse = this.persistenceUnitInfo.getClassLoader();
                }
                EntityManagerFactoryProvider.warnOldProperties(predeployProperties, (AbstractSession)this.session);
                this.session.getPlatform().setConversionManager((ConversionManager)new JPAConversionManager());
                if (this.staticWeaveInfo == null) {
                    if (!isComposite) {
                        PersistenceUnitTransactionType transactionType = null;
                        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", predeployProperties, (AbstractSession)this.session);
                        if (transTypeString != null && transTypeString.length() > 0) {
                            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
                        } else if (this.persistenceUnitInfo != null) {
                            transactionType = this.persistenceUnitInfo.getTransactionType();
                        }
                        if (!this.isValidationOnly(predeployProperties, false) && this.persistenceUnitInfo != null && transactionType == PersistenceUnitTransactionType.JTA && predeployProperties.get("javax.persistence.jtaDataSource") == null && this.persistenceUnitInfo.getJtaDataSource() == null) {
                            throw EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource((String)this.persistenceUnitInfo.getPersistenceUnitName());
                        }
                    }
                    if (this.state == STATE_INITIAL) {
                        String weaving;
                        if (this.compositeEmSetupImpl == null) {
                            if (this.enableWeaving == null) {
                                this.enableWeaving = Boolean.TRUE;
                            }
                            this.isWeavingStatic = false;
                            weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", predeployProperties);
                            if (weaving != null && weaving.equalsIgnoreCase("false")) {
                                this.enableWeaving = Boolean.FALSE;
                            } else if (weaving != null && weaving.equalsIgnoreCase("static")) {
                                this.isWeavingStatic = true;
                            }
                        } else {
                            if (!this.compositeEmSetupImpl.enableWeaving.booleanValue()) {
                                this.enableWeaving = Boolean.FALSE;
                            } else {
                                if (this.enableWeaving == null) {
                                    this.enableWeaving = Boolean.TRUE;
                                }
                                if ((weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", predeployProperties)) != null && weaving.equalsIgnoreCase("false")) {
                                    this.enableWeaving = Boolean.FALSE;
                                }
                            }
                            this.isWeavingStatic = this.compositeEmSetupImpl.isWeavingStatic;
                        }
                    }
                    this.throwExceptionOnFail = this.compositeEmSetupImpl == null ? "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.orm.throw.exceptions", predeployProperties, "true", (AbstractSession)this.session)) : this.compositeEmSetupImpl.throwExceptionOnFail;
                } else {
                    this.enableWeaving = Boolean.TRUE;
                }
                this.weaveChangeTracking = false;
                this.weaveLazy = false;
                this.weaveEager = false;
                this.weaveFetchGroups = false;
                this.weaveInternal = false;
                this.weaveRest = false;
                if (this.enableWeaving.booleanValue()) {
                    this.weaveChangeTracking = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.changetracking", predeployProperties, "true", (AbstractSession)this.session));
                    this.weaveLazy = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.lazy", predeployProperties, "true", (AbstractSession)this.session));
                    this.weaveEager = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.eager", predeployProperties, "false", (AbstractSession)this.session));
                    this.weaveFetchGroups = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.fetchgroups", predeployProperties, "true", (AbstractSession)this.session));
                    this.weaveInternal = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.internal", predeployProperties, "true", (AbstractSession)this.session));
                    this.weaveRest = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.rest", predeployProperties, "true", (AbstractSession)this.session));
                }
            }
            if (this.shouldBuildProject && !this.isSessionLoadedFromSessionsXML) {
                if (isComposite) {
                    this.predeployCompositeMembers(predeployProperties, classLoaderToUse);
                } else {
                    MetadataProcessor compositeProcessor = null;
                    if (this.compositeEmSetupImpl == null) {
                        this.mode = PersistenceUnitProcessor.Mode.ALL;
                    } else {
                        if (this.state != STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
                            this.state = STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER;
                            this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL;
                        }
                        compositeProcessor = this.compositeEmSetupImpl.processor;
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.ALL || this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
                        boolean usesMultitenantSharedEmf = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-emf", predeployProperties, "true", (AbstractSession)this.session));
                        boolean usesMultitenantSharedCache = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-cache", predeployProperties, "false", (AbstractSession)this.session));
                        this.processor = new MetadataProcessor(this.persistenceUnitInfo, (AbstractSession)this.session, classLoaderToUse, this.weaveLazy, this.weaveEager, this.weaveFetchGroups, usesMultitenantSharedEmf, usesMultitenantSharedCache, predeployProperties, compositeProcessor);
                        this.updateMetadataRepository(predeployProperties, classLoaderToUse);
                        EntityManagerSetupImpl.updateCaseSensitivitySettings(predeployProperties, this.processor.getProject(), (AbstractSession)this.session);
                    }
                    PersistenceUnitProcessor.processORMetadata(this.processor, this.throwExceptionOnFail, this.mode);
                    if (this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
                        this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE;
                        this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), String.valueOf(this.state) + " " + (Object)((Object)this.mode), this.factoryCount});
                        return null;
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE) {
                        this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_FINAL;
                        this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), String.valueOf(this.state) + " " + (Object)((Object)this.mode), this.factoryCount});
                        return null;
                    }
                    this.mode = null;
                    if (this.session.getIntegrityChecker().hasErrors()) {
                        this.session.handleException((RuntimeException)new IntegrityException(this.session.getIntegrityChecker()));
                    }
                    if (this.enableWeaving.booleanValue()) {
                        Collection<MetadataClass> entities = PersistenceUnitProcessor.buildEntityList(this.processor, classLoaderToUse);
                        this.weaver = TransformerFactory.createTransformerAndModifyProject((Session)this.session, entities, classLoaderToUse, this.weaveLazy, this.weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal, this.weaveRest);
                        this.session.getProject().setClassNamesForWeaving(new ArrayList<String>(this.processor.getProject().getWeavableClassNames()));
                    }
                    this.processor.addNamedQueries();
                    this.processor.addStructConverterNames();
                }
            } else if (this.enableWeaving.booleanValue()) {
                ArrayList<MetadataClass> persistenceClasses = new ArrayList<MetadataClass>();
                MetadataAsmFactory factory = new MetadataAsmFactory(new MetadataLogger((AbstractSession)this.session), classLoaderToUse);
                if (this.shouldBuildProject) {
                    Iterator iterator = this.session.getProject().getDescriptors().keySet().iterator();
                    while (iterator.hasNext()) {
                        persistenceClasses.add(factory.getMetadataClass(((Class)iterator.next()).getName()));
                    }
                } else {
                    for (String className : this.session.getProject().getClassNamesForWeaving()) {
                        persistenceClasses.add(factory.getMetadataClass(className));
                    }
                }
                this.weaver = TransformerFactory.createTransformerAndModifyProject((Session)this.session, persistenceClasses, classLoaderToUse, this.weaveLazy, this.weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal, this.weaveRest);
            }
            if (!this.isCompositeMember() && (this.state != STATE_INITIAL || this.isInContainerMode())) {
                ++this.factoryCount;
            }
            this.state = STATE_PREDEPLOYED;
            this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            if (this.isWeavingStatic) {
                return null;
            }
            return this.weaver;
        }
        catch (Throwable ex) {
            this.state = STATE_PREDEPLOY_FAILED;
            PersistenceException persistenceEx = this.createPredeployFailedPersistenceException(ex);
            this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            this.session = null;
            this.mode = null;
            throw persistenceEx;
        }
    }

    protected PersistenceException createPredeployFailedPersistenceException(Throwable ex) {
        PersistenceException perEx = new PersistenceException((Throwable)EntityManagerSetupException.predeployFailed((String)this.persistenceUnitInfo.getPersistenceUnitName(), (Throwable)ex));
        if (this.persistenceException == null) {
            this.persistenceException = perEx;
        }
        return perEx;
    }

    public String getDeployedSessionName() {
        return this.session != null ? this.session.getName() : null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public boolean isValidationOnly(Map m) {
        return this.isValidationOnly(m, true);
    }

    protected boolean isValidationOnly(Map m, boolean shouldMergeMap) {
        String validationOnlyString;
        if (shouldMergeMap) {
            m = this.mergeWithExistingMap(m);
        }
        if ((validationOnlyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.validation-only", m, (AbstractSession)this.session)) != null) {
            return Boolean.parseBoolean(validationOnlyString);
        }
        return false;
    }

    public boolean shouldGetSessionOnCreateFactory(Map m) {
        if (this.isValidationOnly(m = this.mergeWithExistingMap(m), false)) {
            return true;
        }
        String deployString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.deploy-on-startup", m, (AbstractSession)this.session);
        if (deployString != null) {
            return Boolean.parseBoolean(deployString);
        }
        return false;
    }

    protected Map mergeWithExistingMap(Map m) {
        if (this.persistenceUnitInfo != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.persistenceUnitInfo.getProperties());
        }
        return m;
    }

    public boolean isInContainerMode() {
        return this.isInContainerMode;
    }

    protected void updateCacheCoordination(Map m, ClassLoader loader) {
        String protocol = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.protocol", m, (AbstractSession)this.session);
        String value = "";
        String property = "";
        try {
            if (protocol != null) {
                String channel;
                String asynch;
                String removeOnError;
                String context;
                String password;
                String user;
                String naming;
                RemoteCommandManager rcm = new RemoteCommandManager((CommandProcessor)this.session);
                if (protocol.equalsIgnoreCase("jms") || protocol.equalsIgnoreCase("jms-publishing")) {
                    String reuse_publisher;
                    String factory;
                    String topic;
                    Object transport = null;
                    transport = protocol.equalsIgnoreCase("jms") ? new JMSTopicTransportManager(rcm) : new JMSPublishingTransportManager(rcm);
                    rcm.setTransportManager((TransportManager)transport);
                    String host = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.host", m, (AbstractSession)this.session);
                    if (host != null) {
                        transport.setTopicHostUrl(host);
                    }
                    if ((topic = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.topic", m, (AbstractSession)this.session)) != null) {
                        transport.setTopicName(topic);
                    }
                    if ((factory = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.factory", m, (AbstractSession)this.session)) != null) {
                        transport.setTopicConnectionFactoryName(factory);
                    }
                    if ((reuse_publisher = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.reuse-topic-publisher", m, (AbstractSession)this.session)) != null) {
                        transport.setShouldReuseJMSTopicPublisher(reuse_publisher.equalsIgnoreCase("true"));
                    }
                } else if (protocol.equalsIgnoreCase("rmi") || protocol.equalsIgnoreCase("rmi-iiop")) {
                    String url;
                    String multicast;
                    if (protocol.equalsIgnoreCase("rmi-iiop")) {
                        ((RMITransportManager)rcm.getTransportManager()).setIsRMIOverIIOP(true);
                    }
                    String delay = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.announcement-delay", m, (AbstractSession)this.session);
                    property = "eclipselink.cache.coordination.rmi.announcement-delay";
                    value = delay;
                    if (delay != null) {
                        rcm.getDiscoveryManager().setAnnouncementDelay(Integer.parseInt(delay));
                    }
                    if ((multicast = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group", m, (AbstractSession)this.session)) != null) {
                        rcm.getDiscoveryManager().setMulticastGroupAddress(multicast);
                    }
                    String port = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group.port", m, (AbstractSession)this.session);
                    property = "eclipselink.cache.coordination.rmi.multicast-group.port";
                    value = port;
                    if (port != null) {
                        rcm.getDiscoveryManager().setMulticastPort(Integer.parseInt(port));
                    }
                    String timeToLive = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.packet-time-to-live", m, (AbstractSession)this.session);
                    property = "eclipselink.cache.coordination.rmi.packet-time-to-live";
                    value = timeToLive;
                    if (timeToLive != null) {
                        rcm.getDiscoveryManager().setPacketTimeToLive(Integer.parseInt(timeToLive));
                    }
                    if ((url = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.url", m, (AbstractSession)this.session)) != null) {
                        rcm.setUrl(url);
                    }
                } else {
                    property = "eclipselink.cache.coordination.protocol";
                    value = protocol;
                    Class transportClass = EntityManagerSetupImpl.findClassForProperty(protocol, "eclipselink.cache.coordination.protocol", loader);
                    rcm.setTransportManager((TransportManager)transportClass.newInstance());
                }
                if ((naming = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.naming-service", m, (AbstractSession)this.session)) != null) {
                    if (naming.equalsIgnoreCase("jndi")) {
                        rcm.getTransportManager().setNamingServiceType(0);
                    } else if (naming.equalsIgnoreCase("rmi")) {
                        rcm.getTransportManager().setNamingServiceType(1);
                    }
                }
                if ((user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.user", m, (AbstractSession)this.session)) != null) {
                    rcm.getTransportManager().setUserName(user);
                }
                if ((password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.password", m, (AbstractSession)this.session)) != null) {
                    rcm.getTransportManager().setPassword(password);
                }
                if ((context = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.initial-context-factory", m, (AbstractSession)this.session)) != null) {
                    rcm.getTransportManager().setInitialContextFactoryName(context);
                }
                if ((removeOnError = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.remove-connection-on-error", m, (AbstractSession)this.session)) != null) {
                    rcm.getTransportManager().setShouldRemoveConnectionOnError(removeOnError.equalsIgnoreCase("true"));
                }
                if ((asynch = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.propagate-asynchronously", m, (AbstractSession)this.session)) != null) {
                    rcm.setShouldPropagateAsynchronously(asynch.equalsIgnoreCase("true"));
                }
                String threadPoolSize = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.thread.pool.size", m, (AbstractSession)this.session);
                property = "eclipselink.cache.coordination.thread.pool.size";
                value = threadPoolSize;
                if (threadPoolSize != null) {
                    this.session.getServerPlatform().setThreadPoolSize(Integer.parseInt(threadPoolSize));
                }
                if ((channel = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.channel", m, (AbstractSession)this.session)) != null) {
                    rcm.setChannel(channel);
                }
                this.session.setCommandManager((CommandManager)rcm);
                this.session.setShouldPropagateChanges(true);
            }
        }
        catch (Exception exception) {
            this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty((Object)value, (String)property, (Exception)exception));
        }
    }

    protected void updateLogins(Map m) {
        DatasourceLogin login = (DatasourceLogin)this.session.getDatasourceLogin();
        String eclipselinkPlatform = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.target-database", (Map)m, (AbstractSession)this.session);
        if (eclipselinkPlatform != null) {
            login.setPlatformClassName(eclipselinkPlatform, this.persistenceUnitInfo.getClassLoader());
        }
        boolean isEIS = false;
        if (login.getDatasourcePlatform() instanceof EISPlatform) {
            isEIS = true;
            EISLogin newLogin = new EISLogin();
            newLogin.setDatasourcePlatform(login.getDatasourcePlatform());
            this.session.setDatasourceLogin((Login)newLogin);
            if (this.session.isServerSession()) {
                for (ConnectionPool pool : ((ServerSession)this.session).getConnectionPools().values()) {
                    pool.setLogin((Login)newLogin);
                }
            }
            login = newLogin;
        }
        Object connectorValue = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.nosql.connection-spec", m, (AbstractSession)this.session);
        String connectorProperty = "eclipselink.nosql.connection-spec";
        if (connectorValue == null) {
            connectorValue = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.jdbc.connector", m, (AbstractSession)this.session);
            connectorProperty = "eclipselink.jdbc.connector";
        }
        if (connectorValue instanceof Connector) {
            login.setConnector((Connector)connectorValue);
        } else if (connectorValue instanceof String) {
            Class cls = null;
            try {
                cls = EntityManagerSetupImpl.findClassForProperty((String)connectorValue, connectorProperty, this.persistenceUnitInfo.getClassLoader());
            }
            catch (Throwable throwable) {
                cls = EntityManagerSetupImpl.findClassForProperty((String)connectorValue, connectorProperty, this.getClass().getClassLoader());
            }
            Connector connector = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                connector = (Connector)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateProperty((String)((String)connectorValue), (String)connectorProperty, (Exception)exception);
            }
            if (connector != null) {
                login.setConnector(connector);
            }
        } else if (connectorValue != null) {
            ((EISConnectionSpec)login.getConnector()).setConnectionSpecObject(connectorValue);
        }
        Object factoryValue = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.nosql.connection-factory", m, (AbstractSession)this.session);
        if (factoryValue instanceof String) {
            ((EISConnectionSpec)login.getConnector()).setName((String)factoryValue);
        } else if (factoryValue != null) {
            ((EISConnectionSpec)login.getConnector()).setConnectionFactoryObject(factoryValue);
        }
        Map propertiesMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.nosql.property.", (Map)m, (AbstractSession)this.session);
        if (propertiesMap.isEmpty()) {
            propertiesMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.jdbc.property.", (Map)m, (AbstractSession)this.session);
        }
        for (Map.Entry entry : propertiesMap.entrySet()) {
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            login.setProperty(property, value);
        }
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.user", m, (AbstractSession)this.session);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.password", m, (AbstractSession)this.session);
        if (user != null) {
            login.setUserName(user);
        }
        if (password != null) {
            login.setPassword(this.securableObjectHolder.getSecurableObject().decryptPassword(password));
        }
        PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, (AbstractSession)this.session);
        if (transTypeString != null && transTypeString.length() > 0) {
            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
        }
        DataSource jtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.jtaDataSource", this.persistenceUnitInfo.getJtaDataSource());
        DataSource nonjtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.nonJtaDataSource", this.persistenceUnitInfo.getNonJtaDataSource());
        if (this.isValidationOnly(m, false) && transactionType == PersistenceUnitTransactionType.JTA && jtaDatasource == null) {
            this.updateLoginDefaultConnector(login, m);
            return;
        }
        login.setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        if (isEIS) {
            return;
        }
        DataSource mainDatasource = null;
        DataSource readDatasource = null;
        if (login.shouldUseExternalTransactionController()) {
            mainDatasource = jtaDatasource;
            readDatasource = nonjtaDatasource;
        } else {
            if (jtaDatasource != null) {
                this.session.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", (Object)this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (nonjtaDatasource != null) {
                mainDatasource = nonjtaDatasource;
            } else {
                this.updateLoginDefaultConnector(login, m);
                return;
            }
        }
        if (!(login.getConnector() instanceof JNDIConnector)) {
            JNDIConnector jndiConnector = mainDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)mainDatasource).getName()) : new JNDIConnector(mainDatasource);
            login.setConnector((Connector)jndiConnector);
            login.setUsesExternalConnectionPooling(true);
        }
        if (this.session.isServerSession() && readDatasource != null) {
            DatasourceLogin readLogin = login.clone();
            readLogin.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = readDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)readDatasource).getName()) : new JNDIConnector(readDatasource);
            readLogin.setConnector((Connector)jndiConnector);
            ((ServerSession)this.session).setReadConnectionPool((Login)readLogin);
        }
    }

    protected DataSource getDatasourceFromProperties(Map m, String property, DataSource defaultDataSource) {
        Object datasource = EntityManagerFactoryProvider.getConfigPropertyLogDebug(property, m, (AbstractSession)this.session);
        if (datasource == null) {
            return defaultDataSource;
        }
        if (datasource instanceof String) {
            if (((String)datasource).length() > 0) {
                return new DataSourceImpl((String)datasource, null, null, null);
            }
            return null;
        }
        if (!(datasource instanceof DataSource)) {
            this.session.log(6, "properties", "invalid_datasource_property_value", (Object)property, datasource);
            return defaultDataSource;
        }
        return (DataSource)datasource;
    }

    protected void updateLoginDefaultConnector(DatasourceLogin login, Map m) {
        if (login.getConnector() instanceof DefaultConnector) {
            DatabaseLogin dbLogin = (DatabaseLogin)login;
            String jdbcDriver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.driver", m, (AbstractSession)this.session);
            String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.url", m, (AbstractSession)this.session);
            if (connectionString != null) {
                dbLogin.setConnectionString(connectionString);
            }
            if (jdbcDriver != null) {
                dbLogin.setDriverClassName(jdbcDriver);
            }
        }
    }

    protected void updatePools(ServerSession serverSession, Map m) {
        String value = null;
        String property = null;
        try {
            String sequenceDataSource;
            String sequence;
            if (!serverSession.getDefaultConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                property = "eclipselink.jdbc.connections.min";
                value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property, m, (AbstractSession)serverSession);
                if (value != null) {
                    serverSession.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.connections.max", m, (AbstractSession)serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.connections.initial", m, (AbstractSession)serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.min", m, (AbstractSession)serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.max", m, (AbstractSession)serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.initial", m, (AbstractSession)serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(value));
                }
            }
            if (!serverSession.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                String wait;
                String initial;
                String max;
                String shared = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.shared", m, (AbstractSession)serverSession);
                boolean isShared = false;
                if (shared != null) {
                    isShared = Boolean.parseBoolean(shared);
                }
                Object pool = null;
                pool = isShared ? new ReadConnectionPool("read", serverSession.getReadConnectionPool().getLogin(), serverSession) : new ConnectionPool("read", serverSession.getReadConnectionPool().getLogin(), serverSession);
                String min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.min", m, (AbstractSession)serverSession);
                if (min != null) {
                    value = min;
                    property = "eclipselink.jdbc.read-connections.min";
                    pool.setMinNumberOfConnections(Integer.parseInt(min));
                }
                if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.max", m, (AbstractSession)serverSession)) != null) {
                    value = max;
                    property = "eclipselink.jdbc.read-connections.max";
                    pool.setMaxNumberOfConnections(Integer.parseInt(max));
                }
                if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.initial", m, (AbstractSession)serverSession)) != null) {
                    value = initial;
                    property = "eclipselink.jdbc.read-connections.initial";
                    pool.setInitialNumberOfConnections(Integer.parseInt(initial));
                }
                if (isShared || min != null || max != null || initial != null) {
                    serverSession.setReadConnectionPool((ConnectionPool)pool);
                }
                if ((wait = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.wait-timeout", m, (AbstractSession)serverSession)) != null) {
                    value = wait;
                    property = "eclipselink.jdbc.connections.wait-timeout";
                    serverSession.getDefaultConnectionPool().setWaitTimeout(Integer.parseInt(wait));
                    pool.setWaitTimeout(Integer.parseInt(wait));
                }
            }
            if ((sequence = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool", m, (AbstractSession)serverSession)) != null) {
                serverSession.getSequencingControl().setShouldUseSeparateConnection(Boolean.parseBoolean(sequence));
            }
            if ((sequenceDataSource = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.non-jta-data-source", m, (AbstractSession)serverSession)) != null) {
                DatasourceLogin login = this.session.getLogin().clone();
                login.dontUseExternalTransactionController();
                JNDIConnector jndiConnector = new JNDIConnector(sequenceDataSource);
                login.setConnector((Connector)jndiConnector);
                serverSession.getSequencingControl().setLogin((Login)login);
            }
            if (!serverSession.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.min", m, (AbstractSession)serverSession);
                if (value != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.min";
                    serverSession.getSequencingControl().setMinPoolSize(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.max", m, (AbstractSession)serverSession)) != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.max";
                    serverSession.getSequencingControl().setMaxPoolSize(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.initial", m, (AbstractSession)serverSession)) != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.initial";
                    serverSession.getSequencingControl().setInitialPoolSize(Integer.parseInt(value));
                }
            }
        }
        catch (NumberFormatException exception) {
            serverSession.handleException((RuntimeException)ValidationException.invalidValueForProperty(value, (String)property, (Exception)exception));
        }
    }

    protected void initSession() {
        this.assignCMP3Policy();
        if (!this.isCompositeMember()) {
            this.addSessionToGlobalSessionManager();
        }
    }

    protected void updateSession(Map m, ClassLoader loader) {
        if (this.session == null || this.session.isConnected()) {
            return;
        }
        boolean serverPlatformChanged = this.updateServerPlatform(m, loader);
        this.updateJPQLParser(m);
        if (!this.session.hasBroker()) {
            this.updateLoggers(m, serverPlatformChanged, loader);
            this.updateProfiler(m, loader);
        }
        if (this.session.isBroker()) {
            PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
            String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, (AbstractSession)this.session);
            if (transTypeString != null) {
                transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
            }
            ((DatasourceLogin)this.session.getDatasourceLogin()).setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        } else {
            String shouldBindString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.bind-parameters", m, (AbstractSession)this.session);
            if (shouldBindString != null) {
                this.session.getPlatform().setShouldBindAllParameters(Boolean.parseBoolean(shouldBindString));
            }
            this.updateLogins(m);
        }
        if (!this.session.getDatasourceLogin().shouldUseExternalTransactionController()) {
            this.session.getServerPlatform().disableJTA();
        }
        if (this.session.isServerSession()) {
            this.updatePools((ServerSession)this.session, m);
            this.updateConnectionSettings((ServerSession)this.session, m);
            if (!this.isSessionLoadedFromSessionsXML) {
                this.updateDescriptorCacheSettings(m, loader);
            }
            this.updateConnectionPolicy((ServerSession)this.session, m);
        }
        if (this.session.isBroker()) {
            if (this.compositeMemberEmSetupImpls != null) {
                Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", m);
                for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                    String compositeMemberPuName = compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName();
                    Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberPuName);
                    compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_begin_call", new Object[]{"updateSession", compositeMemberPuName, this.state});
                    compositeMemberEmSetupImpl.updateSession(compositeMemberProperties, loader);
                    compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_end_call", new Object[]{"updateSession", compositeMemberPuName, this.state});
                }
            }
            this.setSessionEventListener(m, loader);
            this.setExceptionHandler(m, loader);
            this.updateAllowZeroIdSetting(m);
            this.updateCacheCoordination(m, loader);
            this.processSessionCustomizer(m, loader);
        } else {
            this.setSessionEventListener(m, loader);
            this.setExceptionHandler(m, loader);
            this.updateBatchWritingSetting(m);
            this.updateNativeSQLSetting(m);
            this.updateAllowNativeSQLQueriesSetting(m);
            this.updateSQLCastSetting(m);
            this.updateUppercaseSetting(m);
            this.updateCacheStatementSettings(m);
            this.updateTemporalMutableSetting(m);
            this.updateTableCreationSettings(m);
            if (!this.session.hasBroker()) {
                this.updateAllowZeroIdSetting(m);
            }
            this.updateIdValidation(m);
            this.updatePessimisticLockTimeout(m);
            this.updateQueryTimeout(m);
            if (!this.session.hasBroker()) {
                this.updateCacheCoordination(m, loader);
            }
            this.updatePartitioning(m, loader);
            this.updateDatabaseEventListener(m, loader);
            this.processDescriptorCustomizers(m, loader);
            this.processSessionCustomizer(m, loader);
            this.setDescriptorNamedQueries(m);
        }
    }

    public void setIsInContainerMode(boolean isInContainerMode) {
        this.isInContainerMode = isInContainerMode;
    }

    public void setIsMetadataExpired(boolean hasExpiredMetadata) {
        this.isMetadataExpired = hasExpiredMetadata;
    }

    protected void processSessionCustomizer(Map m, ClassLoader loader) {
        String sessionCustomizerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.customizer", m, (AbstractSession)this.session);
        if (sessionCustomizerClassName == null) {
            return;
        }
        Class sessionCustomizerClass = EntityManagerSetupImpl.findClassForProperty(sessionCustomizerClassName, "eclipselink.session.customizer", loader);
        try {
            SessionCustomizer sessionCustomizer = (SessionCustomizer)sessionCustomizerClass.newInstance();
            sessionCustomizer.customize((Session)this.session);
        }
        catch (Exception ex) {
            throw EntityManagerSetupException.failedWhileProcessingProperty((String)"eclipselink.session.customizer", (String)sessionCustomizerClassName, (Exception)ex);
        }
    }

    protected void initOrUpdateLogging(Map m, SessionLog log) {
        String shouldDisplayData;
        String exString;
        String connectionString;
        String sessionString;
        String threadString;
        String tsString;
        Map categoryLogLevelMap;
        String logLevelString = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.logging.level", (Map)m, (AbstractSession)this.session);
        if (logLevelString != null) {
            log.setLevel(AbstractSessionLog.translateStringToLoggingLevel((String)logLevelString));
        }
        if (!(categoryLogLevelMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.logging.level.", (Map)m, (AbstractSession)this.session)).isEmpty()) {
            for (Map.Entry entry : categoryLogLevelMap.entrySet()) {
                String category = (String)entry.getKey();
                String value = (String)entry.getValue();
                log.setLevel(AbstractSessionLog.translateStringToLoggingLevel((String)value), category);
            }
        }
        if ((tsString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.timestamp", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintDate(Boolean.parseBoolean(tsString));
        }
        if ((threadString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.thread", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintThread(Boolean.parseBoolean(threadString));
        }
        if ((sessionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.session", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintSession(Boolean.parseBoolean(sessionString));
        }
        if ((connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.connection", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintConnection(Boolean.parseBoolean(connectionString));
        }
        if ((exString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.exceptions", m, (AbstractSession)this.session)) != null) {
            log.setShouldLogExceptionStackTrace(Boolean.parseBoolean(exString));
        }
        if ((shouldDisplayData = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.parameters", m, (AbstractSession)this.session)) != null) {
            log.setShouldDisplayData(Boolean.valueOf(Boolean.parseBoolean(shouldDisplayData)));
        }
    }

    protected void processDescriptorCustomizers(Map m, ClassLoader loader) {
        Map customizerMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.descriptor.customizer.", (Map)m, (AbstractSession)this.session);
        if (customizerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : customizerMap.entrySet()) {
            String name = (String)entry.getKey();
            String customizerClassName = (String)entry.getValue();
            ClassDescriptor descriptor = this.session.getDescriptorForAlias(name);
            if (descriptor == null) {
                try {
                    Class javaClass = EntityManagerSetupImpl.findClass(name, loader);
                    descriptor = this.session.getDescriptor(javaClass);
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedWhileProcessingProperty((String)("eclipselink.descriptor.customizer." + name), (String)customizerClassName, (Exception)ex);
                }
            }
            if (descriptor != null) {
                Class customizerClass = EntityManagerSetupImpl.findClassForProperty(customizerClassName, "eclipselink.descriptor.customizer." + name, loader);
                try {
                    DescriptorCustomizer customizer = (DescriptorCustomizer)customizerClass.newInstance();
                    customizer.customize(descriptor);
                    continue;
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedWhileProcessingProperty((String)("eclipselink.descriptor.customizer." + name), (String)customizerClassName, (Exception)ex);
                }
            }
            throw EntityManagerSetupException.failedWhileProcessingProperty((String)("eclipselink.descriptor.customizer." + name), (String)customizerClassName, null);
        }
    }

    public boolean isInitial() {
        return this.state == STATE_INITIAL;
    }

    public boolean isMetadataExpired() {
        return this.isMetadataExpired;
    }

    public boolean isPredeployed() {
        return this.state == STATE_PREDEPLOYED;
    }

    public boolean isDeployed() {
        return this.state == STATE_DEPLOYED;
    }

    public boolean isHalfDeployed() {
        return this.state == STATE_HALF_DEPLOYED;
    }

    public boolean isUndeployed() {
        return this.state == STATE_UNDEPLOYED;
    }

    public boolean isPredeployFailed() {
        return this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean isDeployFailed() {
        return this.state == STATE_DEPLOY_FAILED;
    }

    public boolean isHalfPredeployedCompositeMember() {
        return this.state == STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER;
    }

    public String getPersistenceUnitUniqueName() {
        return this.persistenceUnitUniqueName;
    }

    public int getFactoryCount() {
        return this.factoryCount;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public boolean shouldRedeploy() {
        return this.state == STATE_UNDEPLOYED || this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean shouldSendMetadataRefreshCommand(Map m) {
        String sendCommand = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.metadata-source.send-refresh-command", m, (AbstractSession)this.session);
        if (sendCommand != null) {
            return Boolean.parseBoolean(sendCommand);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeploy() {
        block11: {
            if (this.state == STATE_INITIAL || this.state == STATE_PREDEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
                return;
            }
            this.session.log(1, "jpa", "undeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            try {
                --this.factoryCount;
                if (this.factoryCount <= 0) break block11;
            }
            catch (Throwable throwable) {
                this.session.log(1, "jpa", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                if (this.state == STATE_UNDEPLOYED) {
                    this.session = null;
                }
                throw throwable;
            }
            this.session.log(1, "jpa", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            if (this.state == STATE_UNDEPLOYED) {
                this.session = null;
            }
            return;
        }
        HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (hashMap) {
            this.state = STATE_UNDEPLOYED;
            this.removeSessionFromGlobalSessionManager();
            if (EntityManagerFactoryProvider.emSetupImpls.get(this.sessionName).equals(this)) {
                EntityManagerFactoryProvider.emSetupImpls.remove(this.sessionName);
            }
        }
        this.session.log(1, "jpa", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        if (this.state == STATE_UNDEPLOYED) {
            this.session = null;
        }
    }

    protected void setSessionEventListener(Map m, ClassLoader loader) {
        String sessionEventListenerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-event-listener", m, (AbstractSession)this.session);
        if (sessionEventListenerClassName != null) {
            Class sessionEventListenerClass = EntityManagerSetupImpl.findClassForProperty(sessionEventListenerClassName, "eclipselink.session-event-listener", loader);
            try {
                SessionEventListener sessionEventListener = (SessionEventListener)EntityManagerSetupImpl.buildObjectForClass(sessionEventListenerClass, SessionEventListener.class);
                if (sessionEventListener != null) {
                    this.session.getEventManager().addListener(sessionEventListener);
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidSessionEventListenerClass((String)sessionEventListenerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateSessionEventListenerClass((String)sessionEventListenerClassName, (Exception)e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateSessionEventListenerClass((String)sessionEventListenerClassName, (Exception)e));
            }
            catch (InstantiationException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateSessionEventListenerClass((String)sessionEventListenerClassName, (Exception)e));
            }
        }
    }

    protected void setExceptionHandler(Map m, ClassLoader loader) {
        String exceptionHandlerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.exception-handler", m, (AbstractSession)this.session);
        if (exceptionHandlerClassName != null) {
            Class exceptionHandlerClass = EntityManagerSetupImpl.findClassForProperty(exceptionHandlerClassName, "eclipselink.exception-handler", loader);
            try {
                ExceptionHandler exceptionHandler = (ExceptionHandler)EntityManagerSetupImpl.buildObjectForClass(exceptionHandlerClass, ExceptionHandler.class);
                if (exceptionHandler != null) {
                    this.session.setExceptionHandler(exceptionHandler);
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidExceptionHandlerClass((String)exceptionHandlerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateExceptionHandlerClass((String)exceptionHandlerClassName, (Exception)e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateExceptionHandlerClass((String)exceptionHandlerClassName, (Exception)e));
            }
            catch (InstantiationException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateExceptionHandlerClass((String)exceptionHandlerClassName, (Exception)e));
            }
        }
    }

    protected void updateBatchWritingSetting(Map persistenceProperties) {
        String sizeString;
        String batchWritingSettingString = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.jdbc.batch-writing", (Map)persistenceProperties, (AbstractSession)this.session);
        if (batchWritingSettingString != null) {
            this.session.getPlatform().setUsesBatchWriting(batchWritingSettingString != "None");
            if (batchWritingSettingString == "JDBC") {
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Buffered") {
                this.session.getPlatform().setUsesJDBCBatchWriting(false);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Oracle-JDBC") {
                this.session.getPlatform().setUsesNativeBatchWriting(true);
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
            }
        }
        if ((sizeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.batch-writing.size", persistenceProperties, (AbstractSession)this.session)) != null) {
            try {
                this.session.getPlatform().setMaxBatchWritingSize(Integer.parseInt(sizeString));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty((Object)sizeString, (String)"eclipselink.jdbc.batch-writing.size", (Exception)invalid));
            }
        }
    }

    protected void updateMetadataRepository(Map m, ClassLoader loader) {
        Object metadataSource = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.metadata-source", m, (AbstractSession)this.session);
        if (metadataSource != null && metadataSource instanceof MetadataSource) {
            this.processor.setMetadataSource((MetadataSource)metadataSource);
        } else if (metadataSource != null) {
            String repository = (String)metadataSource;
            if (repository.equalsIgnoreCase("XML")) {
                this.processor.setMetadataSource(new XMLMetadataSource());
            } else {
                Class transportClass = EntityManagerSetupImpl.findClassForProperty(repository, "eclipselink.metadata-source", loader);
                try {
                    this.processor.setMetadataSource((MetadataSource)transportClass.newInstance());
                }
                catch (Exception invalid) {
                    this.session.handleException((RuntimeException)EntityManagerSetupException.failedToInstantiateProperty((String)repository, (String)"eclipselink.metadata-source", (Exception)invalid));
                }
            }
        }
    }

    protected void updateNativeSQLSetting(Map m) {
        String nativeSQLString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.native-sql", m, (AbstractSession)this.session);
        if (nativeSQLString != null) {
            if (nativeSQLString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().useNativeSQL();
            } else if (nativeSQLString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().dontUseNativeSQL();
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForSettingNativeSQL((String)nativeSQLString));
            }
        }
    }

    protected void updateProjectCache(Map m, ClassLoader loader) {
        Object accessor = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.project-cache", m, (AbstractSession)this.session);
        if (accessor != null) {
            if (accessor instanceof ProjectCache) {
                this.projectCacheAccessor = (ProjectCache)accessor;
            } else {
                String accessorType = (String)accessor;
                if (accessorType.equalsIgnoreCase("java-serialization")) {
                    this.projectCacheAccessor = new FileBasedProjectCache();
                } else {
                    Class transportClass = EntityManagerSetupImpl.findClassForProperty(accessorType, "eclipselink.project-cache", loader);
                    try {
                        this.projectCacheAccessor = (ProjectCache)transportClass.newInstance();
                    }
                    catch (Exception invalid) {
                        this.session.handleException((RuntimeException)EntityManagerSetupException.failedToInstantiateProperty((String)accessorType, (String)"eclipselink.metadata-source", (Exception)invalid));
                    }
                }
            }
        }
    }

    protected void updateJPQLParser(Map m) {
        String validation;
        String parser = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpql.parser", m, (AbstractSession)this.session);
        if (parser != null) {
            if (parser.equalsIgnoreCase("Hermes")) {
                parser = "org.eclipse.persistence.internal.jpa.jpql.HermesParser";
            } else if (parser.equalsIgnoreCase("ANTLR")) {
                parser = "org.eclipse.persistence.queries.ANTLRQueryBuilder";
            }
            this.session.setProperty("eclipselink.jpql.parser", (Object)parser);
        }
        if ((validation = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpql.validation", m, (AbstractSession)this.session)) != null) {
            this.session.setProperty("eclipselink.jpql.validation", (Object)validation);
        }
    }

    protected void updateAllowNativeSQLQueriesSetting(Map m) {
        String allowNativeSQLQueriesString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.allow-native-sql-queries", m, (AbstractSession)this.session);
        if (allowNativeSQLQueriesString != null) {
            if (allowNativeSQLQueriesString.equalsIgnoreCase("true")) {
                this.session.getProject().setAllowNativeSQLQueries(true);
            } else if (allowNativeSQLQueriesString.equalsIgnoreCase("false")) {
                this.session.getProject().setAllowNativeSQLQueries(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForSettingAllowNativeSQLQueries((String)allowNativeSQLQueriesString));
            }
        }
    }

    protected void updateSQLCastSetting(Map m) {
        String sqlCastString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sql-cast", m, (AbstractSession)this.session);
        if (sqlCastString != null) {
            if (sqlCastString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().getPlatform().setIsCastRequired(true);
            } else if (sqlCastString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().getPlatform().setIsCastRequired(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)sqlCastString, (String)"eclipselink.jdbc.sql-cast"));
            }
        }
    }

    protected void updateUppercaseSetting(Map m) {
        String uppercaseString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.uppercase-columns", m, (AbstractSession)this.session);
        if (uppercaseString != null) {
            if (uppercaseString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
            } else if (uppercaseString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)uppercaseString, (String)"eclipselink.jdbc.uppercase-columns"));
            }
        }
    }

    public static void updateCaseSensitivitySettings(Map m, MetadataProject project, AbstractSession session) {
        String insensitiveString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpa.uppercase-column-names", m, session);
        if (insensitiveString == null || insensitiveString.equalsIgnoreCase("true")) {
            project.setShouldForceFieldNamesToUpperCase(true);
            session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
        } else if (insensitiveString.equalsIgnoreCase("false")) {
            project.setShouldForceFieldNamesToUpperCase(false);
            session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
        } else {
            session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)insensitiveString, (String)"eclipselink.jpa.uppercase-column-names"));
        }
    }

    protected void updatePessimisticLockTimeout(Map persistenceProperties) {
        String pessimisticLockTimeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.lock.timeout", persistenceProperties, (AbstractSession)this.session);
        if (pessimisticLockTimeout != null) {
            try {
                this.session.setPessimisticLockTimeoutDefault(Integer.valueOf(Integer.parseInt(pessimisticLockTimeout)));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty((Object)pessimisticLockTimeout, (String)"javax.persistence.lock.timeout", (Exception)invalid));
            }
        }
    }

    protected void updateCacheStatementSettings(Map m) {
        String cacheStatementsSize;
        String statmentsNeedBeCached = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements", m, (AbstractSession)this.session);
        if (statmentsNeedBeCached != null) {
            if (statmentsNeedBeCached.equalsIgnoreCase("true")) {
                if (this.session.isServerSession() && ((ServerSession)this.session).getConnectionPools().isEmpty()) {
                    this.session.log(6, "properties", "persistence_unit_ignores_statments_cache_setting", new Object[1]);
                } else {
                    this.session.getProject().getLogin().setShouldCacheAllStatements(true);
                }
            } else if (statmentsNeedBeCached.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldCacheAllStatements(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForEnableStatmentsCached((String)statmentsNeedBeCached));
            }
        }
        if ((cacheStatementsSize = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements.size", m, (AbstractSession)this.session)) != null) {
            try {
                this.session.getProject().getLogin().setStatementCacheSize(Integer.parseInt(cacheStatementsSize));
            }
            catch (NumberFormatException e) {
                this.session.handleException((RuntimeException)ValidationException.invalidCacheStatementsSize((String)cacheStatementsSize, (String)e.getMessage()));
            }
        }
    }

    protected void updateAllowZeroIdSetting(Map m) {
        String allowZero = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.allow-zero-id", m, (AbstractSession)this.session);
        if (allowZero != null) {
            if (allowZero.equalsIgnoreCase("true")) {
                Helper.isZeroValidPrimaryKey = true;
            } else if (allowZero.equalsIgnoreCase("false")) {
                Helper.isZeroValidPrimaryKey = false;
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)allowZero, (String)"eclipselink.allow-zero-id"));
            }
        }
    }

    protected void updateIdValidation(Map m) {
        String idValidationString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.id-validation", m, (AbstractSession)this.session);
        if (idValidationString != null) {
            this.session.getProject().setDefaultIdValidation(IdValidation.valueOf((String)idValidationString));
        }
    }

    protected void updateTableCreationSettings(Map m) {
        String tableCreationSuffix = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.ddl-generation.table-creation-suffix", m, (AbstractSession)this.session);
        if (tableCreationSuffix != null && tableCreationSuffix.length() > 0) {
            this.session.getPlatform().setTableCreationSuffix(tableCreationSuffix);
        }
    }

    protected void updateTemporalMutableSetting(Map m) {
        String temporalMutable = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.temporal.mutable", m, (AbstractSession)this.session);
        if (temporalMutable != null) {
            if (temporalMutable.equalsIgnoreCase("true")) {
                this.session.getProject().setDefaultTemporalMutable(true);
            } else if (temporalMutable.equalsIgnoreCase("false")) {
                this.session.getProject().setDefaultTemporalMutable(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)temporalMutable, (String)"eclipselink.temporal.mutable"));
            }
        }
    }

    protected void setDescriptorNamedQueries(Map m) {
        String addNamedQueriesString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.include.descriptor.queries", m, (AbstractSession)this.session);
        if (addNamedQueriesString != null) {
            if (addNamedQueriesString.equalsIgnoreCase("true")) {
                this.session.copyDescriptorNamedQueries(false);
            } else if (!addNamedQueriesString.equalsIgnoreCase("false")) {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForAddingNamedQueries((String)addNamedQueriesString));
            }
        }
    }

    private void updateQueryTimeout(Map persistenceProperties) {
        String timeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.query.timeout", persistenceProperties, (AbstractSession)this.session);
        try {
            if (timeout != null) {
                this.session.setQueryTimeoutDefault(Integer.parseInt(timeout));
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty((Object)timeout, (String)"javax.persistence.query.timeout", (Exception)exception));
        }
    }

    private void addBeanValidationListeners(Map puProperties, ClassLoader appClassLoader) {
        ValidationMode validationMode = EntityManagerSetupImpl.getValidationMode(this.persistenceUnitInfo, puProperties);
        if (validationMode == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            String helperClassName = "org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper$BeanValidationInitializationHelperImpl";
            ClassLoader eclipseLinkClassLoader = EntityManagerSetupImpl.class.getClassLoader();
            try {
                Class helperClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(helperClassName, true, eclipseLinkClassLoader)) : PrivilegedAccessHelper.getClassForName((String)helperClassName, (boolean)true, (ClassLoader)eclipseLinkClassLoader);
                BeanValidationInitializationHelper beanValidationInitializationHelper = (BeanValidationInitializationHelper)helperClass.newInstance();
                beanValidationInitializationHelper.bootstrapBeanValidation(puProperties, (AbstractSession)this.session, appClassLoader);
            }
            catch (Throwable e) {
                if (validationMode == ValidationMode.CALLBACK) {
                    throw PersistenceUnitLoadingException.exceptionObtainingRequiredBeanValidatorFactory((Throwable)e);
                }
                this.session.logMessage("Could not initialize Validation Factory. Encountered following exception: " + e);
            }
        }
    }

    private static ValidationMode getValidationMode(PersistenceUnitInfo persitenceUnitInfo, Map puProperties) {
        String validationModeAtEMFCreation = (String)puProperties.get("javax.persistence.validation.mode");
        if (validationModeAtEMFCreation != null) {
            return ValidationMode.valueOf((String)validationModeAtEMFCreation.toUpperCase());
        }
        ValidationMode validationMode = null;
        try {
            Method method = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(PersistenceUnitInfo.class, "getValidationMode", null));
                validationMode = (ValidationMode)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, (Object)persitenceUnitInfo));
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(PersistenceUnitInfo.class, (String)"getValidationMode", null);
                validationMode = (ValidationMode)PrivilegedAccessHelper.invokeMethod((Method)method, (Object)persitenceUnitInfo, null);
            }
        }
        catch (Throwable throwable) {}
        if (validationMode == null) {
            validationMode = ValidationMode.AUTO;
        }
        return validationMode;
    }

    public Metamodel getMetamodel() {
        MetamodelImpl tempMetaModel = null;
        if (this.metaModel == null) {
            tempMetaModel = new MetamodelImpl(this);
            this.initializeCanonicalMetamodel(tempMetaModel);
            this.metaModel = tempMetaModel;
        }
        return this.metaModel;
    }

    protected void initializeCanonicalMetamodel(Metamodel model) {
        if (model.getManagedTypes() == null || model.getManagedTypes().isEmpty()) {
            this.getSession().log(2, "metamodel", "metamodel_type_collection_empty");
        }
        for (ManagedType manType : model.getManagedTypes()) {
            boolean classInitialized = false;
            String className = MetadataHelper.getQualifiedCanonicalName(manType.getJavaType().getName(), (AbstractSession)this.getSession());
            try {
                Class clazz = (Class)this.getSession().getDatasourcePlatform().convertObject((Object)className, ClassConstants.CLASS);
                classInitialized = true;
                this.getSession().log(2, "metamodel", "metamodel_canonical_model_class_found", (Object)className);
                String fieldName = "";
                for (Object attribute : manType.getDeclaredAttributes()) {
                    try {
                        fieldName = ((Attribute)attribute).getName();
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            ((Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clazz, fieldName, false))).set(clazz, attribute);
                            continue;
                        }
                        PrivilegedAccessHelper.getDeclaredField((Class)clazz, (String)fieldName, (boolean)false).set(clazz, attribute);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (Exception e) {
                        ValidationException v = ValidationException.invalidFieldForClass((String)fieldName, (Object)clazz);
                        v.setInternalException((Throwable)e);
                        throw v;
                    }
                }
            }
            catch (ConversionException conversionException) {}
            if (classInitialized) continue;
            this.getSession().log(2, "metamodel", "metamodel_canonical_model_class_not_found", (Object)className);
        }
    }

    public void setMetamodel(Metamodel aMetamodel) {
        this.metaModel = aMetamodel;
    }

    public boolean mustBeCompositeMember() {
        return EntityManagerSetupImpl.mustBeCompositeMember(this.persistenceUnitInfo);
    }

    public boolean isCompositeMember() {
        return this.compositeEmSetupImpl != null;
    }

    public boolean isComposite() {
        return this.compositeMemberEmSetupImpls != null;
    }

    public static boolean mustBeCompositeMember(PersistenceUnitInfo puInfo) {
        String mustBeCompositeMemberStr = PropertiesHandler.getPropertyValue((String)"eclipselink.composite-unit.member", (Map)puInfo.getProperties(), (boolean)false);
        if (mustBeCompositeMemberStr != null) {
            return mustBeCompositeMemberStr.equals("true");
        }
        return false;
    }

    public static boolean isComposite(PersistenceUnitInfo puInfo) {
        String isCompositeString = PropertiesHandler.getPropertyValue((String)"eclipselink.composite-unit", (Map)puInfo.getProperties(), (boolean)false);
        if (isCompositeString != null) {
            return isCompositeString.equals("true");
        }
        return false;
    }

    public void setCompositeEmSetupImpl(EntityManagerSetupImpl compositeEmSetupImpl) {
        this.compositeEmSetupImpl = compositeEmSetupImpl;
    }

    public EntityManagerSetupImpl getCompositeEmSetupImpl() {
        return this.compositeEmSetupImpl;
    }

    public void setStaticWeaveInfo(StaticWeaveInfo staticWeaveInfo) {
        this.staticWeaveInfo = staticWeaveInfo;
    }

    protected void predeployCompositeMembers(Map predeployProperties, ClassLoader tempClassLoader) {
        Set<SEPersistenceUnitInfo> compositeMemberPuInfos = EntityManagerSetupImpl.getCompositeMemberPuInfoSet(this.persistenceUnitInfo, predeployProperties);
        this.updateCompositeMembersProperties(compositeMemberPuInfos, predeployProperties);
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", predeployProperties);
        this.compositeMemberEmSetupImpls = new HashSet<EntityManagerSetupImpl>(compositeMemberPuInfos.size());
        this.processor = new MetadataProcessor();
        if (this.enableWeaving.booleanValue()) {
            this.weaver = new PersistenceWeaver((Session)this.session, new HashMap());
        }
        for (SEPersistenceUnitInfo compositeMemberPuInfo : compositeMemberPuInfos) {
            compositeMemberPuInfo.setNewTempClassLoader(tempClassLoader);
            String containedPuName = compositeMemberPuInfo.getPersistenceUnitName();
            EntityManagerSetupImpl containedEmSetupImpl = new EntityManagerSetupImpl(containedPuName, containedPuName);
            containedEmSetupImpl.setCompositeEmSetupImpl(this);
            containedEmSetupImpl.setStaticWeaveInfo(this.staticWeaveInfo);
            Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(containedPuName);
            containedEmSetupImpl.predeploy(compositeMemberPuInfo, compositeMemberProperties);
            compositeMemberPuInfo.setNewTempClassLoader(compositeMemberPuInfo.getClassLoader());
            this.compositeMemberEmSetupImpls.add(containedEmSetupImpl);
        }
        for (EntityManagerSetupImpl containedEmSetupImpl : this.compositeMemberEmSetupImpls) {
            containedEmSetupImpl.predeploy(null, null);
        }
        for (EntityManagerSetupImpl containedEmSetupImpl : this.compositeMemberEmSetupImpls) {
            PersistenceWeaver containedWeaver = (PersistenceWeaver)containedEmSetupImpl.predeploy(null, null);
            if (!this.enableWeaving.booleanValue() || containedWeaver == null) continue;
            this.weaver.getClassDetailsMap().putAll(containedWeaver.getClassDetailsMap());
        }
        if (this.enableWeaving.booleanValue() && this.weaver.getClassDetailsMap().isEmpty()) {
            this.weaver = null;
        }
    }

    protected void deployCompositeMembers(Map deployProperties, ClassLoader realClassLoader) {
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", deployProperties);
        for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
            Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName());
            compositeMemberEmSetupImpl.deploy(realClassLoader, compositeMemberProperties);
            DatabaseSessionImpl containedSession = compositeMemberEmSetupImpl.getSession();
            ((SessionBroker)this.session).registerSession(containedSession.getName(), (AbstractSession)containedSession);
        }
    }

    protected void updateCompositeMembersProperties(Map compositeProperties) {
        HashSet<SEPersistenceUnitInfo> compositePuInfos = new HashSet<SEPersistenceUnitInfo>(this.compositeMemberEmSetupImpls.size());
        for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
            compositePuInfos.add((SEPersistenceUnitInfo)compositeMemberEmSetupImpl.persistenceUnitInfo);
        }
        this.updateCompositeMembersProperties(compositePuInfos, compositeProperties);
    }

    protected void updateCompositeMembersProperties(Set<SEPersistenceUnitInfo> compositePuInfos, Map compositeProperties) {
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", compositeProperties);
        HashMap newCompositeMemberMapOfProperties = compositeMemberMapOfProperties == null ? new HashMap(compositePuInfos.size()) : new HashMap(compositeMemberMapOfProperties);
        for (SEPersistenceUnitInfo compositePuInfo : compositePuInfos) {
            String compositeMemberPuName = compositePuInfo.getPersistenceUnitName();
            Map compositeMemberProperties = (Map)newCompositeMemberMapOfProperties.get(compositeMemberPuName);
            Map newCompositeMemberProperties = compositeMemberProperties == null ? new HashMap() : new HashMap(compositeMemberProperties);
            EntityManagerSetupImpl.overrideMemberProperties(newCompositeMemberProperties, compositeProperties);
            newCompositeMemberProperties = EntityManagerFactoryProvider.mergeMaps(newCompositeMemberProperties, compositePuInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(newCompositeMemberProperties, (AbstractSession)this.session);
            newCompositeMemberMapOfProperties.put(compositeMemberPuName, newCompositeMemberProperties);
        }
        compositeProperties.put("eclipselink.composite-unit.properties", newCompositeMemberMapOfProperties);
    }

    protected void generateDDL(Map props) {
        block12: {
            block11: {
                if (this.compositeMemberEmSetupImpls != null) break block11;
                TableCreationType ddlType = TableCreationType.NONE;
                String ddlGeneration = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation", props, "none");
                if ((ddlGeneration = ddlGeneration.toLowerCase()).equals("none")) {
                    return;
                }
                if (ddlGeneration.equals("create-tables")) {
                    ddlType = TableCreationType.CREATE;
                } else if (ddlGeneration.equals("drop-and-create-tables")) {
                    ddlType = TableCreationType.DROP;
                } else if (ddlGeneration.equals("create-or-extend-tables")) {
                    ddlType = TableCreationType.EXTEND;
                }
                if (ddlType == TableCreationType.NONE) break block12;
                String ddlGenerationMode = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation.output-mode", props, "database");
                if (ddlGenerationMode.equals("none")) {
                    return;
                }
                if (this.isCompositeMember()) {
                    this.session.log(1, "properties", "composite_member_begin_call", new Object[]{"generateDDL", this.persistenceUnitInfo.getPersistenceUnitName(), this.state});
                }
                SchemaManager mgr = new SchemaManager(this.session);
                if (ddlGenerationMode.equals("database") || ddlGenerationMode.equals("both")) {
                    EntityManagerFactoryProvider.writeDDLToDatabase(mgr, ddlType);
                }
                if (ddlGenerationMode.equals("sql-script") || ddlGenerationMode.equals("both")) {
                    String appLocation = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.application-location", props, PersistenceUnitProperties.DEFAULT_APP_LOCATION);
                    String createDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.create-ddl-jdbc-file-name", props, "createDDL.jdbc");
                    String dropDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.drop-ddl-jdbc-file-name", props, "dropDDL.jdbc");
                    EntityManagerFactoryProvider.writeDDLsToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc);
                }
                if (!this.isCompositeMember()) break block12;
                this.session.log(1, "properties", "composite_member_end_call", new Object[]{"generateDDL", this.persistenceUnitInfo.getPersistenceUnitName(), this.state});
                break block12;
            }
            Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", props);
            for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName());
                compositeMemberEmSetupImpl.generateDDL(compositeMemberProperties);
            }
        }
    }

    protected static void overrideMemberProperties(Map memberProperties, Map compositeProperties) {
        String transactionTypeProp = (String)compositeProperties.get("javax.persistence.transactionType");
        if (transactionTypeProp != null) {
            memberProperties.put("javax.persistence.transactionType", transactionTypeProp);
        } else {
            memberProperties.remove("javax.persistence.transactionType");
        }
        String serverPlatformProp = (String)compositeProperties.get("eclipselink.target-server");
        if (serverPlatformProp != null) {
            memberProperties.put("eclipselink.target-server", serverPlatformProp);
        } else {
            memberProperties.remove("eclipselink.target-server");
        }
        Boolean isValidationOnly = (Boolean)compositeProperties.get("eclipselink.validation-only");
        if (isValidationOnly != null) {
            memberProperties.put("eclipselink.validation-only", isValidationOnly);
        } else {
            memberProperties.remove("eclipselink.validation-only");
        }
    }

    protected static Map<String, SEPersistenceUnitInfo> getCompositeMemberPuInfoMap(PersistenceUnitInfo puInfo, Map predeployProperties) {
        Set<SEPersistenceUnitInfo> memeberPuInfoSet = PersistenceUnitProcessor.getPersistenceUnits(puInfo.getClassLoader(), predeployProperties, puInfo.getJarFileUrls());
        HashMap<String, SEPersistenceUnitInfo> memberPuInfoMap = new HashMap<String, SEPersistenceUnitInfo>(memeberPuInfoSet.size());
        for (SEPersistenceUnitInfo memberPuInfo : memeberPuInfoSet) {
            memberPuInfo.setTransactionType(puInfo.getTransactionType());
            EntityManagerSetupImpl.overrideMemberProperties(memberPuInfo.getProperties(), puInfo.getProperties());
            if (EntityManagerSetupImpl.isComposite(memberPuInfo)) {
                Map<String, SEPersistenceUnitInfo> containedMemberPuInfoMap = EntityManagerSetupImpl.getCompositeMemberPuInfoMap(memberPuInfo, memberPuInfo.getProperties());
                for (Map.Entry<String, SEPersistenceUnitInfo> entry : containedMemberPuInfoMap.entrySet()) {
                    String containedMemberPuName = entry.getKey();
                    SEPersistenceUnitInfo containedMemberPuInfo = entry.getValue();
                    SEPersistenceUnitInfo anotherMemeberPuInfo = memberPuInfoMap.get(containedMemberPuName);
                    if (anotherMemeberPuInfo == null) {
                        memberPuInfoMap.put(containedMemberPuName, containedMemberPuInfo);
                        continue;
                    }
                    EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(containedMemberPuName, containedMemberPuInfo, anotherMemeberPuInfo);
                }
                continue;
            }
            String memberPuName = memberPuInfo.getPersistenceUnitName();
            SEPersistenceUnitInfo anotherMemeberPuInfo = memberPuInfoMap.get(memberPuName);
            if (anotherMemeberPuInfo == null) {
                memberPuInfoMap.put(memberPuName, memberPuInfo);
                continue;
            }
            EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(memberPuName, memberPuInfo, anotherMemeberPuInfo);
        }
        return memberPuInfoMap;
    }

    protected static Set<SEPersistenceUnitInfo> getCompositeMemberPuInfoSet(PersistenceUnitInfo puInfo, Map predeployProperties) {
        return new HashSet<SEPersistenceUnitInfo>(EntityManagerSetupImpl.getCompositeMemberPuInfoMap(puInfo, predeployProperties).values());
    }

    public static void throwPersistenceUnitNameAlreadyInUseException(String puName, PersistenceUnitInfo newPuInfo, PersistenceUnitInfo exsitingPuInfo) {
        String anotherPuUrl;
        String puUrl;
        try {
            puUrl = URLDecoder.decode(newPuInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
            anotherPuUrl = URLDecoder.decode(exsitingPuInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            puUrl = newPuInfo.getPersistenceUnitRootUrl().toString();
            anotherPuUrl = exsitingPuInfo.getPersistenceUnitRootUrl().toString();
        }
        throw PersistenceUnitLoadingException.persistenceUnitNameAlreadyInUse((String)puName, (String)puUrl, (String)anotherPuUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerSetupImpl refreshMetadata(Map properties) {
        String sessionName = this.getSessionName();
        String uniqueName = this.getPersistenceUnitUniqueName();
        EntityManagerSetupImpl newSetupImpl = new EntityManagerSetupImpl(uniqueName, sessionName);
        newSetupImpl.setIsInContainerMode(this.isInContainerMode);
        newSetupImpl.enableWeaving = this.enableWeaving;
        HashMap refreshProperties = new HashMap();
        refreshProperties.putAll(this.getSession().getProperties());
        if (properties != null) {
            refreshProperties.putAll(properties);
        }
        newSetupImpl.predeploy(this.getPersistenceUnitInfo(), refreshProperties);
        if (!this.isInContainerMode) {
            newSetupImpl.predeploy(this.getPersistenceUnitInfo(), refreshProperties);
        }
        HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (hashMap) {
            SessionManager.getManager().getSessions().remove(sessionName, this.getSession());
            if (EntityManagerFactoryProvider.emSetupImpls.get(sessionName).equals(this)) {
                EntityManagerFactoryProvider.emSetupImpls.remove(sessionName);
            }
            this.setIsMetadataExpired(true);
            this.getSession().setRefreshMetadataListener(null);
            EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, newSetupImpl);
        }
        return newSetupImpl;
    }

    public void triggerMetadataRefresh(Map properties) {
        this.refreshMetadata(properties);
    }

    protected static enum TableCreationType {
        NONE,
        CREATE,
        DROP,
        EXTEND;

    }
}

