/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class ConverterAccessor
extends ORMetadata {
    protected String className;
    protected Boolean autoApply;

    public ConverterAccessor() {
        super("<converter>");
    }

    public ConverterAccessor(MetadataAnnotation converter, MetadataClass metadataClass, MetadataProject project) {
        super(converter, metadataClass, project);
        this.autoApply = (Boolean)converter.getAttributeBooleanDefaultFalse("autoApply");
    }

    public boolean autoApply() {
        return this.autoApply != null && this.autoApply != false;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConverterAccessor) {
            ConverterAccessor converter = (ConverterAccessor)objectToCompare;
            return this.valuesMatch(this.autoApply, converter.getAutoApply());
        }
        return false;
    }

    public Boolean getAutoApply() {
        return this.autoApply;
    }

    public MetadataClass getAutoApplyConvertType() {
        String type = ((MetadataClass)this.getAccessibleObject()).getGenericType().get(2);
        return this.getMetadataClass(type);
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String getIdentifier() {
        return this.getAccessibleObjectName();
    }

    public String getJavaClassName() {
        return this.getAccessibleObjectName();
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        ConverterAccessor accessor = (ConverterAccessor)metadata;
        this.autoApply = (Boolean)this.mergeSimpleObjects(this.autoApply, accessor.getAutoApply(), accessor, "@auto-apply");
    }

    public void process(DatabaseMapping mapping, boolean isForMapKey) {
        if (mapping.isDirectMapMapping() && isForMapKey) {
            ((DirectMapMapping)mapping).setKeyConverter((Converter)new ConverterClass(this.getJavaClassName()));
        } else if (mapping.isDirectCollectionMapping()) {
            ((DirectCollectionMapping)mapping).setValueConverter((Converter)new ConverterClass(this.getJavaClassName()));
        } else if (!mapping.isAggregateCollectionMapping() && mapping.isDirectToFieldMapping()) {
            ((AbstractDirectMapping)mapping).setConverter((Converter)new ConverterClass(this.getJavaClassName()));
        }
    }

    public void setAutoApply(Boolean autoApply) {
        this.autoApply = autoApply;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

