/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ConverterAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ConvertMetadata
extends ORMetadata {
    public static final String KEY = "key";
    private String m_text;
    private Boolean m_disableConversion;
    private MetadataClass m_converterClass;
    private String m_converterClassName;
    private String m_attributeName;

    public ConvertMetadata() {
        super("<convert");
    }

    public ConvertMetadata(MetadataAnnotation convert, MetadataAccessor accessor) {
        super(convert, accessor);
        this.m_converterClass = this.getMetadataClass((String)convert.getAttributeClass("converter", Void.class));
        this.m_attributeName = (String)convert.getAttributeString("attributeName");
        this.m_disableConversion = (Boolean)convert.getAttributeBooleanDefaultFalse("disableConversion");
    }

    public boolean disableConversion() {
        return this.m_disableConversion != null && this.m_disableConversion != false;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConvertMetadata) {
            ConvertMetadata convert = (ConvertMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_text, convert.getText())) {
                return false;
            }
            if (!this.valuesMatch(this.m_converterClassName, convert.getConverterClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_attributeName, convert.getAttributeName())) {
                return false;
            }
            return this.valuesMatch(this.m_disableConversion, convert.getDisableConversion());
        }
        return false;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getConverterClassName() {
        return this.m_converterClassName;
    }

    public Boolean getDisableConversion() {
        return this.m_disableConversion;
    }

    @Override
    protected String getText() {
        return this.m_text;
    }

    public boolean hasAttributeName() {
        return this.m_attributeName != null && !this.m_attributeName.equals("");
    }

    public boolean hasConverterClass() {
        return this.m_converterClass != null && !this.m_converterClass.isVoid();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_converterClass = this.initXMLClassName(this.m_converterClassName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasText()) return;
        boolean applyToKey = false;
        DatabaseMapping mappingToApplyConvert = mapping;
        if (this.hasAttributeName()) {
            if (mapping.isAggregateMapping()) {
                throw new RuntimeException("Work in progress. Converts for embedded mappings not supported yet.");
            }
            if (!mapping.isMapKeyMapping()) throw new RuntimeException("Attribute name should not be specified.");
            MappedKeyMapContainerPolicy policy = (MappedKeyMapContainerPolicy)mapping.getContainerPolicy();
            mappingToApplyConvert = this.getAttributeName().startsWith("key.") ? (DatabaseMapping)policy.getKeyMapping() : (DatabaseMapping)policy.getValueMapping();
        } else if (mapping.isAggregateMapping()) {
            throw new RuntimeException("Convert applied to embedded mapping with no attribute name specified");
        }
        if (this.hasConverterClass()) {
            ConverterAccessor converterAccessor = this.getProject().getConverterAccessor(this.m_converterClass);
            if (converterAccessor == null) {
                throw new RuntimeException("Converter class  not found: " + this.m_converterClass);
            }
            converterAccessor.process(mappingToApplyConvert, applyToKey);
            return;
        } else {
            if (!this.getProject().hasAutoApplyConverter(referenceClass) || this.disableConversion()) return;
            this.getProject().getAutoApplyConverter(referenceClass).process(mapping, applyToKey);
        }
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setConverterClassName(String converterClassName) {
        this.m_converterClassName = converterClassName;
    }

    public void setDisableConversion(Boolean disableConversion) {
        this.m_disableConversion = disableConversion;
    }

    public void setText(String text) {
        this.m_text = text;
    }
}

