/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.SerializableDescriptorEventHolder;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.MethodSerialImpl;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class JPAEntityListenerHolder
implements SerializableDescriptorEventHolder,
Cloneable {
    public String listenerClassName;
    public Boolean isDefaultListener;
    public Boolean extendsDescriptorEvent;
    public transient DescriptorEventListener listener;
    public Hashtable<String, List<MethodSerialImpl>> serializableMethods;

    public void setIsDefaultListener(Boolean isDefaultListener) {
        this.isDefaultListener = isDefaultListener;
    }

    public void addListenerToEventManager(ClassDescriptor descriptor, ClassLoader loader) {
        if (this.listener == null) {
            if (this.listenerClassName != null) {
                Object entityListenerClassInstance = this.getListenerInstance(loader);
                if (this.serializableMethods == null) {
                    this.listener = (DescriptorEventListener)entityListenerClassInstance;
                } else {
                    EntityListener entityListener = new EntityListener(entityListenerClassInstance, descriptor.getJavaClass());
                    entityListener.setAllEventMethods(this.convertToMethods(loader));
                    this.listener = entityListener;
                }
            } else {
                EntityClassListener entityListener = new EntityClassListener(descriptor.getJavaClass());
                entityListener.setAllEventMethods(this.convertToMethods(loader));
                this.listener = entityListener;
            }
        }
        if (this.listenerClassName != null) {
            if (this.isDefaultListener.booleanValue()) {
                descriptor.getEventManager().addDefaultEventListener(this.listener);
            } else {
                descriptor.getEventManager().addEntityListenerEventListener(this.listener);
            }
        } else {
            descriptor.getEventManager().setEntityEventListener(this.listener);
        }
    }

    private Object getListenerInstance(ClassLoader loader) {
        Object entityListenerClassInstance;
        block9: {
            entityListenerClassInstance = null;
            Class entityListenerClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        entityListenerClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.listenerClassName, true, loader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.unableToLoadClass((String)this.listenerClassName, (Exception)exception.getException());
                    }
                    try {
                        entityListenerClassInstance = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(entityListenerClass));
                        break block9;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.errorInstantiatingClass((Object)entityListenerClass, (Exception)exception.getException());
                    }
                }
                entityListenerClass = PrivilegedAccessHelper.getClassForName((String)this.listenerClassName, (boolean)true, (ClassLoader)loader);
                entityListenerClassInstance = PrivilegedAccessHelper.newInstanceFromClass((Class)entityListenerClass);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.unableToLoadClass((String)this.listenerClassName, (Exception)exception);
            }
            catch (IllegalAccessException exception) {
                throw ValidationException.errorInstantiatingClass(entityListenerClass, (Exception)exception);
            }
            catch (InstantiationException exception) {
                throw ValidationException.errorInstantiatingClass(entityListenerClass, (Exception)exception);
            }
        }
        return entityListenerClassInstance;
    }

    public void convertToSerializableMethods(Hashtable<String, List<Method>> methods) {
        this.serializableMethods = new Hashtable();
        for (String event : methods.keySet()) {
            List<Method> methodList = methods.get(event);
            ArrayList<MethodSerialImpl> newMethodList = new ArrayList<MethodSerialImpl>();
            for (Method method : methodList) {
                MethodSerialImpl serializableMethod = new MethodSerialImpl(method);
                newMethodList.add(serializableMethod);
            }
            this.serializableMethods.put(event, newMethodList);
        }
    }

    public void addEventMethod(String event, Method method) {
        if (!this.getMethods().containsKey(event)) {
            ArrayList<Method> methodsList = new ArrayList<Method>();
            methodsList.add(method);
            this.serializableMethods.put(event, methodsList);
        }
        MethodSerialImpl convertedMethod = new MethodSerialImpl(method);
        this.serializableMethods.get(event).add(convertedMethod);
    }

    public Hashtable<String, List<Method>> convertToMethods(ClassLoader loader) {
        Hashtable<String, List<Method>> table = new Hashtable<String, List<Method>>();
        for (String event : this.serializableMethods.keySet()) {
            List<MethodSerialImpl> methodList = this.serializableMethods.get(event);
            ArrayList<Method> newMethodList = new ArrayList<Method>();
            for (MethodSerialImpl serializedMethod : methodList) {
                try {
                    Method method = serializedMethod.convertToMethod(loader);
                    newMethodList.add(method);
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            table.put(event, newMethodList);
        }
        return table;
    }

    public Hashtable<String, List<MethodSerialImpl>> getMethods() {
        if (this.serializableMethods == null) {
            this.serializableMethods = new Hashtable();
        }
        return this.serializableMethods;
    }
}

