/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.metamodel.BasicTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.IdentifiableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.Project;

public class MetamodelImpl
implements Metamodel,
Serializable {
    private static final long serialVersionUID = -7352420189248464690L;
    private AbstractSession session;
    private Map<Class, EntityTypeImpl<?>> entities;
    private Map<Class, EmbeddableTypeImpl<?>> embeddables;
    private Map<Class, ManagedTypeImpl<?>> managedTypes;
    private Map<Class, TypeImpl<?>> types;
    private Set<MappedSuperclassTypeImpl<?>> mappedSuperclasses;
    public static final Class DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS = Object.class;

    public MetamodelImpl(AbstractSession session) {
        this.session = session;
        this.initialize();
    }

    public MetamodelImpl(EntityManager em) {
        this(JpaHelper.getEntityManager(em).getAbstractSession());
    }

    public MetamodelImpl(EntityManagerFactory emf) {
        this((AbstractSession)JpaHelper.getDatabaseSession(emf));
    }

    public MetamodelImpl(EntityManagerSetupImpl emSetupImpl) {
        this((AbstractSession)emSetupImpl.getSession());
    }

    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        EmbeddableTypeImpl<?> aType = this.embeddables.get(clazz);
        if (!(aType instanceof EmbeddableType)) {
            this.entityEmbeddableManagedTypeNotFound(this.embeddables, aType, clazz, "Embeddable", "EmbeddableType");
        }
        return aType;
    }

    private void entityEmbeddableManagedTypeNotFound(Map typeMap, Object aType, Class clazz, String metamodelType, String metamodelTypeName) {
        if (typeMap.isEmpty()) {
            AbstractSessionLog.getLog().log(6, "metamodel", "metamodel_type_collection_empty_during_lookup", (Object)clazz, (Object)metamodelTypeName);
        }
        if (clazz == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_class_null_type_instance_for_null_key", (Object[])new Object[]{metamodelTypeName, metamodelType}));
        }
        if (aType == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_class_null_type_instance", (Object[])new Object[]{clazz.getCanonicalName(), metamodelTypeName, metamodelType}));
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_class_incorrect_type_instance", (Object[])new Object[]{clazz, metamodelTypeName, aType}));
    }

    public <X> EntityType<X> entity(Class<X> clazz) {
        EntityTypeImpl<?> aType = this.entities.get(clazz);
        if (!(aType instanceof EntityType)) {
            this.entityEmbeddableManagedTypeNotFound(this.entities, aType, clazz, "Entity", "EntityType");
        }
        return aType;
    }

    public List<Attribute> getAllManagedTypeAttributes() {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (ManagedType managedType : this.managedTypes.values()) {
            attributeList.addAll(managedType.getAttributes());
        }
        return attributeList;
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new LinkedHashSet(this.embeddables.values());
    }

    public Set<EntityType<?>> getEntities() {
        return new LinkedHashSet(this.entities.values());
    }

    public Map<Class, ManagedTypeImpl<?>> getManagedTypesMap() {
        return this.managedTypes;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return new LinkedHashSet(this.managedTypes.values());
    }

    public Set<MappedSuperclassTypeImpl<?>> getMappedSuperclasses() {
        return new LinkedHashSet(this.mappedSuperclasses);
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    private boolean putType(Class javaClassKey, TypeImpl typeValue) {
        boolean isValid = true;
        if (javaClassKey == null) {
            isValid = false;
        }
        this.types.put(javaClassKey, typeValue);
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> TypeImpl<X> getType(Class<X> javaClass) {
        TypeImpl<?> type = this.types.get(javaClass);
        if (type == null) {
            Map<Class, TypeImpl<?>> map = this.types;
            synchronized (map) {
                type = this.types.get(javaClass);
                if (type == null) {
                    type = new BasicTypeImpl(javaClass);
                    this.putType(javaClass, type);
                }
            }
        }
        return type;
    }

    public Map<Class, TypeImpl<?>> getTypes() {
        return this.types;
    }

    protected boolean hasMappedSuperclass(String qualifiedClassNameKeyString) {
        return this.getSession().getProject().hasMappedSuperclass(qualifiedClassNameKeyString);
    }

    private void initialize() {
        Class descriptorJavaType;
        this.types = new LinkedHashMap();
        this.entities = new LinkedHashMap();
        this.embeddables = new LinkedHashMap();
        this.managedTypes = new LinkedHashMap();
        this.mappedSuperclasses = new LinkedHashSet();
        for (Object v : this.getSession().getDescriptors().values()) {
            ManagedTypeImpl<?> managedType = ManagedTypeImpl.create(this, (ClassDescriptor)v);
            descriptorJavaType = managedType.getJavaType();
            if (descriptorJavaType == null) {
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_relationaldescriptor_javaclass_null_on_managedType", v, managedType);
            }
            this.putType(descriptorJavaType, managedType);
            this.managedTypes.put(descriptorJavaType, managedType);
            if (managedType.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.entities.put(descriptorJavaType, (EntityTypeImpl)managedType);
            }
            if (!managedType.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) continue;
            this.embeddables.put(descriptorJavaType, (EmbeddableTypeImpl)managedType);
        }
        for (ClassDescriptor classDescriptor : this.getSession().getProject().getMappedSuperclassDescriptors().values()) {
            MappedSuperclassTypeImpl mappedSuperclassType = (MappedSuperclassTypeImpl)ManagedTypeImpl.create(this, classDescriptor);
            this.mappedSuperclasses.add(mappedSuperclassType);
            descriptorJavaType = mappedSuperclassType.getJavaType();
            if (descriptorJavaType == null) {
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_relationaldescriptor_javaclass_null_on_managedType", (Object)classDescriptor, (Object)mappedSuperclassType);
            }
            this.putType(descriptorJavaType, mappedSuperclassType);
            this.managedTypes.put(descriptorJavaType, mappedSuperclassType);
        }
        for (ManagedTypeImpl managedTypeImpl : this.managedTypes.values()) {
            Class aClass = managedTypeImpl.getJavaType();
            if (aClass == null) {
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_itentifiableType_javaclass_null_cannot_set_supertype", (Object)managedTypeImpl.getDescriptor(), (Object)this);
                continue;
            }
            Class superclass = aClass.getSuperclass();
            IdentifiableType identifiableTypeSuperclass = null;
            if (!managedTypeImpl.isIdentifiableType() || superclass == ClassConstants.OBJECT) continue;
            identifiableTypeSuperclass = (IdentifiableType)this.managedTypes.get(superclass);
            ((IdentifiableTypeImpl)managedTypeImpl).setSupertype(identifiableTypeSuperclass);
            if (identifiableTypeSuperclass != null && ((IdentifiableTypeImpl)identifiableTypeSuperclass).isMappedSuperclass()) {
                ((MappedSuperclassTypeImpl)identifiableTypeSuperclass).addInheritingType((IdentifiableTypeImpl)managedTypeImpl);
            }
            ((IdentifiableTypeImpl)managedTypeImpl).setSupertype(identifiableTypeSuperclass);
        }
        for (ManagedTypeImpl managedTypeImpl : new ArrayList(this.managedTypes.values())) {
            managedTypeImpl.initialize();
        }
        for (ManagedTypeImpl managedTypeImpl : this.managedTypes.values()) {
            if (!managedTypeImpl.isIdentifiableType()) continue;
            ((IdentifiableTypeImpl)managedTypeImpl).initializeIdAttributes();
        }
        if (!(this.embeddables != null && !this.embeddables.isEmpty() || this.managedTypes != null && !this.managedTypes.isEmpty() || this.entities != null && !this.entities.isEmpty())) {
            AbstractSessionLog.getLog().log(6, "metamodel", "metamodel_type_collection_empty", null, true);
        }
    }

    public <X> ManagedType<X> managedType(Class<X> clazz) {
        ManagedTypeImpl<?> aType = this.managedTypes.get(clazz);
        if (!(aType instanceof ManagedType)) {
            this.entityEmbeddableManagedTypeNotFound(this.managedTypes, aType, clazz, "Managed", "ManagedType");
        }
        return aType;
    }

    public void printAllTypes() {
        if (this.types == null || this.types.isEmpty()) {
            AbstractSessionLog.getLog().log(6, "metamodel", "metamodel_type_collection_empty", null, true);
        } else {
            this.session.log(5, "metamodel", "metamodel_print_type_header", (Object)this.types.size());
            for (Type type : this.types.values()) {
                this.session.log(5, "metamodel", "metamodel_print_type_value", (Object)type);
            }
        }
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(this.getClass().getSimpleName());
        aBuffer.append("@");
        aBuffer.append(this.hashCode());
        aBuffer.append(" [");
        if (this.types != null) {
            aBuffer.append(" ");
            aBuffer.append(this.types.size());
            aBuffer.append(" Types: ");
        }
        if (this.managedTypes != null) {
            aBuffer.append(", ");
            aBuffer.append(this.managedTypes.size());
            aBuffer.append(" ManagedTypes: ");
        }
        if (this.entities != null) {
            aBuffer.append(", ");
            aBuffer.append(this.entities.size());
            aBuffer.append(" EntityTypes: ");
        }
        if (this.mappedSuperclasses != null) {
            aBuffer.append(", ");
            aBuffer.append(this.mappedSuperclasses.size());
            aBuffer.append(" MappedSuperclassTypes: ");
        }
        if (this.embeddables != null) {
            aBuffer.append(", ");
            aBuffer.append(this.embeddables.size());
            aBuffer.append(" EmbeddableTypes: ");
        }
        aBuffer.append("]");
        return aBuffer.toString();
    }
}

