/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class AggregateMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected ClassDescriptor referenceDescriptor;

    public AggregateMapping() {
        this.setWeight(WEIGHT_AGGREGATE);
    }

    protected DeleteObjectQuery buildAggregateDeleteQuery(DeleteObjectQuery sourceQuery, Object sourceAttributeValue) {
        DeleteObjectQuery aggregateQuery = new DeleteObjectQuery();
        this.buildAggregateModifyQuery(sourceQuery, aggregateQuery, sourceAttributeValue);
        return aggregateQuery;
    }

    protected void buildAggregateModifyQuery(ObjectLevelModifyQuery sourceQuery, ObjectLevelModifyQuery aggregateQuery, Object sourceAttributeValue) {
        if (sourceQuery.getSession().isUnitOfWork() && !this.isMapKeyMapping()) {
            Object backupAttributeValue = this.getAttributeValueFromBackupClone(sourceQuery.getBackupClone());
            if (backupAttributeValue == null) {
                backupAttributeValue = this.getObjectBuilder(sourceAttributeValue, sourceQuery.getSession()).buildNewInstance();
            }
            aggregateQuery.setBackupClone(backupAttributeValue);
        }
        aggregateQuery.setCascadePolicy(sourceQuery.getCascadePolicy());
        aggregateQuery.setObject(sourceAttributeValue);
        aggregateQuery.setTranslationRow(sourceQuery.getTranslationRow());
        aggregateQuery.setSession(sourceQuery.getSession());
        aggregateQuery.setProperties(sourceQuery.getProperties());
    }

    protected WriteObjectQuery buildAggregateWriteQuery(WriteObjectQuery sourceQuery, Object sourceAttributeValue) {
        WriteObjectQuery aggregateQuery = new WriteObjectQuery();
        this.buildAggregateModifyQuery(sourceQuery, aggregateQuery, sourceAttributeValue);
        return aggregateQuery;
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(clone);
        this.setAttributeValueInObject(backup, this.buildBackupClonePart(attributeValue, unitOfWork));
    }

    protected Object buildBackupClonePart(Object attributeValue, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return null;
        }
        return this.getObjectBuilder(attributeValue, unitOfWork).buildBackupClone(attributeValue, unitOfWork);
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        this.setAttributeValueInObject(clone, this.buildClonePart(original, cacheKey, attributeValue, refreshCascade, cloningSession));
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object cloneAttributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, sharedCacheKey, executionSession, true, null);
        this.setAttributeValueInObject(clone, cloneAttributeValue);
    }

    protected Object buildClonePart(Object original, CacheKey cacheKey, Object attributeValue, Integer refreshCascade, AbstractSession cloningSession) {
        return this.buildClonePart(attributeValue, cacheKey, refreshCascade, cloningSession, cloningSession.isUnitOfWork() && ((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original));
    }

    protected Object buildClonePart(Object attributeValue, CacheKey parentCacheKey, Integer refreshCascade, AbstractSession cloningSession, boolean isNewObject) {
        if (attributeValue == null) {
            return null;
        }
        if (isNewObject) {
            ((UnitOfWorkImpl)cloningSession).addNewAggregate(attributeValue);
        }
        if (cloningSession.isUnitOfWork() && cloningSession.isClassReadOnly(attributeValue.getClass())) {
            return attributeValue;
        }
        ObjectBuilder aggregateObjectBuilder = this.getObjectBuilder(attributeValue, cloningSession);
        Object clonedAttributeValue = aggregateObjectBuilder.instantiateWorkingCopyClone(attributeValue, cloningSession);
        aggregateObjectBuilder.populateAttributesForClone(attributeValue, parentCacheKey, clonedAttributeValue, refreshCascade, cloningSession);
        return clonedAttributeValue;
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        this.setAttributeValueInObject(copy, this.buildCopyOfAttributeValue(attributeValue, group));
    }

    protected Object buildCopyOfAttributeValue(Object attributeValue, CopyGroup group) {
        if (attributeValue == null) {
            return null;
        }
        return this.getObjectBuilder(attributeValue, group.getSession()).copyObject(attributeValue, group);
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        String attributeName = this.getAttributeName();
        Object attributeValue = this.getRealAttributeValueFromObject(queryObject, session);
        if (!policy.shouldIncludeInQuery(queryObject.getClass(), attributeName, attributeValue)) {
            return null;
        }
        if (attributeValue == null) {
            Expression expression = expressionBuilder.get(attributeName);
            return policy.completeExpressionForNull(expression);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(attributeValue, policy, expressionBuilder.get(attributeName), processedObjects, session);
    }

    protected Object buildNewMergeInstanceOf(Object sourceAttributeValue, AbstractSession session) {
        return this.getObjectBuilder(sourceAttributeValue, session).buildNewInstance();
    }

    protected boolean compareAttributeValues(Object attributeValue1, Object attributeValue2, AbstractSession session) {
        if (attributeValue1 == null && attributeValue2 == null) {
            return true;
        }
        if (attributeValue1 == null || attributeValue2 == null) {
            return false;
        }
        if (attributeValue1.getClass() != attributeValue2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(attributeValue1, session).compareObjects(attributeValue1, attributeValue2, session);
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = this.getAttributeValueFromObject(clone);
        Object backupAttribute = null;
        if (!owner.isNew()) {
            backupAttribute = this.getAttributeValueFromObject(backup);
            if (cloneAttribute == null && backupAttribute == null) {
                return null;
            }
            if (cloneAttribute != null && backupAttribute != null && !cloneAttribute.getClass().equals(backupAttribute.getClass())) {
                backupAttribute = null;
            }
        }
        AggregateChangeRecord changeRecord = new AggregateChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setOldValue(backupAttribute);
        if (cloneAttribute == null) {
            changeRecord.setChangedObject(null);
            return changeRecord;
        }
        ObjectBuilder builder = this.getObjectBuilder(cloneAttribute, session);
        ObjectChangeSet initialChanges = builder.createObjectChangeSet(cloneAttribute, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), backupAttribute == null, session);
        ObjectChangeSet changeSet = builder.compareForChange(cloneAttribute, backupAttribute, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
        if (changeSet == null) {
            if (initialChanges.isNew()) {
                changeSet = initialChanges;
            } else {
                return null;
            }
        }
        changeRecord.setChangedObject(changeSet);
        return changeRecord;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        return this.compareAttributeValues(this.getAttributeValueFromObject(firstObject), this.getAttributeValueFromObject(secondObject), session);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block6: {
            super.convertClassNamesToClasses(classLoader);
            if (this.getReferenceClassName() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.setReferenceClass((Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader)));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                        }
                    }
                    this.setReferenceClass(PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader));
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
                }
            }
        }
    }

    protected void executeEvent(int eventCode, ObjectLevelModifyQuery query) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(query.getObject(), query.getSession());
        if (referenceDescriptor.getEventManager().hasAnyEventListeners()) {
            referenceDescriptor.getEventManager().executeEvent(new DescriptorEvent(eventCode, query));
        }
    }

    protected void fixAttributeValue(Object attributeValue, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        if (attributeValue == null) {
            return;
        }
        this.getObjectBuilder(attributeValue, query.getSession()).fixObjectReferences(attributeValue, objectDescriptors, processedObjects, query, session);
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        this.fixAttributeValue(attributeValue, objectDescriptors, processedObjects, query, session);
    }

    protected Object getAttributeValueFromBackupClone(Object backupClone) {
        return this.getAttributeValueFromObject(backupClone);
    }

    protected ObjectBuilder getObjectBuilderForClass(Class javaClass, AbstractSession session) {
        return this.getReferenceDescriptor(javaClass, session).getObjectBuilder();
    }

    protected ObjectBuilder getObjectBuilder(Object attributeValue, AbstractSession session) {
        return this.getReferenceDescriptor(attributeValue, session).getObjectBuilder();
    }

    protected DescriptorQueryManager getQueryManager(Object attributeValue, AbstractSession session) {
        return this.getReferenceDescriptor(attributeValue, session).getQueryManager();
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return this.referenceDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.referenceDescriptor.getJavaClass() == theClass) {
            return this.referenceDescriptor;
        }
        ClassDescriptor subDescriptor = session.getDescriptor(theClass);
        if (subDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Object attributeValue, AbstractSession session) {
        if (attributeValue == null) {
            return this.referenceDescriptor;
        }
        return this.getReferenceDescriptor(attributeValue.getClass(), session);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.setReferenceDescriptor(session.getDescriptor(this.getReferenceClass()));
        ClassDescriptor refDescriptor = this.getReferenceDescriptor();
        if (refDescriptor == null) {
            session.getIntegrityChecker().handleError(DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this));
            return;
        }
        if (refDescriptor.isDescriptorTypeAggregate()) {
            refDescriptor.checkInheritanceTreeAggregateSettings(session, this);
        } else {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getReferenceClass().getName(), this));
        }
    }

    @Override
    public boolean isAggregateMapping() {
        return true;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        this.iterateOnAttributeValue(iterator, this.getAttributeValueFromObject(iterator.getVisitedParent()));
    }

    protected void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        iterator.iterateForAggregateMapping(attributeValue, this, this.getReferenceDescriptor(attributeValue, iterator.getSession()));
    }

    @Override
    public void load(Object object, AttributeItem item, AbstractSession session) {
        if (item.getGroup() != null) {
            Object value = this.getAttributeValueFromObject(object);
            this.getObjectBuilder(value, session).load(object, item.getGroup(), session);
        }
    }

    protected void mergeAttributeValue(Object targetAttributeValue, boolean isTargetUnInitialized, Object sourceAttributeValue, MergeManager mergeManager, AbstractSession targetSession) {
        if (mergeManager.getSession().isClassReadOnly(sourceAttributeValue.getClass())) {
            return;
        }
        if (mergeManager.getSession().isClassReadOnly(targetAttributeValue.getClass())) {
            return;
        }
        ClassDescriptor descriptor = this.getReferenceDescriptor(sourceAttributeValue, mergeManager.getSession());
        descriptor.getObjectChangePolicy().dissableEventProcessing(targetAttributeValue);
        try {
            descriptor.getObjectBuilder().mergeIntoObject(targetAttributeValue, isTargetUnInitialized, sourceAttributeValue, mergeManager, targetSession);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(targetAttributeValue);
        }
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet aggregateChangeSet = (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject();
        if (aggregateChangeSet == null) {
            this.setAttributeValueInObject(target, null);
            return;
        }
        Object sourceAggregate = null;
        if (source != null) {
            sourceAggregate = this.getAttributeValueFromObject(source);
        }
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(aggregateChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object targetAggregate = this.getAttributeValueFromObject(target);
        if (targetAggregate == null || targetAggregate == sourceAggregate) {
            targetAggregate = objectBuilder.buildNewInstance();
        } else if (aggregateChangeSet.getClassType(mergeManager.getSession()) != targetAggregate.getClass()) {
            targetAggregate = objectBuilder.buildNewInstance();
        }
        objectBuilder.mergeChangesIntoObject(targetAggregate, aggregateChangeSet, sourceAggregate, mergeManager, targetSession);
        this.setAttributeValueInObject(target, targetAggregate);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        Object sourceAttributeValue = this.getAttributeValueFromObject(source);
        if (sourceAttributeValue == null) {
            this.setAttributeValueInObject(target, null);
            return;
        }
        Object targetAttributeValue = this.getAttributeValueFromObject(target);
        if (targetAttributeValue == null || targetAttributeValue == sourceAttributeValue || !targetAttributeValue.getClass().equals(sourceAttributeValue.getClass())) {
            targetAttributeValue = this.buildNewMergeInstanceOf(sourceAttributeValue, mergeManager.getSession());
            this.mergeAttributeValue(targetAttributeValue, true, sourceAttributeValue, mergeManager, targetSession);
            if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && !mergeManager.isForRefresh()) {
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), this.getAttributeValueFromObject(target), targetAttributeValue);
            }
        } else {
            this.mergeAttributeValue(targetAttributeValue, isTargetUnInitialized, sourceAttributeValue, mergeManager, targetSession);
        }
        this.setAttributeValueInObject(target, targetAttributeValue);
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postDeleteAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    public void postDeleteAttributeValue(DeleteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, query.getSession());
        if (descriptor.getObjectBuilder().isSimple() && !descriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        DeleteObjectQuery aggregateQuery = this.buildAggregateDeleteQuery(query, attributeValue);
        descriptor.getQueryManager().postDelete(aggregateQuery);
        this.executeEvent(3, aggregateQuery);
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postInsertAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    public void postInsertAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, query.getSession());
        if (descriptor.getObjectBuilder().isSimple() && !descriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        descriptor.getQueryManager().postInsert(aggregateQuery);
        this.executeEvent(5, aggregateQuery);
        this.executeEvent(1, aggregateQuery);
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postUpdateAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    public void postUpdateAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        AbstractSession session = query.getSession();
        ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, session);
        if (descriptor.getObjectBuilder().isSimple() && !descriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        ObjectChangeSet changeSet = null;
        UnitOfWorkChangeSet uowChangeSet = null;
        if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null) {
            uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet();
            changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(attributeValue);
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        aggregateQuery.setObjectChangeSet(changeSet);
        descriptor.getQueryManager().postUpdate(aggregateQuery);
        this.executeEvent(7, aggregateQuery);
        this.executeEvent(1, aggregateQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preDeleteAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    public void preDeleteAttributeValue(DeleteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        AbstractSession session = query.getSession();
        ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, session);
        if (descriptor.getObjectBuilder().isSimple() && !descriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        DeleteObjectQuery aggregateQuery = this.buildAggregateDeleteQuery(query, attributeValue);
        this.executeEvent(2, aggregateQuery);
        descriptor.getQueryManager().preDelete(aggregateQuery);
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preInsertAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    public void preInsertAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        AbstractSession session = query.getSession();
        ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, session);
        if (descriptor.getObjectBuilder().isSimple() && !descriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        ObjectChangeSet changeSet = null;
        if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null) {
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet();
            changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(aggregateQuery.getObject());
        }
        aggregateQuery.setObjectChangeSet(changeSet);
        if (changeSet == null) {
            this.executeEvent(0, aggregateQuery);
            this.executeEvent(4, aggregateQuery);
        }
        descriptor.getQueryManager().preInsert(aggregateQuery);
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preUpdateAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    public void preUpdateAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        AbstractSession session = query.getSession();
        ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, session);
        if (descriptor.getObjectBuilder().isSimple() && !descriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        ObjectChangeSet changeSet = null;
        UnitOfWorkChangeSet uowChangeSet = null;
        if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null) {
            uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet();
            changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(aggregateQuery.getObject());
        }
        aggregateQuery.setObjectChangeSet(changeSet);
        if (changeSet == null) {
            this.executeEvent(0, aggregateQuery);
            this.executeEvent(6, aggregateQuery);
        }
        descriptor.getQueryManager().preUpdate(aggregateQuery);
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        super.remoteInitialization(session);
        ClassDescriptor refDescriptor = this.getReferenceDescriptor();
        if (session.hasCorrespondingDescriptor(refDescriptor)) {
            ClassDescriptor correspondingDescriptor = session.getDescriptorCorrespondingTo(refDescriptor);
            this.setReferenceDescriptor(correspondingDescriptor);
        } else {
            session.privilegedAddDescriptor(refDescriptor);
            refDescriptor.remoteInitialization(session);
        }
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
    }

    public void setReferenceClassName(String aClassName) {
        this.referenceClassName = aClassName;
    }

    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.referenceDescriptor = aDescriptor;
    }

    @Override
    public void updateChangeRecord(Object sourceClone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        boolean isNewRecord = false;
        AggregateChangeRecord changeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new AggregateChangeRecord(objectChangeSet);
            changeRecord.setAttribute(this.getAttributeName());
            changeRecord.setMapping(this);
            objectChangeSet.addChange(changeRecord);
            isNewRecord = true;
        }
        if (sourceClone.getClass().equals(objectChangeSet.getClassType(uow))) {
            if (isNewRecord) {
                changeRecord.setOldValue(oldValue);
            }
            ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(newValue, (AbstractSession)uow);
            if (newValue == null) {
                changeRecord.setChangedObject(null);
                if (referenceDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && ((ChangeTracker)oldValue)._persistence_getPropertyChangeListener() != null) {
                    ((AggregateAttributeChangeListener)((ChangeTracker)oldValue)._persistence_getPropertyChangeListener()).setParentListener(null);
                }
                return;
            }
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet();
            ObjectChangeSet aggregateChangeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(newValue);
            if (aggregateChangeSet != null) {
                aggregateChangeSet.clear(true);
            }
            if (referenceDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                AggregateAttributeChangeListener newListener;
                if (oldValue != null && ((ChangeTracker)oldValue)._persistence_getPropertyChangeListener() != null) {
                    ((AggregateAttributeChangeListener)((ChangeTracker)oldValue)._persistence_getPropertyChangeListener()).setParentListener(null);
                }
                if ((newListener = (AggregateAttributeChangeListener)((ChangeTracker)newValue)._persistence_getPropertyChangeListener()) == null) {
                    newListener = new AggregateAttributeChangeListener(referenceDescriptor, uow, (AttributeChangeListener)((ChangeTracker)sourceClone)._persistence_getPropertyChangeListener(), this.getAttributeName(), newValue);
                    ((ChangeTracker)newValue)._persistence_setPropertyChangeListener(newListener);
                }
                newListener.setParentListener((AttributeChangeListener)((ChangeTracker)sourceClone)._persistence_getPropertyChangeListener());
                if (changeRecord.getChangedObject() != null && changeRecord.getChangedObject().hasChanges()) {
                    oldValue = changeRecord.getOldValue();
                }
                if (oldValue != null && referenceDescriptor != this.getReferenceDescriptor(oldValue, (AbstractSession)uow)) {
                    oldValue = null;
                }
            }
            changeRecord.setChangedObject(referenceDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(newValue, oldValue, uowChangeSet, oldValue == null, uow, referenceDescriptor));
            for (DatabaseMapping mapping : referenceDescriptor.getMappings()) {
                if (!mapping.isAggregateObjectMapping()) continue;
                Object nestedNewValue = mapping.getAttributeValueFromObject(newValue);
                Object nestedOldValue = null;
                if (oldValue != null) {
                    nestedOldValue = mapping.getAttributeValueFromObject(oldValue);
                }
                mapping.updateChangeRecord(newValue, nestedNewValue, nestedOldValue, (ObjectChangeSet)changeRecord.getChangedObject(), uow);
            }
            referenceDescriptor.getObjectChangePolicy().setChangeSetOnListener((ObjectChangeSet)changeRecord.getChangedObject(), newValue);
        } else if (this.referenceDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            changeRecord.setChangedObject(((AggregateAttributeChangeListener)((ChangeTracker)sourceClone)._persistence_getPropertyChangeListener()).getObjectChangeSet());
        } else {
            changeRecord.setChangedObject(this.referenceDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(sourceClone, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), true, uow, this.referenceDescriptor));
        }
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        return this.verifyDeleteOfAttributeValue(this.getAttributeValueFromObject(object), session);
    }

    protected boolean verifyDeleteOfAttributeValue(Object attributeValue, AbstractSession session) throws DatabaseException {
        if (attributeValue == null) {
            return true;
        }
        Enumeration<DatabaseMapping> mappings = this.getReferenceDescriptor(attributeValue, session).getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (mapping.verifyDelete(attributeValue, session)) continue;
            return false;
        }
        return true;
    }
}

