/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Attribute;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Descriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkTemplate;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Parameter;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Query;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.SessionBeanCall;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceFactoryBase;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class ServiceBase {
    public static final String RELATIONSHIP_PARTNER = "partner";
    protected PersistenceFactoryBase factory;

    public PersistenceFactoryBase getPersistenceFactory() {
        if (this.factory == null) {
            this.factory = new PersistenceFactoryBase();
        }
        return this.factory;
    }

    @GET
    public Response getContexts(@Context HttpHeaders hh, @Context UriInfo uriInfo) throws JAXBException {
        return this.getContexts(hh, uriInfo.getBaseUri());
    }

    public Response getContexts(HttpHeaders hh, URI baseURI) throws JAXBException {
        Set<String> contexts = this.getPersistenceFactory().getPersistenceContextNames();
        Iterator<String> contextIterator = contexts.iterator();
        ArrayList<Link> links = new ArrayList<Link>();
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        while (contextIterator.hasNext()) {
            String context = contextIterator.next();
            links.add(new Link(context, mediaType, baseURI + context + "/metadata\""));
        }
        String result = null;
        result = this.marshallMetadata(links, mediaType);
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @POST
    @Produces(value={"*/*"})
    public Response callSessionBean(@Context HttpHeaders hh, @Context UriInfo ui, @Context UriInfo uriInfo, InputStream is) throws JAXBException, ClassNotFoundException, NamingException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.callSessionBean(hh, ui, ui.getBaseUri(), is);
    }

    public Response callSessionBean(HttpHeaders hh, UriInfo ui, URI baseURI, InputStream is) throws JAXBException, ClassNotFoundException, NamingException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        SessionBeanCall call = null;
        InitialContext ctx = new InitialContext();
        call = this.unmarshallSessionBeanCall(is);
        String jndiName = call.getJndiName();
        Object ans = ctx.lookup(jndiName);
        if (ans == null) {
            JPARSLogger.fine("jpars_could_not_find_session_bean", new Object[]{jndiName});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PersistenceContext context = null;
        if (call.getContext() != null && (context = this.getPersistenceFactory().get(call.getContext(), baseURI, null)) == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{call.getContext()});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Class[] parameters = new Class[call.getParameters().size()];
        Object[] args = new Object[call.getParameters().size()];
        int i = 0;
        for (Parameter param : call.getParameters()) {
            Class<?> parameterClass = null;
            Object parameterValue = null;
            if (context != null) {
                parameterClass = context.getClass(param.getTypeName());
            }
            if (parameterClass != null) {
                parameterValue = context.unmarshalEntity(param.getTypeName(), hh.getMediaType(), is);
            } else {
                parameterClass = Thread.currentThread().getContextClassLoader().loadClass(param.getTypeName());
                parameterValue = ConversionManager.getDefaultManager().convertObject((Object)param.getValue(), parameterClass);
            }
            parameters[i] = parameterClass;
            args[i] = parameterValue;
            ++i;
        }
        Method method = ans.getClass().getMethod(call.getMethodName(), parameters);
        Object returnValue = method.invoke(ans, args);
        return Response.ok((Object)new StreamingOutputMarshaller(null, returnValue, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/metadata")
    public Response getTypes(@PathParam(value="context") String persistenceUnit, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getTypes(persistenceUnit, hh, uriInfo.getBaseUri());
    }

    public Response getTypes(String persistenceUnit, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PersistenceUnit pu = new PersistenceUnit();
        pu.setPersistenceUnitName(persistenceUnit);
        Map descriptors = app.getJpaSession().getDescriptors();
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        Iterator contextIterator = descriptors.keySet().iterator();
        while (contextIterator.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(contextIterator.next());
            pu.getTypes().add(new Link(descriptor.getAlias(), mediaType, baseURI + persistenceUnit + "/metadata/entity/" + descriptor.getAlias()));
        }
        String result = null;
        try {
            result = this.marshallMetadata(pu, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_persitence_unit", new Object[]{persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes()));
        rb.header("Content-Type", (Object)"application/json");
        return rb.build();
    }

    @GET
    @Path(value="{context}/metadata/entity/{descriptorAlias}")
    public Response getDescriptorMetadata(@PathParam(value="context") String persistenceUnit, @PathParam(value="descriptorAlias") String descriptorAlias, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getDescriptorMetadata(persistenceUnit, descriptorAlias, hh, uriInfo.getBaseUri());
    }

    public Response getDescriptorMetadata(String persistenceUnit, String descriptorAlias, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ClassDescriptor descriptor = app.getJpaSession().getDescriptorForAlias(descriptorAlias);
        if (descriptor == null) {
            JPARSLogger.fine("jpars_could_not_find_entity_type", new Object[]{descriptorAlias, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        Descriptor returnDescriptor = this.buildDescriptor(app, persistenceUnit, descriptor, baseURI.toString());
        String result = null;
        try {
            result = this.marshallMetadata(returnDescriptor, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_entity_metadata", new Object[]{descriptorAlias, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/metadata/query/")
    public Response getQueriesMetadata(@PathParam(value="context") String persistenceUnit, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getQueriesMetadata(persistenceUnit, hh, uriInfo.getBaseUri());
    }

    public Response getQueriesMetadata(String persistenceUnit, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        this.addQueries(queries, app, null);
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        String result = null;
        try {
            result = this.marshallMetadata(queries, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_query_metadata", new Object[]{persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/metadata/query/{queryName}")
    public Response getQueryMetadata(@PathParam(value="context") String persistenceUnit, @PathParam(value="queryName") String queryName, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getQueryMetadata(persistenceUnit, queryName, hh, uriInfo.getBaseUri());
    }

    public Response getQueryMetadata(String persistenceUnit, String queryName, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Query> returnQueries = new ArrayList<Query>();
        Map queries = app.getJpaSession().getQueries();
        if (queries.get(queryName) != null) {
            for (DatabaseQuery query : (List)queries.get(queryName)) {
                returnQueries.add(this.getQuery(query, app));
            }
        }
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        String result = null;
        try {
            result = this.marshallMetadata(returnQueries, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_individual_query_metadata", new Object[]{queryName, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/entity/{type}/{key}")
    public Response find(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.find(persistenceUnit, type, key, hh, ui, ui.getBaseUri());
    }

    public Response find(String persistenceUnit, String type, String key, HttpHeaders hh, UriInfo ui, URI baseURI) {
        Object id;
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = ServiceBase.getParameterMap(ui, persistenceUnit);
        Object entity = app.find(discriminators, type, id = IdHelper.buildId(app, type, key, discriminators), ServiceBase.getHintMap(ui));
        if (entity == null) {
            JPARSLogger.fine("jpars_could_not_entity_for_key", new Object[]{type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/entity/{type}/{key}/{attribute}")
    public Response findAttribute(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.findAttribute(persistenceUnit, type, key, attribute, hh, ui, ui.getBaseUri());
    }

    public Response findAttribute(String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI) {
        Object id;
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = ServiceBase.getParameterMap(ui, persistenceUnit);
        Object entity = app.findAttribute(discriminators, type, id = IdHelper.buildId(app, type, key, discriminators), ServiceBase.getHintMap(ui), attribute);
        if (entity == null) {
            JPARSLogger.fine("jpars_could_not_entity_for_attribute", new Object[]{type, key, attribute, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @POST
    @Path(value="{context}/entity/{type}/{key}/{attribute}")
    public Response setOrAddAttribute(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui, InputStream in) {
        return this.setOrAddAttribute(persistenceUnit, type, key, attribute, hh, ui, ui.getBaseUri(), in);
    }

    public Response setOrAddAttribute(String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = ServiceBase.getParameterMap(ui, persistenceUnit);
        Object id = IdHelper.buildId(app, type, key, discriminators);
        Object entity = null;
        String partner = ServiceBase.getParameterMap(ui, attribute).get(RELATIONSHIP_PARTNER);
        try {
            ClassDescriptor descriptor = app.getDescriptor(type);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (!mapping.isForeignReferenceMapping()) {
                JPARSLogger.fine("jpars_could_find_appropriate_mapping_for_update", new Object[]{attribute, type, key, persistenceUnit});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            entity = app.unmarshalEntity(((ForeignReferenceMapping)mapping).getReferenceDescriptor().getAlias(), StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ConversionException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Object result = app.updateOrAddAttribute(ServiceBase.getParameterMap(ui, persistenceUnit), type, id, ServiceBase.getHintMap(ui), attribute, entity, partner);
        if (result == null) {
            JPARSLogger.fine("jpars_could_not_update_attribute", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    @DELETE
    @Path(value="{context}/entity/{type}/{key}/{attribute}")
    public Response removeAttribute(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui, InputStream in) {
        return this.removeAttribute(persistenceUnit, type, key, attribute, hh, ui, ui.getBaseUri(), in);
    }

    public Response removeAttribute(String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = ServiceBase.getParameterMap(ui, persistenceUnit);
        Object id = IdHelper.buildId(app, type, key, discriminators);
        Object entity = null;
        String partner = ServiceBase.getParameterMap(ui, attribute).get(RELATIONSHIP_PARTNER);
        try {
            ClassDescriptor descriptor = app.getDescriptor(type);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (!mapping.isForeignReferenceMapping()) {
                JPARSLogger.fine("jpars_could_find_appropriate_mapping_for_update", new Object[]{attribute, type, key, persistenceUnit});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            entity = app.unmarshalEntity(((ForeignReferenceMapping)mapping).getReferenceDescriptor().getAlias(), StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ConversionException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Object result = app.removeAttribute(ServiceBase.getParameterMap(ui, persistenceUnit), type, id, ServiceBase.getHintMap(ui), attribute, entity, partner);
        if (result == null) {
            JPARSLogger.fine("jpars_could_not_update_attribute", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    @PUT
    @Path(value="{context}/entity/{type}")
    public Response create(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) throws JAXBException {
        return this.create(persistenceUnit, type, hh, uriInfo, uriInfo.getBaseUri(), in);
    }

    public Response create(String persistenceUnit, String type, HttpHeaders hh, UriInfo uriInfo, URI baseURI, InputStream in) throws JAXBException {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ClassDescriptor descriptor = app.getDescriptor(type);
        if (descriptor == null) {
            JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ConversionException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        AbstractDirectMapping sequenceMapping = descriptor.getObjectBuilder().getSequenceMapping();
        if (sequenceMapping != null) {
            Object value = sequenceMapping.getAttributeAccessor().getAttributeValueFromObject(entity);
            if (descriptor.getObjectBuilder().isPrimaryKeyComponentInvalid(value, descriptor.getPrimaryKeyFields().indexOf(descriptor.getSequenceNumberField())) || descriptor.getSequence().shouldAlwaysOverrideExistingValue()) {
                JPARSLogger.fine("jpars_put_not_itempotent", new Object[]{type, persistenceUnit});
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        app.create(ServiceBase.getParameterMap(uriInfo, persistenceUnit), entity);
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.CREATED);
        rb.entity((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes()));
        return rb.build();
    }

    @POST
    @Path(value="{context}/entity/{type}")
    public Response update(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) {
        return this.update(persistenceUnit, type, hh, uriInfo, uriInfo.getBaseUri(), in);
    }

    public Response update(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        MediaType contentType = StreamingOutputMarshaller.mediaType(hh.getRequestHeader("Content-Type"));
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, contentType, in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ConversionException e) {
            JPARSLogger.fine("exception_while_ummarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        entity = app.merge(ServiceBase.getParameterMap(uriInfo, persistenceUnit), entity);
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @DELETE
    @Path(value="{context}/entity/{type}/{key}")
    public Response delete(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.delete(persistenceUnit, type, key, hh, ui, ui.getBaseUri());
    }

    public Response delete(String persistenceUnit, String type, String key, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = ServiceBase.getParameterMap(ui, persistenceUnit);
        Object id = IdHelper.buildId(app, type, key, discriminators);
        app.delete(discriminators, type, id);
        return Response.ok().build();
    }

    @GET
    @Path(value="{context}/query/{name}")
    public Response namedQuery(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQuery(persistenceUnit, name, hh, ui, ui.getBaseUri());
    }

    public Response namedQuery(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.query(ServiceBase.getParameterMap(ui, persistenceUnit), name, ServiceBase.getParameterMap(ui, name), ServiceBase.getHintMap(ui), false, false);
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    @POST
    @Path(value="{context}/query/{name}")
    @Produces(value={"application/octet-stream"})
    public Response namedQueryUpdate(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQueryUpdate(persistenceUnit, name, hh, ui, ui.getBaseUri());
    }

    public Response namedQueryUpdate(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.query(ServiceBase.getParameterMap(ui, persistenceUnit), name, ServiceBase.getParameterMap(ui, name), ServiceBase.getHintMap(ui), false, true);
        return Response.ok((Object)new StreamingOutputMarshaller(app, (Object)result.toString(), hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/singleResultQuery/{name}")
    @Produces(value={"*/*"})
    public Response namedQuerySingleResult(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQuerySingleResult(persistenceUnit, name, hh, ui, ui.getBaseUri());
    }

    public Response namedQuerySingleResult(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.query(ServiceBase.getParameterMap(ui, persistenceUnit), name, ServiceBase.getParameterMap(ui, name), ServiceBase.getHintMap(ui), true, false);
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    protected Descriptor buildDescriptor(PersistenceContext app, String persistenceUnit, ClassDescriptor descriptor, String baseUri) {
        Descriptor returnDescriptor = new Descriptor();
        returnDescriptor.setName(descriptor.getAlias());
        returnDescriptor.setType(descriptor.getJavaClassName());
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("find", "get", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("persist", "put", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias()));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("update", "post", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias()));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("delete", "delete", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        if (!descriptor.getMappings().isEmpty()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                this.addMapping(returnDescriptor, mapping);
            }
        }
        this.addQueries(returnDescriptor.getQueries(), app, descriptor.getJavaClassName());
        return returnDescriptor;
    }

    protected void addMapping(Descriptor descriptor, DatabaseMapping mapping) {
        String target = null;
        if (mapping.isCollectionMapping()) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            String collectionType = collectionMapping.getContainerPolicy().getContainerClassName();
            if (collectionMapping.getContainerPolicy().isMapPolicy()) {
                String mapKeyType = ((MapContainerPolicy)collectionMapping.getContainerPolicy()).getKeyType().toString();
                target = String.valueOf(collectionType) + "<" + mapKeyType + ", " + collectionMapping.getReferenceClassName() + ">";
            } else {
                target = String.valueOf(collectionType) + "<" + collectionMapping.getReferenceClassName() + ">";
            }
        } else {
            target = mapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)mapping).getReferenceClass().getName() : mapping.getAttributeClassification().getName();
        }
        descriptor.getAttributes().add(new Attribute(mapping.getAttributeName(), target));
    }

    protected void addQueries(List<Query> queryList, PersistenceContext app, String javaClassName) {
        Map queries = app.getJpaSession().getQueries();
        ArrayList<DatabaseQuery> returnQueries = new ArrayList<DatabaseQuery>();
        for (String key : queries.keySet()) {
            List keyQueries = (List)queries.get(key);
            for (DatabaseQuery query : keyQueries) {
                if (javaClassName != null && (query.getReferenceClassName() == null || !query.getReferenceClassName().equals(javaClassName))) continue;
                returnQueries.add(query);
            }
        }
        Iterator queryIterator = returnQueries.iterator();
        while (queryIterator.hasNext()) {
            queryList.add(this.getQuery((DatabaseQuery)queryIterator.next(), app));
        }
    }

    protected Query getQuery(DatabaseQuery query, PersistenceContext app) {
        String method = query.isReadQuery() ? "get" : "post";
        String jpql = query.getJPQLString() == null ? "" : query.getJPQLString();
        StringBuffer parameterString = new StringBuffer();
        for (String argument : query.getArguments()) {
            parameterString.append(";");
            parameterString.append(String.valueOf(argument) + "={" + argument + "}");
        }
        Query returnQuery = new Query(query.getName(), jpql, new LinkTemplate("execute", method, app.getBaseURI() + app.getName() + "/query/" + query.getName() + parameterString));
        if (query.isReportQuery()) {
            query.checkPrepare((AbstractSession)app.getJpaSession(), (AbstractRecord)new DatabaseRecord());
            for (ReportItem item : ((ReportQuery)query).getItems()) {
                if (item.getMapping() != null) {
                    if (item.getAttributeExpression() != null && item.getAttributeExpression().isMapEntryExpression()) {
                        if (((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry()) {
                            returnQuery.getReturnTypes().add(Map.Entry.class.getName());
                            continue;
                        }
                        returnQuery.getReturnTypes().add(((Class)((CollectionMapping)item.getMapping()).getContainerPolicy().getKeyType()).getName());
                        continue;
                    }
                    returnQuery.getReturnTypes().add(item.getMapping().getAttributeClassification().getName());
                    continue;
                }
                if (item.getResultType() != null) {
                    returnQuery.getReturnTypes().add(item.getResultType().getName());
                    continue;
                }
                if (item.getDescriptor() != null) {
                    returnQuery.getReturnTypes().add(item.getDescriptor().getJavaClass().getName());
                    continue;
                }
                if (item.getAttributeExpression() != null && item.getAttributeExpression().isConstantExpression()) {
                    returnQuery.getReturnTypes().add(((ConstantExpression)item.getAttributeExpression()).getValue().getClass().getName());
                    continue;
                }
                returnQuery.getReturnTypes().add(ClassConstants.OBJECT.getName());
            }
        } else {
            returnQuery.getReturnTypes().add(query.getReferenceClassName() == null ? "" : query.getReferenceClassName());
        }
        return returnQuery;
    }

    protected static Map<String, Object> getHintMap(UriInfo info) {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        for (String key : info.getQueryParameters().keySet()) {
            hints.put(key, info.getQueryParameters().getFirst((Object)key));
        }
        return hints;
    }

    protected static Map<String, String> getParameterMap(UriInfo info, String segment) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (PathSegment pathSegment : info.getPathSegments()) {
            if (pathSegment.getPath() == null || !pathSegment.getPath().equals(segment)) continue;
            for (Map.Entry entry : pathSegment.getMatrixParameters().entrySet()) {
                parameters.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            return parameters;
        }
        return parameters;
    }

    protected String getSingleHeader(String parameterName, HttpHeaders hh) {
        List params = hh.getRequestHeader(parameterName);
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (params.size() != 1) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return (String)params.get(0);
    }

    protected String marshallMetadata(Object metadata, String mediaType) throws JAXBException {
        Class[] jaxbClasses = new Class[]{Link.class, Attribute.class, Descriptor.class, LinkTemplate.class, PersistenceUnit.class, Query.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBMarshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType);
        StringWriter writer = new StringWriter();
        marshaller.marshal(metadata, (Writer)writer);
        return writer.toString();
    }

    protected SessionBeanCall unmarshallSessionBeanCall(InputStream data) throws JAXBException {
        Class[] jaxbClasses = new Class[]{SessionBeanCall.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBUnmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        StreamSource ss = new StreamSource(data);
        return (SessionBeanCall)unmarshaller.unmarshal((Source)ss, SessionBeanCall.class).getValue();
    }
}

