/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class CursoredStreamClientSessionTest
extends TestCase {
    protected Server serverSession;
    protected ClientSession clientSession;
    protected Exception caughtException;

    public CursoredStreamClientSessionTest() {
        this.setDescription("Verifies if a CursoredStream query execution on a ClientSession correctly throws a DatabaseException");
    }

    public void reset() {
        this.clientSession.release();
        this.serverSession.logout();
    }

    public void setup() {
        EmployeeProject proj = new EmployeeProject();
        proj.setDatasourceLogin(this.getSession().getDatasourceLogin().clone());
        this.serverSession = proj.createServerSession(1, 1);
        this.serverSession.useReadConnectionPool(1, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
        this.clientSession = this.serverSession.acquireClientSession();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.getField("HOOYAH").equal((Object)"Jill");
        query.setSelectionCriteria(exp);
        query.useCursoredStream(1, 1);
        try {
            CursoredStream stream = (CursoredStream)this.clientSession.executeQuery((DatabaseQuery)query);
        }
        catch (Exception e) {
            this.caughtException = e;
        }
    }

    public void verify() {
        if (this.caughtException == null) {
            throw new TestErrorException("The proper exception was not thrown:\ncaught exception was null! \n");
        }
        if (this.caughtException instanceof NullPointerException) {
            throw new TestErrorException("a nullpointer exception was incorrectly thrown");
        }
    }
}

