/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformingTestConfiguration;

public class ScrollableCursorNavigationAPITest
extends TestCase {
    protected boolean useConforming = false;
    ConformingTestConfiguration configuration = null;
    protected String navigationError = null;
    protected Exception caughtException = null;
    protected boolean TYPE_SCROLL_INSENSITIVE_isSupported;
    protected boolean CONCUR_UPDATABLE_isSupported;

    public ScrollableCursorNavigationAPITest() {
        this.setDescription("This test tests various API which is used to navigate scrollable cursors.");
    }

    public ScrollableCursorNavigationAPITest(boolean useConforming) {
        this();
        if (useConforming) {
            this.setName("ScrollableCursorNavigationAPIConformingTest");
            this.useConforming = useConforming;
            this.configuration = new ConformingTestConfiguration();
        }
    }

    protected void setup() {
        if (this.getSession().getPlatform().isDB2() || this.getSession().getPlatform().isAccess() || this.getSession().getPlatform().isTimesTen() || this.getSession().getPlatform().isHANA()) {
            throw new TestWarningException("ScrollableCursor is not supported on this platform");
        }
        if (this.getSession().getPlatform().isMySQL()) {
            throw new TestWarningException("Not supported in MySQL");
        }
        this.TYPE_SCROLL_INSENSITIVE_isSupported = true;
        this.CONCUR_UPDATABLE_isSupported = true;
        if (this.getSession().getPlatform().isSQLServer()) {
            this.TYPE_SCROLL_INSENSITIVE_isSupported = false;
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        if (this.getSession().getPlatform().isSymfoware()) {
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.configuration != null) {
            this.configuration.setup(this.getSession());
            this.getExecutor().setSession((Session)this.configuration.getUnitOfWork());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        if (this.configuration != null) {
            ExpressionBuilder emp = new ExpressionBuilder();
            Expression exp = emp.get("salary").greaterThan(50000);
            query.setSelectionCriteria(exp);
            query.conformResultsInUnitOfWork();
        }
        ScrollableCursor cursor = null;
        try {
            query.setReferenceClass(Employee.class);
            if (this.TYPE_SCROLL_INSENSITIVE_isSupported && this.CONCUR_UPDATABLE_isSupported) {
                query.useScrollableCursor(2);
            } else {
                ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
                if (!this.TYPE_SCROLL_INSENSITIVE_isSupported) {
                    policy.setResultSetType(1005);
                }
                if (!this.CONCUR_UPDATABLE_isSupported) {
                    policy.setResultSetConcurrency(1007);
                }
                policy.setPageSize(2);
                query.useScrollableCursor(policy);
            }
            cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
            try {
                boolean isLast;
                boolean isRelative;
                boolean isFirst = cursor.first();
                if (!cursor.isFirst() || !isFirst) {
                    this.navigationError = "cursor.first() does not result in cursor.isFirst() returning true.";
                }
                Object second = cursor.next();
                Object first = cursor.previous();
                if (first.equals(second)) {
                    this.navigationError = "cursor.next() and cursor.previous() are not complementary.";
                }
                if (!second.equals(cursor.next())) {
                    this.navigationError = "cursor.next() does not move the cursor forward.";
                }
                if (!(isRelative = cursor.relative(1)) || !second.equals(cursor.previous())) {
                    this.navigationError = "cursor.relative() does not move the cursor the proper number of spaces.";
                }
                boolean isAbsolute = cursor.absolute(1);
                if (!second.equals(cursor.next())) {
                    this.navigationError = "cursor.absolute(0) move a cursor to the beginning of the cursor.";
                }
                cursor.beforeFirst();
                if (!cursor.isBeforeFirst()) {
                    this.navigationError = "cursor.beforeFirst() does not result in cursor.isBeforeFirst() returning true.";
                }
                if (!first.equals(cursor.next())) {
                    this.navigationError = "cursor.beforeFirst() does not set the cursor position properly.";
                }
                if (!(isLast = cursor.last()) || !cursor.isLast()) {
                    this.navigationError = "cursor.last() does not result in cursor.isLast() returning true.";
                }
                cursor.afterLast();
                if (!cursor.isAfterLast()) {
                    this.navigationError = "cursor.afterLast() does not result in cursor.isAfterLast() returning true.";
                }
                Object last = cursor.previous();
                int size = cursor.size();
                cursor.relative(size);
                Object lastBySize = cursor.previous();
                if (!last.equals(lastBySize)) {
                    this.navigationError = "The last item in the list is not correct.";
                }
            }
            catch (QueryException ex) {
                this.caughtException = ex;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void reset() {
        if (this.configuration != null) {
            this.getExecutor().setSession((Session)this.configuration.getUnitOfWork().getParent());
            this.configuration.reset();
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void verify() {
        if (this.navigationError != null) {
            throw new TestErrorException("Cursor Navigation produced incorrect results. " + this.navigationError);
        }
        if (this.caughtException != null) {
            throw new TestErrorException("Cursor navigation caused a QueryException.", (Throwable)this.caughtException);
        }
    }
}

