/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.rmi.RMIRemoteSessionController;
import org.eclipse.persistence.sessions.remote.rmi.RMIRemoteSessionControllerDispatcher;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.remote.RMIServerManager;

public class RMIServerManagerController
extends UnicastRemoteObject
implements RMIServerManager {
    protected Session session;
    protected String controllerClassName;

    public RMIServerManagerController(Session session) throws RemoteException {
        this.session = session;
    }

    public RMIServerManagerController(Session session, String controllerClassName) throws RemoteException {
        this(session);
        this.controllerClassName = controllerClassName;
    }

    @Override
    public RMIRemoteSessionController createRemoteSessionController() {
        RMIRemoteSessionControllerDispatcher controller;
        block7: {
            controller = null;
            if (this.controllerClassName == null) {
                try {
                    if (this.getSession().isServerSession()) {
                        controller = new RMIRemoteSessionControllerDispatcher((AbstractSession)((ServerSession)this.getSession()).acquireClientSession());
                        break block7;
                    }
                    controller = new RMIRemoteSessionControllerDispatcher(this.getSession());
                }
                catch (RemoteException exception) {
                    System.out.println("Error in invocation " + exception.toString());
                }
            } else {
                try {
                    Class<?> cls = Class.forName(this.controllerClassName);
                    Class[] parameterTypes = new Class[]{Session.class};
                    Constructor<?> constructor = cls.getConstructor(parameterTypes);
                    Object[] params = new Object[]{this.getSession()};
                    controller = (RMIRemoteSessionController)constructor.newInstance(params);
                }
                catch (Exception exception) {
                    System.out.println("Error instantiating  " + this.controllerClassName + " " + exception.toString());
                }
            }
        }
        return controller;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public static void start(Session session) {
        RMIServerManagerController.start(session, "SERVER-MANAGER");
    }

    public static void start(Session session, String nameToBind) {
        RMIServerManagerController.start(session, nameToBind, null);
    }

    public static void start(Session session, String nameToBind, String controllerClassName) {
        RMIServerManagerController manager = null;
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            manager = new RMIServerManagerController(session, controllerClassName);
        }
        catch (RemoteException exception) {
            throw new TestProblemException(exception.toString());
        }
        try {
            Naming.unbind(nameToBind);
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            Naming.rebind(nameToBind, manager);
        }
        catch (Exception exception) {
            throw new TestProblemException(exception.toString());
        }
    }
}

