/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.CMP3TestModel;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMPersistAndFlushTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    public Integer[] projIDs = new Integer[3];
    public ArrayList phones = new ArrayList(2);
    public HashMap persistedItems = new HashMap(4);

    public EMPersistAndFlushTest() {
        this.setDescription("Test persist and flush in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        if (CMP3TestModel.getServerSession().getDescriptor(Employee.class).getSequence().shouldAcquireValueAfterInsert() || CMP3TestModel.getServerSession().getDescriptor(Project.class).getSequence().shouldAcquireValueAfterInsert()) {
            throw new TestWarningException("Can't run this test with Sybase-type native sequencing for Employee or/and Project");
        }
    }

    public void test() throws Exception {
        Employee employee = ModelExamples.employeeExample1();
        Project project = ModelExamples.projectExample1();
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)employee);
            this.empIDs[0] = employee.getId();
            this.persistedItems.put("after persist Employee", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            this.getEntityManager().persist((Object)project);
            this.projIDs[0] = project.getId();
            this.persistedItems.put("after persist Project", this.getEntityManager().find(Project.class, (Object)this.projIDs[0]));
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.getEntityManager().clear();
            this.persistedItems.put("after flush Employee", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            this.persistedItems.put("after flush Project", this.getEntityManager().find(Project.class, (Object)this.projIDs[0]));
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            throw exception;
        }
    }

    public void verify() {
        if (this.persistedItems.get("after persist Employee") == null) {
            throw new TestErrorException("Find after persist Employee: " + this.empIDs[0] + " is not found in the cache");
        }
        if (this.persistedItems.get("after persist Project") == null) {
            throw new TestErrorException("Find after persist Project: " + this.projIDs[0] + " is not found in the cache");
        }
        if (this.persistedItems.get("after flush Employee") == null) {
            throw new TestErrorException("Find after flush Employee: " + this.empIDs[0] + " is not persisted");
        }
        if (this.persistedItems.get("after flush Project") == null) {
            throw new TestErrorException("Find after flush Project: " + this.projIDs[0] + " is not persisted");
        }
    }
}

