/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.extensibility;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.coordination.MetadataRefreshCommand;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.extensibility.Address;
import org.eclipse.persistence.testing.models.jpa.extensibility.Employee;
import org.eclipse.persistence.testing.models.jpa.extensibility.ExtensibilityTableCreator;
import org.eclipse.persistence.testing.models.jpa.extensibility.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.advanced.MetadataCachingTestSuite;

public class ExtensibilityTests
extends JUnitTestCase {
    public ExtensibilityTests() {
    }

    public ExtensibilityTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExtensibilityTestSuite");
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new ExtensibilityTests("testSetup"));
            suite.addTest((Test)new ExtensibilityTests("testDescriptors"));
            suite.addTest((Test)new ExtensibilityTests("testBasicMapping"));
            suite.addTest((Test)new ExtensibilityTests("testOneToManyMapping"));
            suite.addTest((Test)new ExtensibilityTests("testSimpleRefresh"));
            suite.addTest((Test)new ExtensibilityTests("testMergeRefreshed"));
            suite.addTest((Test)new ExtensibilityTests("testMergeRefreshedManyToMany"));
            suite.addTest((Test)new ExtensibilityTests("testUntriggerVHOnDetached"));
            suite.addTest((Test)new ExtensibilityTests("testFetchGroupOnRefresh"));
            suite.addTest((Test)new ExtensibilityTests("testExistingEntityManagerAfterRefresh"));
            suite.addTest((Test)new ExtensibilityTests("testSetupImplRefresh"));
            suite.addTest((Test)new ExtensibilityTests("testRCMRefreshCommand"));
            suite.addTest((Test)new ExtensibilityTests("testMetadatasourceProperties"));
        }
        return suite;
    }

    public String getPersistenceUnitName() {
        return "extensibility";
    }

    public void testWriteProjectCache() {
        new MetadataCachingTestSuite().testFileBasedProjectCacheLoading("extensibility");
    }

    public void persistEmployeeData(EntityManager em) {
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Joe");
        emp.setLastName("Josephson");
        Address add = new Address();
        add.setStreet("Main Street");
        add.setCity("Herestowm");
        add.setPostalCode("A1A1A1");
        add.setCountry("Here");
        emp.setAddress(add);
        em.persist((Object)emp);
        em.persist((Object)add);
        this.commitTransaction(em);
    }

    public void deleteEmployeeData(EntityManager em) {
        this.beginTransaction(em);
        em.createNativeQuery("UPDATE EXTENS_EMP SET ADDRESS_ID = NULL").executeUpdate();
        em.createNativeQuery("DELETE FROM EXTENS_JOIN_TABLE").executeUpdate();
        em.createNativeQuery("DELETE FROM EXTENS_EMP").executeUpdate();
        em.createNativeQuery("DELETE FROM EXTENS_ADDR").executeUpdate();
        em.createNativeQuery("DELETE FROM EXTENS_PHONE").executeUpdate();
        this.commitTransaction(em);
    }

    public void testSetup() {
        ServerSession serverSession = ExtensibilityTests.getServerSession((String)this.getPersistenceUnitName());
        new ExtensibilityTableCreator().replaceTables((DatabaseSession)serverSession);
        if (serverSession.getPlatform().isPostgreSQL()) {
            serverSession.getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    public void testDescriptors() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        ServerSession session = (ServerSession)this.getDatabaseSession();
        RelationalDescriptor empDescriptor = (RelationalDescriptor)session.getProject().getDescriptor(Employee.class);
        ExtensibilityTests.assertTrue((empDescriptor.getMappingForAttributeName("phoneNumbers") != null ? 1 : 0) != 0);
        if (this.isWeavingEnabled()) {
            ExtensibilityTests.assertTrue((boolean)empDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
        }
        ExtensibilityTests.assertTrue((empDescriptor.getVirtualAttributeMethods() != null ? 1 : 0) != 0);
        ExtensibilityTests.assertTrue((empDescriptor.getVirtualAttributeMethods().size() == 1 ? 1 : 0) != 0);
        VirtualAttributeMethodInfo info = (VirtualAttributeMethodInfo)empDescriptor.getVirtualAttributeMethods().get(0);
        ExtensibilityTests.assertTrue((boolean)info.getGetMethodName().equals("getExt"));
        ExtensibilityTests.assertTrue((boolean)info.getSetMethodName().equals("putExt"));
        RelationalDescriptor addDescriptor = (RelationalDescriptor)session.getProject().getDescriptor(Address.class);
        ExtensibilityTests.assertTrue((addDescriptor.getMappingForAttributeName("pobox") != null ? 1 : 0) != 0);
        if (this.isWeavingEnabled()) {
            ExtensibilityTests.assertTrue((boolean)addDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
        }
        ExtensibilityTests.assertTrue((addDescriptor.getVirtualAttributeMethods() != null ? 1 : 0) != 0);
        ExtensibilityTests.assertTrue((addDescriptor.getVirtualAttributeMethods().size() == 1 ? 1 : 0) != 0);
        info = (VirtualAttributeMethodInfo)addDescriptor.getVirtualAttributeMethods().get(0);
        ExtensibilityTests.assertTrue((boolean)info.getGetMethodName().equals("get"));
        ExtensibilityTests.assertTrue((boolean)info.getSetMethodName().equals("set"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicMapping() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("eclipselink.session-name", "bla1");
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        em.clear();
        this.clearCache();
        try {
            this.beginTransaction(em);
            Employee emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e where e.firstName = 'Joe'").getSingleResult();
            Address add = emp.getAddress();
            add.set("pobox", (Object)"111");
            this.commitTransaction(em);
            em.refresh((Object)emp);
            ExtensibilityTests.assertTrue((String)"The pobox was not properly saved", (boolean)emp.getAddress().get("pobox").equals("111"));
            em.clear();
            this.clearCache();
            add = (Address)em.createQuery("select a from ExtensibilityAddress a where a.pobox = '111'").getSingleResult();
            ExtensibilityTests.assertTrue((String)"queries on extended Basic mappings fail", (add != null ? 1 : 0) != 0);
            ExtensibilityTests.assertTrue((String)"queries on extended Basic mappings return incorrect results.", (boolean)add.get("pobox").equals("111"));
        }
        finally {
            this.deleteEmployeeData(em);
            em.close();
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToManyMapping() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        em.clear();
        this.clearCache();
        PhoneNumber pn = new PhoneNumber();
        Employee emp = null;
        try {
            this.beginTransaction(em);
            emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e where e.firstName = 'Joe'").getSingleResult();
            pn.setAreaCode("613");
            pn.setNumber("1111111");
            em.persist((Object)pn);
            List numbers = new ArrayList<PhoneNumber>();
            numbers.add(pn);
            emp.putExt("phoneNumbers", numbers);
            this.commitTransaction(em);
            em.refresh((Object)emp);
            numbers = (List)emp.getExt("phoneNumbers");
            ExtensibilityTests.assertTrue((String)"The phoneNumbers were not properly saved", (numbers.size() == 1 ? 1 : 0) != 0);
            em.clear();
            this.clearCache();
            emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e join e.phoneNumbers p where p.areaCode = '613'").getSingleResult();
            ExtensibilityTests.assertTrue((String)"queries on extended OneToMany mappings fail", (emp != null ? 1 : 0) != 0);
            ExtensibilityTests.assertTrue((String)"queries on extended OneToMany mappings return incorrect results.", (((List)emp.getExt("phoneNumbers")).size() == 1 ? 1 : 0) != 0);
        }
        finally {
            try {
                this.deleteEmployeeData(em);
                em.close();
                this.clearCache();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void testSimpleRefresh() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        WeakReference<EntityManagerFactoryDelegate> emfRef = new WeakReference<EntityManagerFactoryDelegate>(((EntityManagerFactoryImpl)JpaHelper.getEntityManagerFactory((EntityManager)em)).unwrap());
        ServerSession session = (ServerSession)this.getDatabaseSession();
        RelationalDescriptor addDescriptor = (RelationalDescriptor)session.getProject().getDescriptor(Address.class);
        ExtensibilityTests.assertTrue((addDescriptor.getMappingForAttributeName("pobox") != null ? 1 : 0) != 0);
        RelationalDescriptor empDescriptor = (RelationalDescriptor)session.getProject().getDescriptor(Employee.class);
        ExtensibilityTests.assertTrue((empDescriptor.getMappingForAttributeName("phoneNumbers") != null ? 1 : 0) != 0);
        session = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.metadata-source.xml.file", "extension2.xml");
        JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
        session = (ServerSession)this.getDatabaseSession();
        addDescriptor = (RelationalDescriptor)session.getProject().getDescriptor(Address.class);
        ExtensibilityTests.assertTrue((addDescriptor.getMappingForAttributeName("pobox") == null ? 1 : 0) != 0);
        ExtensibilityTests.assertTrue((addDescriptor.getMappingForAttributeName("appartmentNumber") != null ? 1 : 0) != 0);
        empDescriptor = (RelationalDescriptor)session.getProject().getDescriptor(Employee.class);
        ExtensibilityTests.assertTrue((empDescriptor.getMappingForAttributeName("phoneNumbers") == null ? 1 : 0) != 0);
        em = emf.createEntityManager();
        try {
            this.persistEmployeeData(em);
            em.clear();
            this.clearCache();
            this.beginTransaction(em);
            Employee emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e where e.firstName = 'Joe'").getSingleResult();
            emp.getAddress().set("appartmentNumber", (Object)"111");
            this.commitTransaction(em);
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            ExtensibilityTests.assertTrue((boolean)emp.getAddress().get("appartmentNumber").equals("111"));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.deleteEmployeeData(em);
            this.clearCache();
        }
        em.close();
        System.gc();
        ExtensibilityTests.assertTrue((emfRef.get() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeRefreshed() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        em.clear();
        this.clearCache();
        try {
            this.beginTransaction(em);
            Employee emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e where e.firstName = 'Joe'").getSingleResult();
            Address add = emp.getAddress();
            emp.getAddress().set("appartmentNumber", (Object)"112");
            this.commitTransaction(em);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.metadata-source.xml.file", "extension.xml");
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
            em.close();
            em = emf.createEntityManager();
            this.beginTransaction(em);
            add = (Address)em.merge((Object)add);
            add.set("pobox", (Object)"111");
            this.commitTransaction(em);
            em.refresh((Object)add);
            ExtensibilityTests.assertTrue((boolean)add.get("pobox").equals("111"));
            ExtensibilityTests.assertTrue((add.get("appartmentNumber") == null ? 1 : 0) != 0);
        }
        finally {
            this.deleteEmployeeData(em);
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeRefreshedManyToMany() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        em.clear();
        this.clearCache();
        Employee emp = null;
        PhoneNumber pn = null;
        try {
            this.beginTransaction(em);
            emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e where e.firstName = 'Joe'").getSingleResult();
            pn = new PhoneNumber();
            pn.setAreaCode("613");
            pn.setNumber("1111111");
            em.persist((Object)pn);
            ArrayList<PhoneNumber> numbers = new ArrayList<PhoneNumber>();
            numbers.add(pn);
            emp.putExt("phoneNumbers", numbers);
            this.commitTransaction(em);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.metadata-source.xml.file", "extension2.xml");
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
            em.close();
            em = emf.createEntityManager();
            emp = (Employee)em.merge((Object)emp);
            ExtensibilityTests.assertNull((Object)emp.getExt("phoneNumbers"));
        }
        finally {
            this.deleteEmployeeData(em);
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUntriggerVHOnDetached() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        this.clearCache();
        em.clear();
        Employee emp = (Employee)em.createQuery("select e from ExtensibilityEmployee e where e.firstName = 'Joe'").getSingleResult();
        try {
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(null);
            ExtensibilityTests.assertTrue((boolean)emp.getAddress().getCity().equals("Herestowm"));
            em.close();
            em = null;
            emp = null;
        }
        finally {
            em = emf.createEntityManager();
            this.deleteEmployeeData(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnRefresh() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        this.clearCache();
        em.clear();
        Address add = null;
        try {
            FetchGroup fetch = new FetchGroup();
            fetch.addAttribute("id");
            fetch.addAttribute("city");
            fetch.addAttribute("appartmentNumber");
            add = (Address)em.createQuery("select a from ExtensibilityAddress a where a.city = 'Herestowm'").setHint("eclipselink.fetch-group", (Object)fetch).getSingleResult();
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(null);
            System.gc();
            ExtensibilityTests.assertTrue((boolean)add.getCity().equals("Herestowm"));
            ExtensibilityTests.assertTrue((add.get("appartmentNumber") == null ? 1 : 0) != 0);
            ExtensibilityTests.assertTrue((boolean)add.getStreet().equals("Main Street"));
        }
        finally {
            em = emf.createEntityManager();
            this.deleteEmployeeData(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExistingEntityManagerAfterRefresh() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.metadata-source.xml.file", "extension2.xml");
        JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
        em.close();
        em = emf.createEntityManager();
        this.persistEmployeeData(em);
        this.clearCache();
        em.clear();
        Address add = (Address)em.createQuery("select a from ExtensibilityAddress a where a.city = 'Herestowm'").getSingleResult();
        em.find(Address.class, (Object)add.getId());
        try {
            properties.put("eclipselink.metadata-source.xml.file", "extension.xml");
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
            EntityManager em2 = emf.createEntityManager();
            this.beginTransaction(em);
            add.set("appartmentNumber", (Object)"333");
            em.flush();
            this.clearCache();
            em.clear();
            add = (Address)em.find(Address.class, (Object)add.getId());
            ExtensibilityTests.assertTrue((boolean)add.get("appartmentNumber").equals("333"));
            this.rollbackTransaction(em);
            this.clearCache();
            this.beginTransaction(em2);
            add = (Address)em2.find(Address.class, (Object)add.getId());
            add.set("pobox", (Object)"1");
            this.commitTransaction(em2);
            this.clearCache();
            em.clear();
            add = (Address)em2.find(Address.class, (Object)add.getId());
            ExtensibilityTests.assertTrue((boolean)add.get("pobox").equals("1"));
        }
        finally {
            em = emf.createEntityManager();
            this.deleteEmployeeData(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetupImplRefresh() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        this.clearCache();
        em.clear();
        try {
            EntityManagerFactoryDelegate delegate = (EntityManagerFactoryDelegate)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).getEntityManagerFactory();
            EntityManagerSetupImpl setupImpl = (EntityManagerSetupImpl)EntityManagerFactoryProvider.emSetupImpls.get(delegate.getSetupImpl().getSessionName());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(delegate.getProperties());
            properties.put("eclipselink.metadata-source.xml.file", "extension2.xml");
            setupImpl.refreshMetadata(properties);
            em = emf.createEntityManager();
            this.beginTransaction(em);
            Address add = (Address)em.createQuery("select a from ExtensibilityAddress a where a.city = 'Herestowm'").getSingleResult();
            add.set("appartmentNumber", (Object)"444");
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            add = (Address)em.find(Address.class, (Object)add.getId());
            ExtensibilityTests.assertTrue((boolean)add.get("appartmentNumber").equals("444"));
        }
        finally {
            em = emf.createEntityManager();
            this.deleteEmployeeData(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRCMRefreshCommand() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        this.persistEmployeeData(em);
        this.clearCache();
        em.clear();
        try {
            EntityManagerFactoryDelegate delegate = (EntityManagerFactoryDelegate)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).getEntityManagerFactory();
            EntityManagerSetupImpl setupImpl = (EntityManagerSetupImpl)EntityManagerFactoryProvider.emSetupImpls.get(delegate.getSetupImpl().getSessionName());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.metadata-source.xml.file", "extension2.xml");
            properties.put("eclipselink.deploy-on-startup", "true");
            MetadataRefreshCommand command = new MetadataRefreshCommand(properties);
            AbstractSession session = delegate.getAbstractSession();
            command.executeWithSession(session);
            em = emf.createEntityManager();
            this.beginTransaction(em);
            Address add = (Address)em.createQuery("select a from ExtensibilityAddress a where a.city = 'Herestowm'").getSingleResult();
            add.set("appartmentNumber", (Object)"444");
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            add = (Address)em.find(Address.class, (Object)add.getId());
            ExtensibilityTests.assertTrue((boolean)add.get("appartmentNumber").equals("444"));
            ExtensibilityTests.assertNull((String)"RCM Refresh command listener was not removed from old session", (Object)session.getRefreshMetadataListener());
            delegate = (EntityManagerFactoryDelegate)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).getEntityManagerFactory();
            ExtensibilityTests.assertNotNull((String)"RCM Refresh command listener was not added to the new session", (Object)delegate.getDatabaseSession().getRefreshMetadataListener());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            em = emf.createEntityManager();
            this.deleteEmployeeData(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMetadatasourceProperties() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        JpaEntityManagerFactory jpaEmf = JpaHelper.getEntityManagerFactory((EntityManager)em);
        ServerSession originalSession = jpaEmf.getServerSession();
        String sessionName = originalSession.getName();
        HashMap<String, Object> cleanUpProperties = new HashMap<String, Object>(4);
        Object transactionType = originalSession.getProperty("javax.persistence.transactionType");
        if (transactionType != null) {
            transactionType = "";
        }
        cleanUpProperties.put("javax.persistence.transactionType", transactionType);
        Object jtaDataSource = originalSession.getProperty("javax.persistence.jtaDataSource");
        if (jtaDataSource != null) {
            Connector mainConnector = originalSession.getLogin().getConnector();
            jtaDataSource = mainConnector instanceof JNDIConnector ? ((JNDIConnector)mainConnector).getName() : "";
        }
        cleanUpProperties.put("javax.persistence.jtaDataSource", jtaDataSource);
        Object nonJtaDataSource = originalSession.getProperty("javax.persistence.nonJtaDataSource");
        if (nonJtaDataSource != null) {
            Connector readConnector = ((DatabaseLogin)originalSession.getReadConnectionPool().getLogin()).getConnector();
            nonJtaDataSource = readConnector instanceof JNDIConnector ? ((JNDIConnector)readConnector).getName() : "";
        }
        cleanUpProperties.put("javax.persistence.nonJtaDataSource", nonJtaDataSource);
        cleanUpProperties.put("eclipselink.metadata-source.properties.file", "");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.metadata-source.properties.file", "extension.properties");
        jpaEmf.refreshMetadata(properties);
        try {
            em = emf.createEntityManager();
            ExtensibilityTests.fail((String)"PersistenceException was expected");
        }
        catch (PersistenceException ex) {
            Connector mainConnector;
            String errorMsg = "";
            ServerSession serverSession = (ServerSession)((EntityManagerSetupImpl)EntityManagerFactoryProvider.emSetupImpls.get(sessionName)).getSession();
            if (!serverSession.getLogin().shouldUseExternalTransactionController()) {
                errorMsg = errorMsg + "External tarnsaction controller was expected; ";
            }
            if (!((mainConnector = serverSession.getLogin().getConnector()) instanceof JNDIConnector)) {
                errorMsg = errorMsg + "Main JNDIConnector was expected; ";
            } else if (!((JNDIConnector)mainConnector).getName().equals("MyJtaDataSource")) {
                errorMsg = errorMsg + "MyJtaDataSource was expected; ";
            }
            Connector readConnector = ((DatabaseLogin)serverSession.getReadConnectionPool().getLogin()).getConnector();
            if (!(readConnector instanceof JNDIConnector)) {
                errorMsg = errorMsg + "Read JNDIConnector was expected; ";
            } else if (!((JNDIConnector)readConnector).getName().equals("MyNonJtaDataSource")) {
                errorMsg = errorMsg + "MyNonJtaDataSource was expected; ";
            }
        }
        finally {
            jpaEmf.refreshMetadata(cleanUpProperties);
            emf.createEntityManager();
        }
    }
}

