/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jaxrs;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Address;

public class ContextResolverTestCases
extends JUnitTestCase {
    private JAXBContext jc;

    public ContextResolverTestCases(String name) throws Exception {
        super(name);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("eclipselink-oxm-xml", "META-INF/binding-address.xml");
        this.jc = JAXBContext.newInstance((Class[])new Class[]{Address.class}, props);
    }

    protected Address getControlObject() {
        Address address = new Address();
        address.setId(1L);
        address.setStreet("1 A Street");
        address.setCity("Ottawa");
        return address;
    }

    protected String getID() {
        return "1";
    }

    protected JAXBContext getJAXBContext() {
        return this.jc;
    }

    protected String getURL() {
        return "http://%%host:port%%/CustomerWAR/rest/address_war";
    }

    public void testGetAddress() throws Exception {
        URL url = new URL(this.getURL() + "/" + this.getID());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Address testObject = (Address)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        int response = connection.getResponseCode();
        connection.disconnect();
        ContextResolverTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        ContextResolverTestCases.assertEquals((Object)this.getControlObject(), (Object)testObject);
    }

    public void testGetAddressJSON() throws Exception {
        URL url = new URL(this.getURL() + "/" + this.getID());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        Address testObject = (Address)u.unmarshal((Source)json, Address.class).getValue();
        int response = connection.getResponseCode();
        connection.disconnect();
        ContextResolverTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        ContextResolverTestCases.assertEquals((Object)this.getControlObject(), (Object)testObject);
    }
}

