/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.sessionbean;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.rmi.PortableRemoteObject;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService;

public class SessionBeanTestsRCM
extends JUnitTestCase {
    protected EmployeeService service;
    private String wlsUserName;
    private String wlsPassword;
    private String server1Url;
    private String server2Url;
    private String server3Url;
    int empId = 0;
    private Employee employeeCached = null;

    public SessionBeanTestsRCM() {
    }

    public SessionBeanTestsRCM(String name) {
        super(name);
    }

    public SessionBeanTestsRCM(String name, boolean shouldRunTestOnServer) {
        super(name);
        this.shouldRunTestOnServer = shouldRunTestOnServer;
        URL url = ((Object)((Object)this)).getClass().getResource("/weblogic.properties");
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
        this.server1Url = properties.getProperty("rcm.wls.server1.url");
        this.server2Url = properties.getProperty("rcm.wls.server2.url");
        this.server3Url = properties.getProperty("rcm.wls.server3.url");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SessionBeanTestsRCM");
        suite.addTest((Test)new SessionBeanTestsRCM("testSetupRcmOnServer2", true));
        suite.addTest((Test)new SessionBeanTestsRCM("testSetupForDeleteOnServer2", false));
        suite.addTest((Test)new SessionBeanTestsRCM("testSetupRcmOnServer1", false));
        suite.addTest((Test)new SessionBeanTestsRCM("testPerformDeleteOnServer1", false));
        suite.addTest((Test)new SessionBeanTestsRCM("testConfirmUpdateOnServer2", false));
        suite.addTest((Test)new SessionBeanTestsRCM("testConfirmDeleteOnServer2", false));
        return suite;
    }

    public void testSetupRcmOnServer2() throws Exception {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"sessionbean"));
    }

    public EmployeeService getEmployeeService(String url) throws Exception {
        Properties properties = new Properties();
        properties.put("java.naming.provider.url", url);
        InitialContext context = new InitialContext(properties);
        try {
            return (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("java:comp/env/ejb/EmployeeService"), EmployeeService.class);
        }
        catch (NameNotFoundException notFoundException) {
            try {
                return (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("ejb/EmployeeService"), EmployeeService.class);
            }
            catch (NameNotFoundException notFoundException2) {
                try {
                    return (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("EmployeeService#org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService"), EmployeeService.class);
                }
                catch (NameNotFoundException notFoundException3) {
                    try {
                        return (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("EmployeeService/remote"), EmployeeService.class);
                    }
                    catch (NameNotFoundException notFoundException4) {
                        throw new Error("All lookups failed.", notFoundException);
                    }
                }
            }
        }
    }

    public void testSetupForDeleteOnServer2() throws Exception {
        this.getEmployeeService(this.server1Url).findAll();
        this.getEmployeeService(this.server2Url).findAll();
        Thread.sleep(5000L);
        Employee employee = new Employee();
        employee.setFirstName("Jane2");
        employee.setLastName("Doe2");
        employee.setAddress(new Address());
        employee.getAddress().setCity("Ottawa2");
        Employee manager = new Employee();
        manager.setFirstName("John2");
        manager.setLastName("Done2");
        employee.setManager(manager);
        int empID = this.getEmployeeService(this.server2Url).insert(employee);
        employee = this.getEmployeeService(this.server2Url).findById(empID);
        if (employee == null) {
            SessionBeanTestsRCM.fail((String)"Server2 CacheCoordination Setup Failure: New employee added from Server2 is not found in cache or DB.");
        }
    }

    public void testSetupRcmOnServer1() throws Exception {
        Thread.sleep(1000L);
        Employee employee = new Employee();
        employee.setFirstName("Jane1");
        employee.setLastName("Doe1");
        employee.setAddress(new Address());
        employee.getAddress().setCity("Ottawa1");
        Employee manager = new Employee();
        manager.setFirstName("John1");
        manager.setLastName("Done1");
        employee.setManager(manager);
        employee.setStatus(Employee.EmployeeStatus.FULL_TIME);
        this.empId = this.getEmployeeService(this.server1Url).insert(employee);
        Employee jane1 = this.getEmployeeService(this.server1Url).findById(this.empId);
        jane1.setLastName("LastNameUpdatedOnServer1");
        jane1.getAddress().setCity("newCity");
        this.getEmployeeService(this.server1Url).update(jane1);
        if (!jane1.getLastName().equals("LastNameUpdatedOnServer1")) {
            SessionBeanTestsRCM.fail((String)"UpdateTest Setup on Server1 failed");
        }
    }

    public void testPerformDeleteOnServer1() throws Exception {
        Thread.sleep(1000L);
        List result = this.getEmployeeService(this.server1Url).findByFirstName("Jane2");
        boolean count = false;
        for (Employee this.employeeCached : result) {
        }
        if (this.employeeCached == null) {
            SessionBeanTestsRCM.fail((String)"Perform Delete Test failed: New employee was not found in distributed cache to delete");
        }
        this.getEmployeeService(this.server1Url).delete(this.employeeCached);
    }

    public void testConfirmUpdateOnServer2() throws Exception {
        Thread.sleep(1000L);
        List result = this.getEmployeeService(this.server2Url).findByFirstName("Jane1");
        boolean count = false;
        for (Employee this.employeeCached : result) {
        }
        if (this.employeeCached == null) {
            SessionBeanTestsRCM.fail((String)"Object Update Test verification failed: New employee was not found in distributed cache");
        }
        if (!this.employeeCached.getLastName().equals("LastNameUpdatedOnServer1")) {
            SessionBeanTestsRCM.fail((String)"Object Update Test verification failed: Changes from server1 is not seen by server2 from distributed cache");
        }
    }

    public void testConfirmDeleteOnServer2() throws Exception {
        Thread.sleep(1000L);
        List result = this.getEmployeeService(this.server2Url).findByFirstName("Jane2");
        for (Employee this.employeeCached : result) {
        }
        if (this.employeeCached != null) {
            SessionBeanTestsRCM.fail((String)"Object Delete Test verification failed: employee was not removed from cache as expected");
        }
    }
}

