/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Container;
import java.awt.LayoutManager;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class AccessibleTitledPanel
extends JPanel {
    public AccessibleTitledPanel() {
    }

    public AccessibleTitledPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAccessibleTitledPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAccessibleTitledPane
    extends JPanel.AccessibleJPanel {
        protected AccessibleAccessibleTitledPane() {
            super(AccessibleTitledPanel.this);
        }

        private boolean containerIsValid(Container container) {
            return container instanceof JComponent && !(container instanceof JScrollPane) && !(container instanceof JSplitPane) && !(container instanceof JTabbedPane);
        }

        private String findTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                String title = this.findTitle(compoundBorder.getInsideBorder());
                if (title == null) {
                    title = this.findTitle(compoundBorder.getOutsideBorder());
                }
                return title;
            }
            return null;
        }

        @Override
        public String getTitledBorderText() {
            return this.traverseForTitleText(AccessibleTitledPanel.this);
        }

        private String traverseForTitleText(Container container) {
            if (this.containerIsValid(container)) {
                JComponent jComponent = (JComponent)container;
                String title = this.findTitle(jComponent.getBorder());
                if (title != null) {
                    return title;
                }
                return this.traverseForTitleText(jComponent.getParent());
            }
            return null;
        }

        @Override
        protected String getBorderTitle(Border border) {
            return this.getTitledBorderText();
        }
    }
}

