/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ListIterator;
import java.util.prefs.Preferences;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigWriter;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

abstract class RootSCAdapter
extends SCAdapter
implements Nominative {
    private volatile String name;
    private volatile SessionManager sessionManager;
    private volatile SCSessionsProperties properties;
    private volatile Preferences preferences;
    private volatile File savePath;
    public static final String SAVE_PATH_PROPERTY = "configSavePath";
    private ChangeNotifier changeNotifier;
    private volatile Node.Validator validator;
    private static final String CR = System.getProperty("line.separator");

    RootSCAdapter(SCSessionsProperties properties, Preferences preferences, boolean buildModel) {
        this.initialize(properties, preferences);
        if (buildModel) {
            this.initialize(this.buildModel());
            this.initializeDefaults();
            this.setConfigClean(true);
        } else {
            this.initializeFromModel(this.load());
            this.markEntireBranchClean();
            this.postInitializationFromModel();
            this.setConfigClean(false);
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.getClassRepository());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.sessionManager = SessionManager.getManager();
    }

    private void initialize(SCSessionsProperties properties, Preferences preferences) {
        this.changeNotifier = DefaultChangeNotifier.instance();
        this.validator = NULL_VALIDATOR;
        this.properties = properties;
        this.preferences = preferences;
        this.savePath = properties.getPath();
        this.setName(this.savePath.getName());
        properties.getClassRepository().setParent((Node)this);
    }

    private SessionConfigs load() {
        SessionConfigs topLinkSessions = this.sessionManager.getInternalMWConfigObjects(this.getPath().getPath(), this.buildLoader(), false);
        return topLinkSessions;
    }

    private URL[] buildEntries() {
        ListIterator iter = this.getClassRepository().classpathEntries();
        URL[] entries = new URL[this.getClassRepository().classpathEntriesSize()];
        int index = 0;
        while (iter.hasNext()) {
            try {
                URL url = new URL("file", "", (String)iter.next());
                entries[index++] = url;
            }
            catch (MalformedURLException e) {}
        }
        return entries;
    }

    private ClassLoader buildLoader() {
        URLClassLoader loader = new URLClassLoader(this.buildEntries(), this.getClass().getClassLoader()){

            @Override
            public URL findResource(String name) {
                try {
                    if (name.equals(RootSCAdapter.this.getPath().getPath())) {
                        return RootSCAdapter.this.getPath().toURL();
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                URL url = super.findResource(name);
                if (url != null) {
                    return url;
                }
                return this.getClass().getResource(name);
            }
        };
        return loader;
    }

    public void save(File file) throws IOException {
        this.setSavePath(file);
        this.save();
    }

    public void save() throws IOException {
        this.preSaving();
        XMLSessionConfigWriter.write((SessionConfigs)((SessionConfigs)this.getModel()), (String)this.getPath().toString());
        this.postSaving();
        this.markEntireBranchClean();
    }

    @Override
    public String displayString() {
        return this.name;
    }

    public File getPath() {
        return this.properties.getPath();
    }

    public SCSessionsProperties getProperties() {
        return this.properties;
    }

    @Override
    Preferences preferences() {
        return this.preferences;
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.properties.getClassRepository();
    }

    public File getSaveDirectory() {
        return this.properties.getPath().getParentFile();
    }

    private void setSavePath(File savePath) {
        File old = this.getSavePath();
        this.savePath = savePath;
        this.properties.pathChanged(savePath);
        this.firePropertyChanged(SAVE_PATH_PROPERTY, old, savePath);
        this.setName(savePath.getName());
    }

    private File getSavePath() {
        return this.savePath;
    }

    public void toString(StringBuffer sb) {
        sb.append(CR).append("\t").append(this.displayString() + "( " + this.getConfigFileVersion() + " )");
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        String old = this.getName();
        this.name = FileTools.stripExtension((String)name);
        this.firePropertyChanged("name", old, name);
    }

    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    @Override
    protected void markEntireConfigurationClean() {
    }
}

