/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.ComboPopup;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;

public class Combo
extends JComboBox {
    private CellRendererAdapter cellRendererAdapter;
    public static final Component PROTOTYPE_DISPLAY_VALUE = Combo.buildPrototypeDisplayValue();

    public Combo() {
    }

    public Combo(ComboBoxModel model) {
        super(model);
    }

    private static Component buildPrototypeDisplayValue() {
        String item = "item";
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem(item);
        ComboPopup comboPopup = (ComboPopup)((Object)comboBox.getUI().getAccessibleChild(comboBox, 0));
        ListCellRenderer<String> cellRenderer = comboBox.getRenderer();
        JLabel label = (JLabel)cellRenderer.getListCellRendererComponent(comboPopup.getList(), item, 0, true, true);
        label.setIcon(EmptyIcon.SMALL_ICON);
        return label;
    }

    private ListCellRenderer buildCellRenderer(CellRendererAdapter cellRendererAdapter) {
        return new ComboCellRenderer(this.getRenderer(), cellRendererAdapter, PROTOTYPE_DISPLAY_VALUE);
    }

    @Override
    public void configureEditor(ComboBoxEditor editor, Object item) {
    }

    public final void fixSize() {
        Object oldPrototypeDisplayValue = this.getPrototypeDisplayValue();
        this.setPrototypeDisplayValue(null);
        Dimension size = this.getPreferredSize();
        size.width = Math.max(size.width + 20, 100);
        this.setPreferredSize(size);
        this.setPrototypeDisplayValue(oldPrototypeDisplayValue);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCombo();
        }
        return this.accessibleContext;
    }

    final JList popupList() {
        ComboPopup comboPopup = (ComboPopup)((Object)this.getAccessibleContext().getAccessibleChild(0));
        return comboPopup.getList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.popupList().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public final void setRendererAdapter(CellRendererAdapter cellRendererAdapter) {
        if (this.cellRendererAdapter != cellRendererAdapter) {
            this.cellRendererAdapter = cellRendererAdapter;
            this.setPrototypeDisplayValue(PROTOTYPE_DISPLAY_VALUE);
            this.setRenderer(this.buildCellRenderer(cellRendererAdapter));
            if (this.isPreferredSizeSet()) {
                this.fixSize();
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.cellRendererAdapter != null) {
            this.setRenderer(this.buildCellRenderer(this.cellRendererAdapter));
        }
    }

    protected class AccessibleCombo
    extends JComboBox.AccessibleJComboBox {
        protected AccessibleCombo() {
            super(Combo.this);
        }
    }
}

