/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import javax.persistence.AttributeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class ConverterAccessor
extends ORMetadata {
    protected String className;
    protected Boolean autoApply;
    protected MetadataClass attributeClassification;
    protected MetadataClass fieldClassification;

    public ConverterAccessor() {
        super("<converter>");
    }

    public ConverterAccessor(MetadataAnnotation converter, MetadataClass metadataClass, MetadataProject project) {
        super(converter, metadataClass, project);
        this.autoApply = (Boolean)converter.getAttributeBooleanDefaultFalse("autoApply");
        this.initClassificationClasses(metadataClass);
    }

    public boolean autoApply() {
        return this.autoApply != null && this.autoApply != false;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConverterAccessor) {
            ConverterAccessor converter = (ConverterAccessor)objectToCompare;
            return this.valuesMatch(this.autoApply, converter.getAutoApply());
        }
        return false;
    }

    public Boolean getAutoApply() {
        return this.autoApply;
    }

    public MetadataClass getAttributeClassification() {
        return this.attributeClassification;
    }

    public String getClassName() {
        return this.className;
    }

    protected String getClassificationType(boolean disableConversion) {
        return disableConversion ? this.attributeClassification.getName() : this.fieldClassification.getName();
    }

    @Override
    public String getIdentifier() {
        return this.getAccessibleObjectName();
    }

    public String getJavaClassName() {
        return this.getAccessibleObjectName();
    }

    protected void initClassificationClasses(MetadataClass cls) {
        if (!cls.extendsInterface(AttributeConverter.class)) {
            throw ValidationException.converterClassMustImplementAttributeConverterInterface(cls.getName());
        }
        this.attributeClassification = this.getMetadataClass(((MetadataClass)this.getAccessibleObject()).getGenericType().get(2));
        this.fieldClassification = this.getMetadataClass(((MetadataClass)this.getAccessibleObject()).getGenericType().get(3));
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initClassificationClasses((MetadataClass)accessibleObject);
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        ConverterAccessor accessor = (ConverterAccessor)metadata;
        this.autoApply = (Boolean)this.mergeSimpleObjects(this.autoApply, accessor.getAutoApply(), accessor, "@auto-apply");
    }

    public void process(DatabaseMapping mapping, boolean isForMapKey, String attributeName) {
        this.process(mapping, isForMapKey, attributeName, false);
    }

    public void process(DatabaseMapping mapping, boolean isForMapKey, String attributeName, boolean disableConversion) {
        String fieldClassificationName = this.getClassificationType(disableConversion);
        ConverterClass converterClass = new ConverterClass(this.getJavaClassName(), isForMapKey, fieldClassificationName, disableConversion);
        if (mapping.isDirectMapMapping() && isForMapKey) {
            ((DirectMapMapping)mapping).setKeyConverter(converterClass);
            ((DirectMapMapping)mapping).setDirectKeyFieldClassificationName(fieldClassificationName);
        } else if (mapping.isDirectCollectionMapping()) {
            ((DirectCollectionMapping)mapping).setValueConverter(converterClass);
            ((DirectCollectionMapping)mapping).setDirectFieldClassificationName(fieldClassificationName);
        } else if (mapping.isDirectToFieldMapping()) {
            ((AbstractDirectMapping)mapping).setConverter(converterClass);
            ((AbstractDirectMapping)mapping).setFieldClassificationClassName(fieldClassificationName);
        } else if (mapping.isAggregateObjectMapping()) {
            ((AggregateObjectMapping)mapping).addConverter(converterClass, attributeName);
        } else {
            mapping.isAggregateCollectionMapping();
        }
    }

    public void setAutoApply(Boolean autoApply) {
        this.autoApply = autoApply;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

