/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ConvertMetadata
extends ORMetadata {
    public static final String KEY = "key";
    private String m_text;
    private Boolean m_isForMapKey;
    private Boolean m_disableConversion;
    private MetadataClass m_converterClass;
    private String m_converterClassName;
    private String m_attributeName;

    public ConvertMetadata() {
        super("<convert");
    }

    public ConvertMetadata(MetadataAnnotation convert, MetadataAccessor accessor) {
        super(convert, accessor);
        this.m_converterClass = this.getMetadataClass((String)convert.getAttributeClass("converter", Void.class));
        this.m_attributeName = (String)convert.getAttributeString("attributeName");
        this.m_disableConversion = (Boolean)convert.getAttributeBooleanDefaultFalse("disableConversion");
    }

    public boolean disableConversion() {
        return this.m_disableConversion != null && this.m_disableConversion != false;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConvertMetadata) {
            ConvertMetadata convert = (ConvertMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_text, convert.getText())) {
                return false;
            }
            if (!this.valuesMatch(this.m_converterClassName, convert.getConverterClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_attributeName, convert.getAttributeName())) {
                return false;
            }
            return this.valuesMatch(this.m_disableConversion, convert.getDisableConversion());
        }
        return false;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public MetadataClass getConverterClass() {
        return this.m_converterClass;
    }

    public String getConverterClassName() {
        return this.m_converterClassName;
    }

    public Boolean getDisableConversion() {
        return this.m_disableConversion;
    }

    @Override
    protected String getText() {
        return this.m_text;
    }

    public boolean hasAttributeName() {
        return this.m_attributeName != null && !this.m_attributeName.equals("");
    }

    public boolean hasConverterClass() {
        return this.m_converterClass != null && !this.m_converterClass.isVoid();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_converterClass = this.initXMLClassName(this.m_converterClassName);
    }

    public boolean isForMapKey() {
        if (this.m_isForMapKey == null) {
            if (this.m_attributeName != null && this.m_attributeName.startsWith(KEY)) {
                this.m_attributeName = this.m_attributeName.equals(KEY) ? "" : this.m_attributeName.substring(KEY.length() + 1);
                this.m_isForMapKey = true;
            } else {
                this.m_isForMapKey = false;
            }
        }
        return this.m_isForMapKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(DatabaseMapping mapping, MetadataClass referenceClass, ClassAccessor accessor, boolean isForMapKey) {
        if (this.hasAttributeName()) {
            if (!mapping.isAggregateObjectMapping()) throw ValidationException.invalidMappingForConvertWithAttributeName(accessor.getJavaClassName(), mapping.getAttributeName());
            EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(referenceClass);
            MappingAccessor mappingAccessor = embeddableAccessor.getDescriptor().getMappingAccessor(this.getAttributeName());
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAttributeNameForConvertNotFound(accessor.getJavaClassName(), mapping.getAttributeName(), embeddableAccessor.getJavaClassName(), this.getAttributeName());
            }
            referenceClass = mappingAccessor.getReferenceClass();
        } else if (mapping.isAggregateObjectMapping()) {
            throw ValidationException.missingMappingConvertAttributeName(accessor.getJavaClassName(), mapping.getAttributeName());
        }
        if (this.hasConverterClass()) {
            if (!this.getProject().hasConverterAccessor(this.getConverterClass())) throw ValidationException.converterClassNotFound(accessor.getJavaClassName(), mapping.getAttributeName(), this.getConverterClass().getName());
            this.getProject().getConverterAccessor(this.getConverterClass()).process(mapping, isForMapKey, this.getAttributeName());
            return;
        } else {
            if (!this.getProject().hasAutoApplyConverter(referenceClass)) return;
            if (this.disableConversion()) {
                if (!mapping.isAggregateObjectMapping()) return;
                this.getProject().getAutoApplyConverter(referenceClass).process(mapping, isForMapKey, this.getAttributeName(), true);
                return;
            } else {
                this.getProject().getAutoApplyConverter(referenceClass).process(mapping, isForMapKey, this.getAttributeName());
            }
        }
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setConverterClassName(String converterClassName) {
        this.m_converterClassName = converterClassName;
    }

    public void setDisableConversion(Boolean disableConversion) {
        this.m_disableConversion = disableConversion;
    }

    public void setText(String text) {
        this.m_text = text;
    }
}

