/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;

public abstract class AbstractQueryImpl<T>
extends CommonAbstractCriteriaImpl<T>
implements AbstractQuery<T>,
Serializable {
    protected ResultType queryResult;
    protected boolean distinct;
    protected Predicate havingClause;
    protected List<Expression<?>> groupBy;
    protected Set<Root<?>> roots = new HashSet();

    public AbstractQueryImpl(Metamodel metamodel, ResultType queryResult, CriteriaBuilderImpl queryBuilder, Class<T> resultType) {
        super(metamodel, queryBuilder, resultType);
        this.queryResult = queryResult;
    }

    @Override
    public AbstractQuery<T> groupBy(List<Expression<?>> grouping) {
        this.groupBy = grouping;
        return this;
    }

    @Override
    public AbstractQuery<T> groupBy(Expression<?> ... grouping) {
        this.groupBy = new ArrayList();
        Expression<?>[] expressionArray = grouping;
        int n = grouping.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<?> exp = expressionArray[n2];
            this.groupBy.add(exp);
            ++n2;
        }
        return this;
    }

    @Override
    public AbstractQuery<T> having(Expression<Boolean> restriction) {
        this.havingClause = ((InternalExpression)((Object)restriction)).isCompoundExpression() || ((InternalExpression)((Object)restriction)).isPredicate() ? (Predicate)restriction : this.queryBuilder.isTrue(restriction);
        return this;
    }

    @Override
    public AbstractQuery<T> having(Predicate ... restrictions) {
        if (restrictions != null && restrictions.length > 0) {
            Predicate conjunction = this.queryBuilder.conjunction();
            Predicate[] predicateArray = restrictions;
            int n = restrictions.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = predicateArray[n2];
                conjunction = this.queryBuilder.and((Expression<Boolean>)conjunction, (Expression<Boolean>)predicate);
                ++n2;
            }
            this.havingClause = conjunction;
        }
        return this;
    }

    public abstract void addJoin(FromImpl var1);

    @Override
    public AbstractQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    protected org.eclipse.persistence.expressions.Expression getBaseExpression() {
        if (this.roots.isEmpty()) {
            return new ExpressionBuilder();
        }
        return ((RootImpl)this.roots.iterator().next()).getCurrentNode();
    }

    @Override
    public List<Expression<?>> getGroupList() {
        return this.groupBy;
    }

    @Override
    public Predicate getGroupRestriction() {
        return this.havingClause;
    }

    @Override
    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    @Override
    protected void integrateRoot(RootImpl root) {
        if (!this.roots.contains(root)) {
            this.roots.add(root);
        }
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    protected void findJoins(FromImpl root) {
        root.findJoins(this);
    }

    @Override
    protected void findRootAndParameters(Selection<?> selection) {
        if (selection.isCompoundSelection()) {
            for (Selection<?> subSelection : selection.getCompoundSelectionItems()) {
                this.findRootAndParameters(subSelection);
            }
        }
    }

    @Override
    public <X> Root<X> from(EntityType<X> entity) {
        return this.internalFrom(entity);
    }

    @Override
    public <X> Root<X> from(Class<X> entityClass) {
        return this.internalFrom(entityClass);
    }

    @Override
    public AbstractQuery<T> where(Expression<Boolean> restriction) {
        return (AbstractQuery)super.where(restriction);
    }

    @Override
    public AbstractQuery<T> where(Predicate ... restrictions) {
        return (AbstractQuery)super.where(restrictions);
    }

    protected static enum ResultType {
        UNKNOWN,
        OBJECT_ARRAY,
        PARTIAL,
        TUPLE,
        ENTITY,
        CONSTRUCTOR,
        OTHER;

    }
}

