/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;

public class EntityFetchGroup
extends FetchGroup {
    protected EntityFetchGroup() {
    }

    public EntityFetchGroup(FetchGroup fetchGroup) {
        super(fetchGroup.getName());
        if (fetchGroup.hasItems()) {
            Iterator<String> it = fetchGroup.getItems().keySet().iterator();
            while (it.hasNext()) {
                super.addAttribute(it.next(), null);
            }
        }
    }

    public EntityFetchGroup(String attributeName) {
        super.addAttribute(attributeName, null);
    }

    public EntityFetchGroup(Collection<String> attributeNames) {
        Iterator<String> it = attributeNames.iterator();
        while (it.hasNext()) {
            super.addAttribute(it.next(), null);
        }
    }

    public EntityFetchGroup(String[] attributeNames) {
        int i = 0;
        while (i < attributeNames.length) {
            super.addAttribute(attributeNames[i], null);
            ++i;
        }
    }

    public EntityFetchGroup(FetchGroup fetchGroup, String attributeName) {
        super(String.valueOf(fetchGroup.getName()) + "+" + attributeName);
        if (fetchGroup.hasItems()) {
            Iterator<String> it = fetchGroup.getItems().keySet().iterator();
            while (it.hasNext()) {
                super.addAttribute(it.next(), null);
            }
        }
        super.addAttribute(attributeName, null);
    }

    @Override
    public void addAttribute(String attributeNameOrPath, AttributeGroup group) {
        throw new IllegalStateException(ExceptionLocalization.buildMessage("cannot_update_entity_fetch-group", new Object[]{this, attributeNameOrPath}));
    }

    @Override
    public String onUnfetchedAttribute(FetchGroupTracker entity, String attributeName) {
        if (entity._persistence_getSession() != null) {
            return super.onUnfetchedAttribute(entity, attributeName);
        }
        throw new IllegalStateException(ExceptionLocalization.buildMessage("cannot_get_unfetched_attribute", new Object[]{entity, attributeName}));
    }

    @Override
    public String onUnfetchedAttributeForSet(FetchGroupTracker entity, String attributeName) {
        if (entity._persistence_getSession() != null) {
            return super.onUnfetchedAttributeForSet(entity, attributeName);
        }
        entity._persistence_setFetchGroup(new EntityFetchGroup(this, attributeName));
        return null;
    }

    @Override
    public void removeAttribute(String attributeNameOrPath) {
        throw new IllegalStateException(ExceptionLocalization.buildMessage("cannot_update_entity_fetch-group", new Object[]{this, attributeNameOrPath}));
    }

    public void setOnEntity(Object entity, AbstractSession session) {
        ((FetchGroupTracker)entity)._persistence_setFetchGroup(this);
        ((FetchGroupTracker)entity)._persistence_setSession(session);
    }

    @Override
    public boolean isEntityFetchGroup() {
        return true;
    }

    @Override
    public boolean isSupersetOf(AttributeGroup anotherGroup) {
        if (anotherGroup == null) {
            return false;
        }
        return this.getAttributeNames().containsAll(anotherGroup.getAttributeNames());
    }
}

