/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.UnionField;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;

public class XMLUnionField
extends XMLField
implements UnionField<NamespaceResolver> {
    private ArrayList schemaTypes = new ArrayList();

    public XMLUnionField() {
    }

    public XMLUnionField(String xPath) {
        super(xPath);
    }

    public ArrayList getSchemaTypes() {
        return this.schemaTypes;
    }

    public void setSchemaTypes(ArrayList value) {
        this.schemaTypes = value;
    }

    @Override
    public void addSchemaType(QName value) {
        if (value != null) {
            if (this.schemaTypes == null) {
                this.schemaTypes = new ArrayList();
            }
            if (!this.contains(this.schemaTypes, value)) {
                this.schemaTypes.add(value);
            }
        }
    }

    @Override
    public QName getSchemaType() {
        if (this.schemaTypes != null) {
            return (QName)this.getSchemaTypes().get(0);
        }
        return null;
    }

    @Override
    public void setSchemaType(QName value) {
        this.addSchemaType(value);
    }

    private boolean contains(ArrayList types, QName value) {
        for (QName type : types) {
            if (!type.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnionField() {
        return true;
    }

    @Override
    public QName getSchemaTypeForValue(Object value, CoreAbstractSession session) {
        if (this.leafElementType != null) {
            return this.leafElementType;
        }
        if (this.isTypedTextField()) {
            return this.getXMLType(value.getClass());
        }
        return this.getSingleValueToWriteForUnion(value, session);
    }

    protected QName getSingleValueToWriteForUnion(Object value, CoreAbstractSession session) {
        ArrayList schemaTypes = this.getSchemaTypes();
        QName schemaType = null;
        int i = 0;
        int schemaTypesSize = schemaTypes.size();
        while (i < schemaTypesSize) {
            block4: {
                QName nextQName = (QName)this.getSchemaTypes().get(i);
                try {
                    if (nextQName != null) {
                        Class javaClass = this.getJavaClass(nextQName);
                        value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, javaClass, nextQName);
                        schemaType = nextQName;
                        break;
                    }
                }
                catch (ConversionException conversionException) {
                    if (i != schemaTypes.size() - 1) break block4;
                    schemaType = nextQName;
                }
            }
            ++i;
        }
        return schemaType;
    }

    @Override
    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager, XMLRecord record) {
        Object convertedValue = value;
        int i = 0;
        while (i < this.schemaTypes.size()) {
            block5: {
                QName nextQName = (QName)this.schemaTypes.get(i);
                try {
                    if (nextQName != null) {
                        if (XMLConstants.QNAME_QNAME.equals(nextQName)) {
                            xmlConversionManager.buildQNameFromString((String)value, record);
                            break;
                        }
                        Class javaClass = this.getJavaClass(nextQName);
                        convertedValue = xmlConversionManager.convertObject(value, javaClass, nextQName);
                        break;
                    }
                }
                catch (ConversionException ce) {
                    if (i != this.schemaTypes.size() - 1) break block5;
                    throw ce;
                }
            }
            ++i;
        }
        return convertedValue;
    }

    @Override
    public Class getJavaClass(QName qname) {
        Class theClass;
        if (this.userXMLTypes != null && (theClass = (Class)this.userXMLTypes.get(qname)) != null) {
            return theClass;
        }
        Class javaClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qname);
        return XMLConversionManager.getObjectClass(javaClass);
    }

    @Override
    public boolean isSchemaType(QName schemaType) {
        if (this.getSchemaTypes() == null || this.getSchemaTypes().size() == 0) {
            return false;
        }
        return this.contains(this.getSchemaTypes(), schemaType);
    }
}

