/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.jpa.rs.AbstractResource;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@Path(value="/{context}/entity/")
public class EntityResource
extends AbstractResource {
    @GET
    @Path(value="{type}/{key}/{attribute}")
    public Response findAttribute(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.findAttribute(persistenceUnit, type, key, attribute, hh, ui, ui.getBaseUri());
    }

    protected Response findAttribute(String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI) {
        Object id;
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = EntityResource.getMatrixParameters(ui, persistenceUnit);
        Object entity = app.findAttribute(discriminators, type, id = IdHelper.buildId(app, type, key), EntityResource.getQueryParameters(ui), attribute);
        if (entity == null) {
            JPARSLogger.fine("jpars_could_not_entity_for_attribute", new Object[]{type, key, attribute, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{type}/{key}")
    public Response find(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.find(persistenceUnit, type, key, hh, ui, ui.getBaseUri());
    }

    protected Response find(String persistenceUnit, String type, String key, HttpHeaders hh, UriInfo ui, URI baseURI) {
        Object id;
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = EntityResource.getMatrixParameters(ui, persistenceUnit);
        Object entity = app.find(discriminators, type, id = IdHelper.buildId(app, type, key), EntityResource.getQueryParameters(ui));
        if (entity == null) {
            JPARSLogger.fine("jpars_could_not_entity_for_key", new Object[]{type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @PUT
    @Path(value="{type}")
    public Response create(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) throws JAXBException {
        return this.create(persistenceUnit, type, hh, uriInfo, uriInfo.getBaseUri(), in);
    }

    protected Response create(String persistenceUnit, String type, HttpHeaders hh, UriInfo uriInfo, URI baseURI, InputStream in) throws JAXBException {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ClassDescriptor descriptor = app.getDescriptor(type);
        if (descriptor == null) {
            JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_unmarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        AbstractDirectMapping sequenceMapping = descriptor.getObjectBuilder().getSequenceMapping();
        if (sequenceMapping != null) {
            Object value = sequenceMapping.getAttributeAccessor().getAttributeValueFromObject(entity);
            if (descriptor.getObjectBuilder().isPrimaryKeyComponentInvalid(value, descriptor.getPrimaryKeyFields().indexOf(descriptor.getSequenceNumberField())) || descriptor.getSequence().shouldAlwaysOverrideExistingValue()) {
                JPARSLogger.fine("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        app.create(EntityResource.getMatrixParameters(uriInfo, persistenceUnit), entity);
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.CREATED);
        rb.entity((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes()));
        return rb.build();
    }

    @POST
    @Path(value="{type}")
    public Response update(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) {
        return this.update(persistenceUnit, type, hh, uriInfo, uriInfo.getBaseUri(), in);
    }

    protected Response update(String persistenceUnit, String type, HttpHeaders hh, UriInfo uriInfo, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        MediaType contentType = StreamingOutputMarshaller.mediaType(hh.getRequestHeader("Content-Type"));
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, contentType, in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_unmarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        entity = app.merge(EntityResource.getMatrixParameters(uriInfo, persistenceUnit), entity);
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @POST
    @Path(value="{type}/{key}/{attribute}")
    public Response setOrAddAttribute(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui, InputStream in) {
        return this.setOrAddAttribute(persistenceUnit, type, key, attribute, hh, ui, ui.getBaseUri(), in);
    }

    protected Response setOrAddAttribute(String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object id = IdHelper.buildId(app, type, key);
        Object entity = null;
        String partner = EntityResource.getMatrixParameters(ui, attribute).get("partner");
        try {
            ClassDescriptor descriptor = app.getDescriptor(type);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (!mapping.isForeignReferenceMapping()) {
                JPARSLogger.fine("jpars_could_find_appropriate_mapping_for_update", new Object[]{attribute, type, key, persistenceUnit});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            entity = app.unmarshalEntity(((ForeignReferenceMapping)mapping).getReferenceDescriptor().getAlias(), StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_unmarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Object result = app.updateOrAddAttribute(EntityResource.getMatrixParameters(ui, persistenceUnit), type, id, EntityResource.getQueryParameters(ui), attribute, entity, partner);
        if (result == null) {
            JPARSLogger.fine("jpars_could_not_update_attribute", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    @DELETE
    @Path(value="{type}/{key}/{attribute}")
    public Response removeAttribute(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui) {
        Map<String, Object> queryParams;
        String partner = null;
        String listItemId = null;
        Map<String, String> matrixParams = EntityResource.getMatrixParameters(ui, attribute);
        if (matrixParams != null && !matrixParams.isEmpty()) {
            partner = matrixParams.get("partner");
        }
        if ((queryParams = EntityResource.getQueryParameters(ui)) != null && !queryParams.isEmpty()) {
            listItemId = (String)queryParams.get("eclipselink.jpars.list.item-id");
        }
        return this.removeAttributeInternal(persistenceUnit, type, key, attribute, listItemId, partner, hh, ui);
    }

    protected Response removeAttributeInternal(String persistenceUnit, String type, String key, String attribute, String listItemId, String partner, HttpHeaders hh, UriInfo ui) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, ui.getBaseUri(), null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (attribute == null && listItemId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Object id = IdHelper.buildId(app, type, key);
        ClassDescriptor descriptor = app.getDescriptor(type);
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
        if (!mapping.isForeignReferenceMapping()) {
            JPARSLogger.fine("jpars_could_find_appropriate_mapping_for_update", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = EntityResource.getMatrixParameters(ui, persistenceUnit);
        Object entity = app.find(discriminators, type, id, EntityResource.getQueryParameters(ui));
        Object result = app.removeAttribute(EntityResource.getMatrixParameters(ui, persistenceUnit), type, id, attribute, listItemId, entity, partner);
        if (result == null) {
            JPARSLogger.fine("jpars_could_not_update_attribute", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    @DELETE
    @Path(value="{type}/{key}")
    public Response delete(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @Context UriInfo ui) {
        return this.delete(persistenceUnit, type, key, ui, ui.getBaseUri());
    }

    protected Response delete(String persistenceUnit, String type, String key, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, String> discriminators = EntityResource.getMatrixParameters(ui, persistenceUnit);
        Object id = IdHelper.buildId(app, type, key);
        app.delete(discriminators, type, id);
        return Response.ok().build();
    }
}

