/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Attribute;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Descriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkTemplate;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Query;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.AbstractResource;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@Path(value="/{context}/metadata/")
public class PersistenceUnitResource
extends AbstractResource {
    @GET
    @Path(value="entity/{descriptorAlias}")
    public Response getDescriptorMetadata(@PathParam(value="context") String persistenceUnit, @PathParam(value="descriptorAlias") String descriptorAlias, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getDescriptorMetadata(persistenceUnit, descriptorAlias, hh, uriInfo.getBaseUri());
    }

    protected Response getDescriptorMetadata(String persistenceUnit, String descriptorAlias, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ClassDescriptor descriptor = app.getJpaSession().getDescriptorForAlias(descriptorAlias);
        if (descriptor == null) {
            JPARSLogger.fine("jpars_could_not_find_entity_type", new Object[]{descriptorAlias, persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        Descriptor returnDescriptor = this.buildDescriptor(app, persistenceUnit, descriptor, baseURI.toString());
        String result = null;
        try {
            result = this.marshallMetadata(returnDescriptor, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_entity_metadata", new Object[]{descriptorAlias, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    public Response getTypes(@PathParam(value="context") String persistenceUnit, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getTypes(persistenceUnit, hh, uriInfo.getBaseUri());
    }

    @GET
    @Path(value="query")
    public Response getQueriesMetadata(@PathParam(value="context") String persistenceUnit, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getQueriesMetadata(persistenceUnit, hh, uriInfo.getBaseUri());
    }

    protected Response getQueriesMetadata(String persistenceUnit, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        this.addQueries(queries, app, null);
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        String result = null;
        try {
            result = this.marshallMetadata(queries, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_query_metadata", new Object[]{persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="query/{queryName}")
    public Response getQueryMetadata(@PathParam(value="context") String persistenceUnit, @PathParam(value="queryName") String queryName, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        return this.getQueryMetadata(persistenceUnit, queryName, hh, uriInfo.getBaseUri());
    }

    protected Response getQueryMetadata(String persistenceUnit, String queryName, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Query> returnQueries = new ArrayList<Query>();
        Map queries = app.getJpaSession().getQueries();
        if (queries.get(queryName) != null) {
            for (DatabaseQuery query : (List)queries.get(queryName)) {
                returnQueries.add(this.getQuery(query, app));
            }
        }
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        String result = null;
        try {
            result = this.marshallMetadata(returnQueries, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_individual_query_metadata", new Object[]{queryName, persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    public Response getTypes(String persistenceUnit, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PersistenceUnit pu = new PersistenceUnit();
        pu.setPersistenceUnitName(persistenceUnit);
        Map descriptors = app.getJpaSession().getDescriptors();
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        Iterator contextIterator = descriptors.keySet().iterator();
        while (contextIterator.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(contextIterator.next());
            pu.getTypes().add(new Link(descriptor.getAlias(), mediaType, baseURI + persistenceUnit + "/metadata/entity/" + descriptor.getAlias()));
        }
        String result = null;
        try {
            result = this.marshallMetadata(pu, mediaType);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_marshalling_persitence_unit", new Object[]{persistenceUnit, e.toString()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes()));
        rb.header("Content-Type", (Object)"application/json");
        return rb.build();
    }

    protected void addMapping(Descriptor descriptor, DatabaseMapping mapping) {
        String target = null;
        if (mapping.isCollectionMapping()) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            String collectionType = collectionMapping.getContainerPolicy().getContainerClassName();
            if (collectionMapping.getContainerPolicy().isMapPolicy()) {
                String mapKeyType = ((MapContainerPolicy)collectionMapping.getContainerPolicy()).getKeyType().toString();
                target = String.valueOf(collectionType) + "<" + mapKeyType + ", " + collectionMapping.getReferenceClassName() + ">";
            } else {
                target = String.valueOf(collectionType) + "<" + collectionMapping.getReferenceClassName() + ">";
            }
        } else {
            target = mapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)mapping).getReferenceClass().getName() : mapping.getAttributeClassification().getName();
        }
        descriptor.getAttributes().add(new Attribute(mapping.getAttributeName(), target));
    }

    protected void addQueries(List<Query> queryList, PersistenceContext app, String javaClassName) {
        Map queries = app.getJpaSession().getQueries();
        ArrayList<DatabaseQuery> returnQueries = new ArrayList<DatabaseQuery>();
        for (String key : queries.keySet()) {
            List keyQueries = (List)queries.get(key);
            for (DatabaseQuery query : keyQueries) {
                if (javaClassName != null && (query.getReferenceClassName() == null || !query.getReferenceClassName().equals(javaClassName))) continue;
                returnQueries.add(query);
            }
        }
        Iterator queryIterator = returnQueries.iterator();
        while (queryIterator.hasNext()) {
            queryList.add(this.getQuery((DatabaseQuery)queryIterator.next(), app));
        }
    }

    protected Descriptor buildDescriptor(PersistenceContext app, String persistenceUnit, ClassDescriptor descriptor, String baseUri) {
        Descriptor returnDescriptor = new Descriptor();
        returnDescriptor.setName(descriptor.getAlias());
        returnDescriptor.setType(descriptor.getJavaClassName());
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("find", "get", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("persist", "put", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias()));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("update", "post", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias()));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("delete", "delete", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        if (!descriptor.getMappings().isEmpty()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                this.addMapping(returnDescriptor, mapping);
            }
        }
        this.addQueries(returnDescriptor.getQueries(), app, descriptor.getJavaClassName());
        return returnDescriptor;
    }

    protected Query getQuery(DatabaseQuery query, PersistenceContext app) {
        String method = query.isReadQuery() ? "get" : "post";
        String jpql = query.getJPQLString() == null ? "" : query.getJPQLString();
        StringBuffer parameterString = new StringBuffer();
        for (String argument : query.getArguments()) {
            parameterString.append(";");
            parameterString.append(String.valueOf(argument) + "={" + argument + "}");
        }
        Query returnQuery = new Query(query.getName(), jpql, new LinkTemplate("execute", method, app.getBaseURI() + app.getName() + "/query/" + query.getName() + parameterString));
        if (query.isReportQuery()) {
            query.checkPrepare((AbstractSession)app.getJpaSession(), (AbstractRecord)new DatabaseRecord());
            for (ReportItem item : ((ReportQuery)query).getItems()) {
                if (item.getMapping() != null) {
                    if (item.getAttributeExpression() != null && item.getAttributeExpression().isMapEntryExpression()) {
                        if (((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry()) {
                            returnQuery.getReturnTypes().add(Map.Entry.class.getName());
                            continue;
                        }
                        returnQuery.getReturnTypes().add(((Class)((CollectionMapping)item.getMapping()).getContainerPolicy().getKeyType()).getName());
                        continue;
                    }
                    returnQuery.getReturnTypes().add(item.getMapping().getAttributeClassification().getName());
                    continue;
                }
                if (item.getResultType() != null) {
                    returnQuery.getReturnTypes().add(item.getResultType().getName());
                    continue;
                }
                if (item.getDescriptor() != null) {
                    returnQuery.getReturnTypes().add(item.getDescriptor().getJavaClass().getName());
                    continue;
                }
                if (item.getAttributeExpression() != null && item.getAttributeExpression().isConstantExpression()) {
                    returnQuery.getReturnTypes().add(((ConstantExpression)item.getAttributeExpression()).getValue().getClass().getName());
                    continue;
                }
                returnQuery.getReturnTypes().add(ClassConstants.OBJECT.getName());
            }
        } else {
            returnQuery.getReturnTypes().add(query.getReferenceClassName() == null ? "" : query.getReferenceClassName());
        }
        return returnQuery;
    }

    protected String marshallMetadata(Object metadata, String mediaType) throws JAXBException {
        Class[] jaxbClasses = new Class[]{Link.class, Attribute.class, Descriptor.class, LinkTemplate.class, PersistenceUnit.class, Query.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBMarshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType);
        StringWriter writer = new StringWriter();
        marshaller.marshal(metadata, (Writer)writer);
        return writer.toString();
    }
}

