/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRangeExpression
extends AbstractExpression {
    private String andIdentifier;
    private String betweenIdentifier;
    private boolean hasSpaceAfterAnd;
    private boolean hasSpaceAfterBetween;
    private boolean hasSpaceAfterLowerBound;
    private AbstractExpression lowerBoundExpression;
    private AbstractExpression upperBoundExpression;

    protected AbstractRangeExpression(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getLowerBoundExpression().accept(visitor);
        this.getUpperBoundExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getLowerBoundExpression());
        children.add(this.getUpperBoundExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpaceAfterBetween) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.lowerBoundExpression != null) {
            children.add(this.lowerBoundExpression);
        }
        if (this.hasSpaceAfterLowerBound) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.andIdentifier != null) {
            children.add(this.buildStringExpression("AND"));
        }
        if (this.hasSpaceAfterAnd) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.upperBoundExpression != null) {
            children.add(this.upperBoundExpression);
        }
    }

    protected abstract String boundExpressionQueryBNFId();

    public final String getActualAndIdentifier() {
        return this.andIdentifier != null ? this.andIdentifier : "";
    }

    public final String getActualBetweenIdentifier() {
        return this.betweenIdentifier;
    }

    public final Expression getLowerBoundExpression() {
        if (this.lowerBoundExpression == null) {
            this.lowerBoundExpression = this.buildNullExpression();
        }
        return this.lowerBoundExpression;
    }

    public Expression getUpperBoundExpression() {
        if (this.upperBoundExpression == null) {
            this.upperBoundExpression = this.buildNullExpression();
        }
        return this.upperBoundExpression;
    }

    public final boolean hasAnd() {
        return this.andIdentifier != null;
    }

    protected boolean hasBetween() {
        return this.betweenIdentifier != null;
    }

    public final boolean hasLowerBoundExpression() {
        return this.lowerBoundExpression != null && !this.lowerBoundExpression.isNull();
    }

    public final boolean hasSpaceAfterAnd() {
        return this.hasSpaceAfterAnd;
    }

    public final boolean hasSpaceAfterBetween() {
        return this.hasSpaceAfterBetween;
    }

    public final boolean hasSpaceAfterLowerBound() {
        return this.hasSpaceAfterLowerBound;
    }

    public final boolean hasUpperBoundExpression() {
        return this.upperBoundExpression != null && !this.upperBoundExpression.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("THEN") || word.equalsIgnoreCase("ELSE") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIdentifier("BETWEEN")) {
            this.betweenIdentifier = wordParser.moveForward("BETWEEN");
            this.hasSpaceAfterBetween = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parseRange(wordParser, tolerant);
    }

    protected void parseRange(WordParser wordParser, boolean tolerant) {
        this.lowerBoundExpression = this.parse(wordParser, this.boundExpressionQueryBNFId(), tolerant);
        if (this.hasLowerBoundExpression()) {
            boolean bl = this.hasSpaceAfterLowerBound = wordParser.skipLeadingWhitespace() > 0;
        }
        if (wordParser.startsWithIdentifier("AND")) {
            this.andIdentifier = wordParser.moveForward("AND");
            this.hasSpaceAfterAnd = wordParser.skipLeadingWhitespace() > 0;
        }
        this.upperBoundExpression = this.parse(wordParser, this.boundExpressionQueryBNFId(), tolerant);
    }

    protected void toParsedRangeText(StringBuilder writer, boolean actual) {
        if (this.lowerBoundExpression != null) {
            this.lowerBoundExpression.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterLowerBound) {
            writer.append(' ');
        }
        if (this.andIdentifier != null) {
            writer.append(actual ? this.andIdentifier : "AND");
        }
        if (this.hasSpaceAfterAnd) {
            writer.append(' ');
        }
        if (this.upperBoundExpression != null) {
            this.upperBoundExpression.toParsedText(writer, actual);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.betweenIdentifier != null) {
            writer.append(actual ? this.betweenIdentifier : "BETWEEN");
        }
        if (this.hasSpaceAfterBetween) {
            writer.append(' ');
        }
        this.toParsedRangeText(writer, actual);
    }
}

