/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectByClause
extends AbstractExpression {
    private String actualIdentifier;
    private AbstractExpression expression;
    private boolean hasSpaceAfterConnectBy;

    public ConnectByClause(AbstractExpression parent) {
        super(parent, "CONNECT BY");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("ORDER BY"));
        if (this.hasSpaceAfterConnectBy) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.expression != null) {
            children.add(this.expression);
        }
    }

    public String getActualIdentifier() {
        return this.actualIdentifier;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("connectby_clause");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasSpaceAfterConnectBy() {
        return this.hasSpaceAfterConnectBy;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.actualIdentifier = wordParser.moveForward("CONNECT BY");
        this.hasSpaceAfterConnectBy = wordParser.skipLeadingWhitespace() > 0;
        this.expression = this.parse(wordParser, "collection_valued_path_expression", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.getActualIdentifier() : this.getText());
        if (this.hasSpaceAfterConnectBy) {
            writer.append(' ');
        }
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
    }
}

