/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.xml.bind.Marshaller;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.oxm.XMLMarshalListener;

public class JAXBMarshalListener
implements XMLMarshalListener {
    private Marshaller.Listener listener;
    private Map classBasedMarshalEvents;
    private Marshaller marshaller;
    private JAXBContext jaxbContext;

    public JAXBMarshalListener(JAXBContext context, Marshaller marshaller) {
        this.jaxbContext = context;
        this.marshaller = marshaller;
    }

    public void setListener(Marshaller.Listener jaxbListener) {
        this.listener = jaxbListener;
    }

    public Marshaller.Listener getListener() {
        return this.listener;
    }

    public void beforeMarshal(Object obj) {
        block10: {
            MarshalCallback callback;
            if (this.classBasedMarshalEvents != null && (callback = (MarshalCallback)this.classBasedMarshalEvents.get(obj.getClass().getName())) != null && callback.getBeforeMarshalCallback() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(callback.getBeforeMarshalCallback(), obj, new Object[]{this.marshaller}));
                            break block10;
                        }
                        catch (PrivilegedActionException ex) {
                            if (ex.getCause() instanceof IllegalAccessException) {
                                throw (IllegalAccessException)ex.getCause();
                            }
                            if (ex.getCause() instanceof InvocationTargetException) {
                                throw (InvocationTargetException)ex.getCause();
                            }
                            throw (RuntimeException)ex.getCause();
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)callback.getBeforeMarshalCallback(), (Object)obj, (Object[])new Object[]{this.marshaller});
                }
                catch (Exception exception) {}
            }
        }
        if (this.listener != null) {
            if (obj instanceof Root) {
                obj = this.jaxbContext.createJAXBElementFromXMLRoot((Root)obj, ((Root)obj).getDeclaredType());
            }
            this.listener.beforeMarshal(obj);
        }
    }

    public void afterMarshal(Object obj) {
        block10: {
            MarshalCallback callback;
            if (this.classBasedMarshalEvents != null && (callback = (MarshalCallback)this.classBasedMarshalEvents.get(obj.getClass().getName())) != null && callback.getAfterMarshalCallback() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(callback.getAfterMarshalCallback(), obj, new Object[]{this.marshaller}));
                            break block10;
                        }
                        catch (PrivilegedActionException ex) {
                            if (ex.getCause() instanceof IllegalAccessException) {
                                throw (IllegalAccessException)ex.getCause();
                            }
                            if (ex.getCause() instanceof InvocationTargetException) {
                                throw (InvocationTargetException)ex.getCause();
                            }
                            throw (RuntimeException)ex.getCause();
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)callback.getAfterMarshalCallback(), (Object)obj, (Object[])new Object[]{this.marshaller});
                }
                catch (Exception exception) {}
            }
        }
        if (this.listener != null) {
            if (obj instanceof Root) {
                obj = this.jaxbContext.createJAXBElementFromXMLRoot((Root)obj, ((Root)obj).getDeclaredType());
            }
            this.listener.afterMarshal(obj);
        }
    }

    public void setClassBasedMarshalEvents(Map events) {
        this.classBasedMarshalEvents = events;
    }
}

