/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;

public class PrimaryKeyMetadata
extends ORMetadata {
    private String m_validation;
    private String m_cacheKeyType;
    private List<ColumnMetadata> m_columns = new ArrayList<ColumnMetadata>();

    public PrimaryKeyMetadata() {
        super("<primary-key>");
    }

    public PrimaryKeyMetadata(MetadataAnnotation primaryKey, MetadataAccessor accessor) {
        super(primaryKey, accessor);
        this.m_validation = (String)primaryKey.getAttribute("validation");
        this.m_cacheKeyType = (String)primaryKey.getAttribute("cacheKeyType");
        Object[] objectArray = primaryKey.getAttributeArray("columns");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedColumn = objectArray[n2];
            this.m_columns.add(new ColumnMetadata((MetadataAnnotation)selectedColumn, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PrimaryKeyMetadata) {
            PrimaryKeyMetadata primaryKey = (PrimaryKeyMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_validation, primaryKey.getValidation())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cacheKeyType, primaryKey.getCacheKeyType())) {
                return false;
            }
            return this.valuesMatch(this.m_columns, primaryKey.getColumns());
        }
        return false;
    }

    public String getCacheKeyType() {
        return this.m_cacheKeyType;
    }

    public List<ColumnMetadata> getColumns() {
        return this.m_columns;
    }

    public String getValidation() {
        return this.m_validation;
    }

    public boolean hasColumns() {
        return !this.m_columns.isEmpty();
    }

    public void process(MetadataDescriptor descriptor) {
        descriptor.setHasPrimaryKey();
        if (this.m_validation != null) {
            descriptor.getClassDescriptor().setIdValidation(IdValidation.valueOf((String)this.m_validation));
        }
        if (this.m_cacheKeyType != null) {
            descriptor.getClassDescriptor().setCacheKeyType(CacheKeyType.valueOf((String)this.m_cacheKeyType));
        }
        if (this.hasColumns()) {
            for (ColumnMetadata column : this.m_columns) {
                if (column.getName().equals("")) {
                    throw ValidationException.primaryKeyColumnNameNotSpecified((Object)descriptor.getJavaClass());
                }
                descriptor.addPrimaryKeyField(column.getDatabaseField());
            }
        }
    }

    public void setCacheKeyType(String cacheKeyType) {
        this.m_cacheKeyType = cacheKeyType;
    }

    public void setColumns(List<ColumnMetadata> columns) {
        this.m_columns = columns;
    }

    public void setValidation(String validation) {
        this.m_validation = validation;
    }
}

