/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.aggregate.Aggregate;
import org.eclipse.persistence.testing.models.aggregate.Child;
import org.eclipse.persistence.testing.models.aggregate.Cousin;
import org.eclipse.persistence.testing.models.aggregate.Parent;
import org.eclipse.persistence.testing.models.aggregate.Relative;
import org.eclipse.persistence.testing.models.aggregate.StepChild;

public class AggregateRelationshipsProject
extends Project {
    public AggregateRelationshipsProject() {
        this.setName("AggregateProblem");
        this.applyLogin();
        this.addDescriptor(this.buildAggregateClassDescriptor());
        this.addDescriptor(this.buildChildClassDescriptor());
        this.addDescriptor(this.buildCousinClassDescriptor());
        this.addDescriptor(this.buildParentClassDescriptor());
        this.addDescriptor(this.buildRelativeClassDescriptor());
        this.addDescriptor(this.buildStepChildClassDescriptor());
    }

    public void applyLogin() {
        this.setDatasourceLogin((Login)new DatabaseLogin());
    }

    public ClassDescriptor buildAggregateClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(Aggregate.class);
        descriptor.setAlias("Aggregate");
        DirectCollectionMapping nicknamesMapping = new DirectCollectionMapping();
        nicknamesMapping.setAttributeName("nicknames");
        nicknamesMapping.dontUseIndirection();
        nicknamesMapping.setReferenceTableName("AGG_NICKNAME");
        nicknamesMapping.setDirectFieldName("AGG_NICKNAME.NICKNAME");
        nicknamesMapping.addReferenceKeyFieldName("AGG_NICKNAME.PARENT_ID", "nicknames->P_ID_IN_REFERENCE_NICKNAME_PARENT");
        descriptor.addMapping((DatabaseMapping)nicknamesMapping);
        OneToOneMapping cousinMapping = new OneToOneMapping();
        cousinMapping.setAttributeName("cousin");
        cousinMapping.setReferenceClass(Cousin.class);
        cousinMapping.dontUseIndirection();
        cousinMapping.addForeignKeyFieldName("cousin->COUSIN_ID_IN_REFERENCE_PARENT_COUSIN", "AGG_COUSIN.ID");
        descriptor.addMapping((DatabaseMapping)cousinMapping);
        OneToOneMapping stepChildMapping = new OneToOneMapping();
        stepChildMapping.setAttributeName("stepChild");
        stepChildMapping.setReferenceClass(StepChild.class);
        stepChildMapping.dontUseIndirection();
        stepChildMapping.addTargetForeignKeyFieldName("AGG_STEPCHILD.PARENT_ID", "stepChild->PARENT_ID_IN_REFERENCE_STEPCHILD_PARENT");
        descriptor.addMapping((DatabaseMapping)stepChildMapping);
        OneToManyMapping childrenMapping = new OneToManyMapping();
        childrenMapping.setAttributeName("children");
        childrenMapping.setReferenceClass(Child.class);
        childrenMapping.useTransparentCollection();
        childrenMapping.useCollectionClass(IndirectList.class);
        childrenMapping.addTargetForeignKeyFieldName("AGG_CHILD.PARENT_ID", "children->P_ID_IN_REFERENCE_CHILD_PARENT");
        descriptor.addMapping((DatabaseMapping)childrenMapping);
        ManyToManyMapping relativesMapping = new ManyToManyMapping();
        relativesMapping.setAttributeName("relatives");
        relativesMapping.setReferenceClass(Relative.class);
        relativesMapping.privateOwnedRelationship();
        relativesMapping.useTransparentCollection();
        relativesMapping.useCollectionClass(IndirectList.class);
        relativesMapping.setRelationTableName("AGG_PARENT_RELATIVE");
        relativesMapping.addSourceRelationKeyFieldName("AGG_PARENT_RELATIVE.PARENT_ID", "relatives->P_ID_IN_REFERENCE_RELATIVE_TO_PARENT");
        relativesMapping.addTargetRelationKeyFieldName("AGG_PARENT_RELATIVE.RELATIVE_ID", "AGG_RELATIVE.REL_ID");
        descriptor.addMapping((DatabaseMapping)relativesMapping);
        return descriptor;
    }

    public ClassDescriptor buildChildClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Child.class);
        descriptor.addTableName("AGG_CHILD");
        descriptor.addPrimaryKeyFieldName("AGG_CHILD.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("AGG_CHILD.ID");
        descriptor.setSequenceNumberName("Agg_Child_Seq");
        descriptor.setAlias("Child");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("AGG_CHILD.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping parentMapping = new OneToOneMapping();
        parentMapping.setAttributeName("parent");
        parentMapping.setReferenceClass(Parent.class);
        parentMapping.dontUseIndirection();
        parentMapping.addForeignKeyFieldName("AGG_CHILD.PARENT_ID", "AGG_PARENT.P_ID");
        descriptor.addMapping((DatabaseMapping)parentMapping);
        return descriptor;
    }

    public ClassDescriptor buildCousinClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Cousin.class);
        descriptor.addTableName("AGG_COUSIN");
        descriptor.addPrimaryKeyFieldName("AGG_COUSIN.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("AGG_COUSIN.ID");
        descriptor.setSequenceNumberName("Agg_Cousin_Seq");
        descriptor.setAlias("Cousin");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("AGG_COUSIN.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("AGG_COUSIN.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        return descriptor;
    }

    public ClassDescriptor buildParentClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Parent.class);
        descriptor.addTableName("AGG_PARENT");
        descriptor.addPrimaryKeyFieldName("AGG_PARENT.P_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("AGG_PARENT.P_ID");
        descriptor.setSequenceNumberName("Agg_Parent_Seq");
        descriptor.setAlias("Parent");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("AGG_PARENT.P_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        AggregateObjectMapping aggregateMapping = new AggregateObjectMapping();
        aggregateMapping.setAttributeName("aggregate");
        aggregateMapping.setReferenceClass(Aggregate.class);
        aggregateMapping.setIsNullAllowed(false);
        aggregateMapping.addFieldNameTranslation("AGG_PARENT.P_ID", "relatives->P_ID_IN_REFERENCE_RELATIVE_TO_PARENT");
        aggregateMapping.addFieldNameTranslation("AGG_PARENT.P_ID", "children->P_ID_IN_REFERENCE_CHILD_PARENT");
        aggregateMapping.addFieldNameTranslation("AGG_PARENT.P_ID", "nicknames->P_ID_IN_REFERENCE_NICKNAME_PARENT");
        aggregateMapping.addFieldNameTranslation("AGG_PARENT.COUSIN_ID", "cousin->COUSIN_ID_IN_REFERENCE_PARENT_COUSIN");
        aggregateMapping.addFieldNameTranslation("AGG_PARENT.P_ID", "stepChild->PARENT_ID_IN_REFERENCE_STEPCHILD_PARENT");
        descriptor.addMapping((DatabaseMapping)aggregateMapping);
        return descriptor;
    }

    public ClassDescriptor buildRelativeClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Relative.class);
        descriptor.addTableName("AGG_RELATIVE");
        descriptor.addPrimaryKeyFieldName("AGG_RELATIVE.REL_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("AGG_RELATIVE.REL_ID");
        descriptor.setSequenceNumberName("Agg_Relative_Seq");
        descriptor.setAlias("Relative");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("AGG_RELATIVE.REL_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("AGG_RELATIVE.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        return descriptor;
    }

    public ClassDescriptor buildStepChildClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(StepChild.class);
        descriptor.addTableName("AGG_STEPCHILD");
        descriptor.addPrimaryKeyFieldName("AGG_STEPCHILD.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("AGG_STEPCHILD.ID");
        descriptor.setSequenceNumberName("Agg_StepChild_Seq");
        descriptor.setAlias("StepChild");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("AGG_STEPCHILD.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping parentMapping = new OneToOneMapping();
        parentMapping.setAttributeName("parent");
        parentMapping.setReferenceClass(Parent.class);
        parentMapping.dontUseIndirection();
        parentMapping.addForeignKeyFieldName("AGG_STEPCHILD.PARENT_ID", "AGG_PARENT.P_ID");
        descriptor.addMapping((DatabaseMapping)parentMapping);
        return descriptor;
    }
}

