/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.flashback;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.AsOfSCNClause;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.clientserver.ClientSessionTestAdapter;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.expressions.ExpressionSubSelectTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ReadAllExpressionTest;
import org.eclipse.persistence.testing.tests.flashback.FlashbackUnitTestSuite;
import org.eclipse.persistence.testing.tests.flashback.HistoricalSessionTest;
import org.eclipse.persistence.testing.tests.sessionbroker.ClientSessionBrokerTestAdapter;

public class FlashbackTestModel
extends TestModel {
    protected Number systemChangeNumber;
    public static Timestamp timestamp;
    protected AsOfClause asOfClause;
    public static final boolean QUICK_SETUP = true;
    public static final boolean STANDARD_SETUP = true;

    public FlashbackTestModel() {
        this.setDescription("Tests the new flashback query tests.  Includes running the expression test suite as of a past time.");
    }

    public Expression adaptExpression(Expression expression) {
        return expression.asOf(this.getAsOfClause());
    }

    public void adaptQuery(ObjectLevelReadQuery query) {
        if (this.getSystemChangeNumber() != null) {
            query.setAsOfClause(this.getAsOfClause());
        }
    }

    public Session adaptSession(Session session) {
        return session.acquireHistoricalSession(this.getAsOfClause());
    }

    public void addTests() {
        int i;
        HistoricalSessionTest hsTest;
        AutoVerifyTestCase wrappedTest;
        ExpressionTestSuite expressionTestSuite = new ExpressionTestSuite();
        Iterator iter = expressionTestSuite.getTests().iterator();
        while (iter.hasNext()) {
            TestEntity baseTest = (TestEntity)iter.next();
            if (baseTest instanceof ReadAllExpressionTest) {
                ReadAllExpressionTest test = (ReadAllExpressionTest)baseTest;
                if (test.getExpression() == null) {
                    iter.remove();
                    continue;
                }
                if (test.getReferenceClass().getPackage() != Employee.class.getPackage()) {
                    iter.remove();
                    continue;
                }
                test.getQuery(true).dontMaintainCache();
                test.getQuery().cascadeAllParts();
                test.getExpression().getBuilder().asOf(this.getAsOfClause());
                continue;
            }
            iter.remove();
        }
        this.addTest((Test)expressionTestSuite);
        ExpressionSubSelectTestSuite subSelectTestSuite = new ExpressionSubSelectTestSuite();
        subSelectTestSuite.setExecutor(this.getExecutor());
        Iterator iter2 = subSelectTestSuite.getTests().iterator();
        while (iter2.hasNext()) {
            TestEntity baseTest = (TestEntity)iter2.next();
            if (baseTest instanceof ReadAllExpressionTest) {
                ReadAllExpressionTest test = (ReadAllExpressionTest)baseTest;
                if (test.getExpression() == null) {
                    iter2.remove();
                    continue;
                }
                if (test.getReferenceClass().getPackage() != Employee.class.getPackage() || test.getName().equals("SubSelectCustomSQLTest")) {
                    iter2.remove();
                    continue;
                }
                test.getQuery(true).dontMaintainCache();
                test.getQuery().cascadeAllParts();
                test.getExpression().asOf(this.getAsOfClause());
                continue;
            }
            iter2.remove();
        }
        this.addTest((Test)subSelectTestSuite);
        TestSuite suite = EmployeeBasicTestModel.getReadObjectTestSuite();
        suite.setDescription("Tests object relationships in a HistoricalSession.");
        Vector suiteTests = suite.getTests();
        Vector<Object> newTests = new Vector<Object>(suiteTests.size());
        int numTests = suiteTests.size();
        for (int i2 = 0; i2 < numTests; ++i2) {
            wrappedTest = (AutoVerifyTestCase)suiteTests.get(i2);
            if (wrappedTest.getName().indexOf("Call") > 0) continue;
            hsTest = new HistoricalSessionTest(wrappedTest, this.getAsOfClause());
            newTests.add((Object)hsTest);
        }
        suiteTests.clear();
        suiteTests.addAll(newTests);
        this.addTest((Test)suite);
        suite = EmployeeBasicTestModel.getReadObjectTestSuite();
        suite.setName("AnySessionsTestSuite");
        suite.setDescription("Tests flashback on other session setups.");
        suiteTests = suite.getTests();
        newTests = new Vector(suiteTests.size());
        numTests = suiteTests.size();
        boolean oneForYou = false;
        for (i = 0; i < numTests; ++i) {
            wrappedTest = (AutoVerifyTestCase)suiteTests.get(i);
            if (wrappedTest.getName().indexOf("Call") > 0) continue;
            hsTest = new HistoricalSessionTest(wrappedTest, this.getAsOfClause());
            if (oneForYou) {
                ClientSessionTestAdapter csTest = new ClientSessionTestAdapter((TestCase)hsTest);
                newTests.add((Object)csTest);
            } else {
                ClientSessionBrokerTestAdapter csbTest = new ClientSessionBrokerTestAdapter((TestCase)hsTest);
                newTests.add((Object)csbTest);
            }
            oneForYou = !oneForYou;
        }
        suiteTests.clear();
        suiteTests.addAll(newTests);
        this.addTest((Test)suite);
        suite = EmployeeBasicTestModel.getReadAllTestSuite();
        suiteTests = suite.getTests();
        newTests.clear();
        numTests = suiteTests.size();
        for (i = 0; i < numTests; ++i) {
            wrappedTest = (AutoVerifyTestCase)suiteTests.get(i);
            if (wrappedTest.getName().indexOf("Call") > 0) continue;
            hsTest = new HistoricalSessionTest(wrappedTest, this.getAsOfClause());
            newTests.add((Object)hsTest);
        }
        suiteTests.clear();
        suiteTests.addAll(newTests);
        this.addTest((Test)suite);
        FlashbackUnitTestSuite flashbackSuite = new FlashbackUnitTestSuite();
        flashbackSuite.setExecutor(this.getExecutor());
        this.addTest((Test)flashbackSuite);
    }

    public void buildAsOfClause() {
        this.asOfClause = this.getSystemChangeNumber() != null ? new AsOfSCNClause(this.getSystemChangeNumber()) : new AsOfClause(FlashbackTestModel.getTimestamp());
    }

    protected void calculateSystemChangeNumber() throws Exception {
        OraclePlatform platform = (OraclePlatform)this.getSession().getPlatform();
        ValueReadQuery scnQuery = platform.getSystemChangeNumberQuery();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        int safetyCount = 1400;
        boolean validSCN = false;
        while (safetyCount-- > 0 && !validSCN) {
            this.systemChangeNumber = (Number)this.getSession().executeQuery((DatabaseQuery)scnQuery);
            query.setAsOfClause((AsOfClause)new AsOfSCNClause(this.systemChangeNumber));
            try {
                Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
                validSCN = true;
            }
            catch (Exception e) {
                Thread.sleep(30000L);
            }
        }
    }

    public void calculateTimestamp() {
        if (FlashbackTestModel.getTimestamp() == null) {
            OraclePlatform platform = (OraclePlatform)this.getSession().getPlatform();
            ValueReadQuery timestampQuery = platform.getTimestampQuery();
            ReadAllQuery query = new ReadAllQuery(Employee.class);
            query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").notEqual((Object)"Eun Kyung"));
            ReadAllQuery clonedQuery = null;
            int safetyCount = 1400;
            while (safetyCount-- > 0 && FlashbackTestModel.getTimestamp() == null) {
                Date timestamp = (Date)this.getSession().executeQuery((DatabaseQuery)timestampQuery);
                clonedQuery = query;
                clonedQuery.setAsOfClause(new AsOfClause(timestamp));
                Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)clonedQuery);
                if (result.size() == 12) {
                    FlashbackTestModel.setTimestamp((Timestamp)timestamp);
                    continue;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    throw new TestErrorException("Unable to wait for valid timstamp.", (Throwable)e);
                }
            }
        }
    }

    public void calculateTimestampHopefully() {
        if (FlashbackTestModel.getTimestamp() != null) {
            return;
        }
        OraclePlatform platform = (OraclePlatform)this.getSession().getPlatform();
        ValueReadQuery timestampQuery = platform.getTimestampQuery();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.dontMaintainCache();
        query.addPartialAttribute("id");
        ReadObjectQuery asOfQuery = null;
        try {
            long asOfTime = ((Timestamp)this.getSession().executeQuery((DatabaseQuery)timestampQuery)).getTime();
            long timeToGoBack = 0L;
            while (FlashbackTestModel.getTimestamp() == null) {
                asOfQuery = (ReadObjectQuery)query.clone();
                asOfQuery.setAsOfClause(new AsOfClause(new Timestamp(asOfTime - timeToGoBack)));
                if (this.getSession().executeQuery((DatabaseQuery)asOfQuery) != null) {
                    FlashbackTestModel.setTimestamp(new Timestamp(asOfTime - timeToGoBack));
                    continue;
                }
                timeToGoBack += timeToGoBack == 0L ? 60000L : timeToGoBack;
            }
        }
        catch (Exception e) {
            System.out.println("Went too far back, so can't tell this.");
        }
    }

    private void configure() throws Exception {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("Flashback is only supported on Oracle 9R2 or later databases.");
        }
        EmployeeSystem system = new EmployeeSystem();
        system.run(this.getSession());
        System.out.println("Starting to sleep for 5 seconds.");
        Thread.sleep(5000L);
        System.out.println("Have stopped sleeping for 5 seconds.");
        this.calculateSystemChangeNumber();
        this.buildAsOfClause();
        this.depopulate();
    }

    public void depopulate() throws Exception {
        this.depopulate(false);
    }

    public void depopulate(boolean fully) throws Exception {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Vector employees = uow.readAllObjects(Employee.class);
            Vector projects = uow.readAllObjects(LargeProject.class);
            Vector smallProjects = uow.readAllObjects(SmallProject.class);
            Vector addresses = uow.readAllObjects(Address.class);
            Enumeration enumtr = employees.elements();
            while (enumtr.hasMoreElements()) {
                Employee emp = (Employee)enumtr.nextElement();
                emp.setProjects(null);
                emp.setManager(null);
                emp.setManagedEmployees(new Vector());
                emp.setAddress(null);
            }
            enumtr = projects.elements();
            while (enumtr.hasMoreElements()) {
                LargeProject project = (LargeProject)enumtr.nextElement();
                project.setTeamLeader(null);
            }
            uow.deleteAllObjects((Collection)employees);
            if (fully) {
                uow.deleteAllObjects((Collection)projects);
                uow.deleteAllObjects((Collection)smallProjects);
                uow.deleteAllObjects((Collection)addresses);
            }
            uow.commit();
        }
        catch (EclipseLinkException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("Could not depopulate table.");
            System.out.println("Exception:" + e);
            e.printStackTrace();
        }
    }

    public Number getSystemChangeNumber() {
        return this.systemChangeNumber;
    }

    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public static Timestamp getTimestamp() {
        return timestamp;
    }

    public static long getTimestampValue() {
        return FlashbackTestModel.getTimestamp().getTime();
    }

    public void setAsOfClause(AsOfClause asOfClause) {
        this.asOfClause = asOfClause;
    }

    public static void setTimestamp(Timestamp newTimestamp) {
        timestamp = newTimestamp;
    }

    public void setup() {
        if (FlashbackTestModel.getTimestamp() != null) {
            return;
        }
        try {
            this.configure();
        }
        catch (EclipseLinkException te) {
            throw te;
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void reset() {
        if (FlashbackTestModel.getTimestamp() == null) {
            return;
        }
        try {
            EmployeeSystem system = new EmployeeSystem();
            system.populate((DatabaseSession)this.getSession());
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

