/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class DeepModifyTest
extends AutoVerifyTestCase {
    protected Employee m_employeeFromDatabase;
    protected Number m_nManagedEmployeeID;

    protected void setup() {
        this.beginTransaction();
        ExpressionBuilder expBldr = new ExpressionBuilder();
        Expression whatWeWant = expBldr.get("lastName").equal((Object)"May");
        this.m_employeeFromDatabase = (Employee)this.getSession().readObject(Employee.class, whatWeWant);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() {
        ((Employee)this.m_employeeFromDatabase.getManagedEmployees().elementAt(0)).setFirstName("MrFoobar");
        this.m_nManagedEmployeeID = ((Employee)this.m_employeeFromDatabase.getManagedEmployees().elementAt(0)).getId();
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setObject((Object)this.m_employeeFromDatabase);
        query.cascadeAllParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        Expression expression = new ExpressionBuilder().get("id").equal(this.m_nManagedEmployeeID.intValue());
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee managedEmployee = (Employee)this.getSession().readObject(Employee.class, expression);
        if (!managedEmployee.getFirstName().equals("MrFoobar")) {
            throw new TestErrorException("The deep modify test failed.  The non-private members were not modified");
        }
    }
}

