/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DynamicSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.ParameterizedSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;

public class ErrorOnInsertTest
extends AutoVerifyTestCase {
    public Employee mary;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        if (this.getSession().isClientSession() || this.getSession().isDistributedSession()) {
            throw new TestWarningException("Unable to trigger error in ClientSession or Remote UnitOfWork");
        }
        this.mary = new Employee();
        this.mary.setFirstName("Mary");
        this.mary.setLastName("Magdalene");
        this.mary.setId(new BigDecimal(100002929));
        this.mary.setPeriod(new EmploymentPeriod(new Date(3L), new Date(3455L)));
        UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        DatabaseAccessor accessor = (DatabaseAccessor)uow.getParent().getAccessor();
        uow.getParent().setAccessor((Accessor)new DummyAccessor(accessor));
        Employee maryClone = (Employee)uow.registerObject((Object)this.mary);
        UnitOfWorkChangeSet uowcs = (UnitOfWorkChangeSet)uow.getCurrentChanges();
        try {
            uow.commitAndResumeWithPreBuiltChangeSet(uowcs);
        }
        catch (Exception ex) {
            // empty catch block
        }
        uow.revertAndResume();
        uow.getParent().setAccessor((Accessor)accessor);
        try {
            uow.commitAndResumeWithPreBuiltChangeSet(uowcs);
        }
        catch (QueryException ex) {
            if (ex.getErrorCode() == 6004) {
                throw new TestErrorException("New Object was not inserted because cachekey was not removed");
            }
            throw ex;
        }
        uow.commit();
    }

    public void reset() {
        try {
            this.getDatabaseSession().deleteObject((Object)this.mary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected class DummyAccessor
    extends DatabaseAccessor {
        public DummyAccessor(DatabaseAccessor accessor) {
            this.datasourceConnection = accessor.getDatasourceConnection();
            this.login = accessor.getLogin();
            this.callCount = accessor.getCallCount();
            this.isInTransaction = accessor.isInTransaction();
            this.isConnected = accessor.isConnected();
            this.platform = accessor.getPlatform();
            this.activeBatchWritingMechanism = accessor.getActiveBatchWritingMechanism();
            this.dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism((DatabaseAccessor)this);
            this.parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism((DatabaseAccessor)this);
            this.lobWriter = accessor.getLOBWriter();
        }

        public void basicCommitTransaction(AbstractSession session) throws DatabaseException {
            throw DatabaseException.databaseAccessorNotConnected();
        }
    }
}

