/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.deployment;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.persistence.internal.jpa.deployment.osgi.CompositeEnumeration;

public class CompositeEnumerationTest
extends TestCase {
    public void testNone() throws Exception {
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector());
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testOneWithOne() throws Exception {
        Vector<Integer> v1 = this.createVector(1, 1);
        Vector<Enumeration<Integer>> enumerations = new Vector<Enumeration<Integer>>();
        enumerations.add(v1.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "first", 1);
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testOneWithTwo() throws Exception {
        Vector<Integer> v1 = this.createVector(1, 2);
        Vector<Enumeration<Integer>> enumerations = new Vector<Enumeration<Integer>>();
        enumerations.add(v1.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "first", 1);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "second", 2);
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testThreeWithTwo() throws Exception {
        Vector<Integer> v1 = this.createVector(1, 2);
        Vector<Integer> v2 = this.createVector(3, 4);
        Vector<Integer> v3 = this.createVector(5, 6);
        Vector<Enumeration<Integer>> enumerations = new Vector<Enumeration<Integer>>();
        enumerations.add(v1.elements());
        enumerations.add(v2.elements());
        enumerations.add(v3.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "first", 1);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "second", 2);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "third", 3);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "fourth", 4);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "fifth", 5);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "sixth", 6);
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testEmptyFirst() throws Exception {
        Vector v1 = new Vector();
        Vector<Integer> v2 = this.createVector(1, 1);
        Vector<Integer> v3 = this.createVector(2, 2);
        Vector enumerations = new Vector();
        enumerations.add(v1.elements());
        enumerations.add(v2.elements());
        enumerations.add(v3.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "first", 1);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "second", 2);
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testEmptyLast() throws Exception {
        Vector<Integer> v1 = this.createVector(1, 1);
        Vector<Integer> v2 = this.createVector(2, 2);
        Vector v3 = new Vector();
        Vector enumerations = new Vector();
        enumerations.add(v1.elements());
        enumerations.add(v2.elements());
        enumerations.add(v3.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "first", 1);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "second", 2);
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testEmptyMiddle() throws Exception {
        Vector<Integer> v1 = this.createVector(1, 1);
        Vector v2 = new Vector();
        Vector<Integer> v3 = this.createVector(2, 2);
        Vector enumerations = new Vector();
        enumerations.add(v1.elements());
        enumerations.add(v2.elements());
        enumerations.add(v3.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "first", 1);
        this.assertHasElement((CompositeEnumeration<Integer>)compositeEnumeration, "second", 2);
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    public void testAllEmpty() throws Exception {
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        Vector v3 = new Vector();
        Vector enumerations = new Vector();
        enumerations.add(v1.elements());
        enumerations.add(v2.elements());
        enumerations.add(v3.elements());
        CompositeEnumeration compositeEnumeration = new CompositeEnumeration(new Vector(enumerations));
        this.assertNoMoreElements((CompositeEnumeration<Integer>)compositeEnumeration);
    }

    private void assertHasElement(CompositeEnumeration<Integer> compositeEnumeration, String elementName, int expectedElement) {
        CompositeEnumerationTest.assertTrue((boolean)compositeEnumeration.hasMoreElements());
        Integer nextElement = (Integer)compositeEnumeration.nextElement();
        CompositeEnumerationTest.assertSame((String)(elementName + " element"), (Object)expectedElement, (Object)nextElement);
    }

    private void assertNoMoreElements(CompositeEnumeration<Integer> compositeEnumeration) {
        CompositeEnumerationTest.assertFalse((boolean)compositeEnumeration.hasMoreElements());
        try {
            compositeEnumeration.nextElement();
            CompositeEnumerationTest.fail((String)"NoNoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private Vector<Integer> createVector(int from, int to) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = from; i <= to; ++i) {
            vector.add(i);
        }
        return vector;
    }
}

