/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceProvider;
import junit.framework.Test;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaCache;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.LargeProject;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.performance.SmallProject;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver;

public class JPAPerformanceComparisonModel
extends TestModel {
    public JPAPerformanceComparisonModel() {
        this.setDescription("Performance tests that compare JPA performance.");
    }

    public void addTests() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadingSuite");
        suite.addTest((Test)this.buildReadAllVsReadAllResultSet());
        suite.addTest((Test)this.buildBatchFetchTest());
        suite.addTest((Test)this.buildLoadTest());
        this.addTest((Test)suite);
        suite = new TestSuite();
        suite.setName("WritingSuite");
        suite.addTest((Test)this.buildBatchWriteTest());
        suite.addTest((Test)this.buildBatchUpdateTest());
        this.addTest((Test)suite);
    }

    public void setup() {
        int j;
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EmulatedDriver.emulate = false;
        EntityManager manager = this.getExecutor().createEntityManager();
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
        manager.getTransaction().begin();
        for (j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            manager.persist((Object)empInsert);
        }
        for (j = 0; j < 50; ++j) {
            SmallProject project = new SmallProject();
            project.setName("Tracker");
            manager.persist((Object)project);
            project = new LargeProject();
            project.setName("Tracker");
            manager.persist((Object)project);
        }
        manager.getTransaction().commit();
        manager.close();
        EmulatedDriver.emulate = true;
    }

    public void setupProvider() {
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    public Map getPersistenceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("eclipselink.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        properties.put("eclipselink.sequencing.default-sequence-to-table", "true");
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        return properties;
    }

    public TestCase buildReadAllVsReadAllResultSet() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            ReadAllQuery query;
            ReadAllQuery resultSetQuery;

            public void setup() {
                this.query = new ReadAllQuery(Address.class);
                this.resultSetQuery = new ReadAllQuery(Address.class);
                this.resultSetQuery.setIsResultSetOptimizedQuery(true);
                if (!this.getTests().isEmpty()) {
                    return;
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        EntityManager em = this.createEntityManager();
                        ((JpaEntityManager)em).createQuery((DatabaseQuery)resultSetQuery).getResultList();
                        em.close();
                    }
                };
                test.setName("ReadAllResultSet");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void startTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(4);
                        em.close();
                    }

                    public void test() {
                        EntityManager em = this.createEntityManager();
                        ((JpaEntityManager)em).createQuery((DatabaseQuery)query).getResultList();
                        em.close();
                    }

                    public void endTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.SHARED);
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(1);
                        em.close();
                    }
                };
                test.setName("ReadAllNoCache");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void startTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(4);
                        em.close();
                    }

                    public void test() {
                        EntityManager em = this.createEntityManager();
                        ((JpaEntityManager)em).createQuery((DatabaseQuery)resultSetQuery).getResultList();
                        em.close();
                    }

                    public void endTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.SHARED);
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(1);
                        em.close();
                    }
                };
                test.setName("ReadAllResultSetNoCache");
                this.addTest((TestCase)test);
            }

            public void test() throws Exception {
                EntityManager em = this.createEntityManager();
                ((JpaEntityManager)em).createQuery((DatabaseQuery)this.query).getResultList();
                em.close();
            }
        };
        test.setName("ReadAllVsReadAllResultSet");
        return test;
    }

    public TestCase buildBatchFetchTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void setup() {
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(4);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(4);
                ((Session)this.createEntityManager().unwrap(Session.class)).getProject().setHasIsolatedClasses(true);
                if (!this.getTests().isEmpty()) {
                    return;
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesBatch");
                    }
                };
                test.setName("BatchFetchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesBatchEXISTS");
                    }
                };
                test.setName("EXISTSBatchFetchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesBatchIN");
                    }
                };
                test.setName("INBatchFetchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesJoin");
                    }
                };
                test.setName("JoinFetchTest");
                this.addTest((TestCase)test);
            }

            public void test() throws Exception {
                JPAPerformanceComparisonModel.this.testQuery("findAllEmployees");
            }

            public void reset() {
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setCacheIsolation(CacheIsolationType.SHARED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(1);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.SHARED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(1);
                ((Session)this.createEntityManager().unwrap(Session.class)).getProject().setHasIsolatedClasses(false);
            }
        };
        test.setName("BatchFetchTest");
        return test;
    }

    public TestCase buildLoadTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void setup() {
                if (!this.getTests().isEmpty()) {
                    return;
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesLoad");
                        ((JpaCache)this.getExecutor().getEntityManagerFactory().getCache()).clear();
                    }
                };
                test.setName("LoadTest");
                this.addTest((TestCase)test);
            }

            public void test() throws Exception {
                JPAPerformanceComparisonModel.this.testQuery("findAllEmployees");
                ((JpaCache)this.getExecutor().getEntityManagerFactory().getCache()).clear();
            }

            public void reset() {
            }
        };
        test.setName("LoadTest");
        return test;
    }

    protected void testQuery(String query) {
        EntityManager em = this.getExecutor().createEntityManager();
        List employees = em.createNamedQuery(query).getResultList();
        for (Employee employee : employees) {
            employee.getAddress().toString();
        }
        em.close();
    }

    public TestCase buildThreadCursorTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void setup() {
                if (!this.getTests().isEmpty()) {
                    return;
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testJPQL("Select a from Address a");
                    }
                };
                test.setName("ReadAllTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void startTest() {
                    }

                    public void test() {
                        JPAPerformanceComparisonModel.this.testJPQL("Select a from Address a");
                    }
                };
                test.setName("ThreadCursorReadAllTest");
                this.addTest((TestCase)test);
            }

            public void test() throws Exception {
                JPAPerformanceComparisonModel.this.testQuery("findAllEmployees");
            }
        };
        test.setName("ThreadCursorTest");
        return test;
    }

    protected void testJPQL(String query) {
        EntityManager em = this.getExecutor().createEntityManager();
        em.createNamedQuery(query).getResultList().size();
        em.close();
    }

    public TestCase buildBatchWriteTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            int objects = 50;
            boolean originalCacheStatements;

            public void setup() {
                this.originalCacheStatements = ((ServerSession)this.getExecutor().createEntityManager().unwrap(ServerSession.class)).getLogin().shouldCacheAllStatements();
                ((ServerSession)this.getExecutor().createEntityManager().unwrap(ServerSession.class)).getLogin().cacheAllStatements();
                if (!this.getTests().isEmpty()) {
                    this.getTests().clear();
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        try {
                            em.getTransaction().begin();
                            this.persistBatch(em);
                            em.getTransaction().commit();
                        }
                        finally {
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                            em.close();
                        }
                    }
                };
                test.setName("JDBCBatchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontBindAllParameters();
                        try {
                            em.getTransaction().begin();
                            this.persistBatch(em);
                            em.getTransaction().commit();
                        }
                        finally {
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().bindAllParameters();
                            em.close();
                        }
                    }
                };
                test.setName("DynamicSQLTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontCacheAllStatements();
                        try {
                            em.getTransaction().begin();
                            this.persistBatch(em);
                            em.getTransaction().commit();
                        }
                        finally {
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().cacheAllStatements();
                            em.close();
                        }
                    }
                };
                test.setName("NoStatementCachingTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontBindAllParameters();
                        try {
                            em.getTransaction().begin();
                            this.persistBatch(em);
                            em.getTransaction().commit();
                        }
                        finally {
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().bindAllParameters();
                            em.close();
                        }
                    }
                };
                test.setName("DynamicBatchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseJDBCBatchWriting();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontBindAllParameters();
                        try {
                            em.getTransaction().begin();
                            this.persistBatch(em);
                            em.getTransaction().commit();
                        }
                        finally {
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useJDBCBatchWriting();
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().bindAllParameters();
                            em.close();
                        }
                    }
                };
                test.setName("BufferedBatchTest");
                test = new PerformanceComparisonTestCase(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        DatabaseAccessor accessor = null;
                        try {
                            em.getTransaction().begin();
                            this.persistBatch(em);
                            UnitOfWorkImpl uow = (UnitOfWorkImpl)em.unwrap(UnitOfWork.class);
                            uow.beginEarlyTransaction();
                            accessor = (DatabaseAccessor)uow.getAccessor();
                            em.getTransaction().commit();
                        }
                        finally {
                            ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                            em.close();
                            if (accessor != null) {
                                accessor.setActiveBatchWritingMechanism(null);
                            }
                        }
                    }
                };
                test.setName("DynamicParameterizedBatchTest");
            }

            public void test() throws Exception {
                EntityManager em = this.getExecutor().createEntityManager();
                em.getTransaction().begin();
                this.persistBatch(em);
                em.getTransaction().commit();
                em.close();
            }

            public void persistBatch(EntityManager em) {
                for (int index = 0; index < this.objects; ++index) {
                    Address address = new Address();
                    address.setStreet("100 Bank Street");
                    address.setProvince("ON");
                    address.setPostalCode("K2H8C5");
                    address.setCity("Ottawa");
                    address.setCountry("Canada");
                    em.persist((Object)address);
                }
            }

            public void reset() {
                EntityManager em = this.getExecutor().createEntityManager();
                em.getTransaction().begin();
                em.createQuery("Delete from Address a where a.street = '100 Bank Street'").executeUpdate();
                em.getTransaction().commit();
                em.close();
                if (!this.originalCacheStatements) {
                    ((ServerSession)this.getExecutor().createEntityManager().unwrap(ServerSession.class)).getLogin().dontCacheAllStatements();
                }
            }
        };
        test.setName("BatchWriteTest");
        return test;
    }

    public TestCase buildBatchUpdateTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            boolean originalCacheStatements;

            public void setup() {
                this.originalCacheStatements = ((ServerSession)this.getExecutor().createEntityManager().unwrap(ServerSession.class)).getLogin().shouldCacheAllStatements();
                ((ServerSession)this.getExecutor().createEntityManager().unwrap(ServerSession.class)).getLogin().cacheAllStatements();
                if (!this.getTests().isEmpty()) {
                    this.getTests().clear();
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        em.getTransaction().begin();
                        this.persistBatch(em);
                        em.getTransaction().commit();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                        em.close();
                    }
                };
                test.setName("JDBCBatchUpdateTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontBindAllParameters();
                        em.getTransaction().begin();
                        this.persistBatch(em);
                        em.getTransaction().commit();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useJDBCBatchWriting();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().bindAllParameters();
                        em.close();
                    }
                };
                test.setName("DynamicBatchUpdateTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        EntityManager em = this.getExecutor().createEntityManager();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().useBatchWriting();
                        em.getTransaction().begin();
                        this.persistBatch(em);
                        UnitOfWorkImpl uow = (UnitOfWorkImpl)em.unwrap(UnitOfWork.class);
                        uow.beginEarlyTransaction();
                        DatabaseAccessor accessor = (DatabaseAccessor)uow.getAccessor();
                        em.getTransaction().commit();
                        ((ServerSession)em.unwrap(ServerSession.class)).getLogin().dontUseBatchWriting();
                        em.close();
                        accessor.setActiveBatchWritingMechanism(null);
                    }
                };
                test.setName("DynamicParameterizedBatchUpdateTest");
            }

            public void test() throws Exception {
                EntityManager em = this.getExecutor().createEntityManager();
                em.getTransaction().begin();
                this.persistBatch(em);
                em.getTransaction().commit();
                em.close();
            }

            public void persistBatch(EntityManager em) {
                List employees = em.createQuery("Select e from Employee e").getResultList();
                for (Employee employee : employees) {
                    if (employee.getGender().equals("Male")) {
                        employee.setFemale();
                        continue;
                    }
                    employee.setMale();
                }
            }

            public void reset() {
                if (!this.originalCacheStatements) {
                    ((ServerSession)this.getExecutor().createEntityManager().unwrap(ServerSession.class)).getLogin().dontCacheAllStatements();
                }
            }
        };
        test.setName("BatchUpdateTest");
        return test;
    }
}

