/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.merge.incompletemappings.nonowning;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.Address;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.Customer;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.Item;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.Order;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.PartsList;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.RelationshipsTableManager;

public class EntityMappingsIncompleteNonOwningJUnitTestCase
extends JUnitTestCase {
    private static Integer customerId;
    private static Integer itemId;
    private static Integer orderId;

    public EntityMappingsIncompleteNonOwningJUnitTestCase() {
    }

    public EntityMappingsIncompleteNonOwningJUnitTestCase(String name) {
        super(name);
    }

    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Non-owning Model");
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testCreateCustomer"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testCreateItem"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testCreateOrder"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testReadCustomer"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testReadItem"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testReadOrder"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testUpdateCustomer"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testUpdateItem"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testUpdateOrder"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testDeleteOrder"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testDeleteCustomer"));
        suite.addTest((Test)new EntityMappingsIncompleteNonOwningJUnitTestCase("testDeleteItem"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new RelationshipsTableManager().replaceTables((DatabaseSession)session);
        this.clearCache();
    }

    public void testCreateCustomer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer customer = new Customer();
            customer.setName("Joe Black");
            customer.setCity("Austin");
            Address billingAddress = new Address("19 Somestreet", "Anytown", "ON", "Canada", "X0X-0X0");
            billingAddress.setCustomer(customer);
            em.persist((Object)customer);
            customerId = customer.getCustomerId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartsList pl = new PartsList();
            em.persist((Object)pl);
            PartsList pl2 = new PartsList();
            em.persist((Object)pl2);
            ArrayList<PartsList> partsLists = new ArrayList<PartsList>();
            partsLists.add(pl);
            partsLists.add(pl2);
            Item item = new Item();
            item.setName("PartA");
            item.setDescription("This is part of a widget.");
            item.setImage(new byte[1024]);
            item.setPartsLists(partsLists);
            em.persist((Object)item);
            itemId = item.getItemId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateOrder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Order order = new Order();
            order.setShippingAddress("50 O'Connor St.");
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            order.setCustomer(customer);
            order.setQuantity(1);
            Item item = (Item)em.find(Item.class, (Object)itemId);
            order.setItem(item);
            em.persist((Object)order);
            orderId = order.getOrderId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testDeleteCustomer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Customer.class, (Object)customerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error deleting Customer", (em.find(Customer.class, (Object)customerId) == null ? 1 : 0) != 0);
    }

    public void testDeleteItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Item.class, (Object)itemId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error deleting Item", (em.find(Item.class, (Object)itemId) == null ? 1 : 0) != 0);
    }

    public void testDeleteOrder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Order.class, (Object)orderId));
            em.refresh(em.find(Customer.class, (Object)customerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error deleting Order", (em.find(Order.class, (Object)orderId) == null ? 1 : 0) != 0);
    }

    public void testReadCustomer() {
        Customer customer = (Customer)this.createEntityManager().find(Customer.class, (Object)customerId);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error reading Customer", (customer.getCustomerId() == customerId ? 1 : 0) != 0);
    }

    public void testReadItem() {
        Item item = (Item)this.createEntityManager().find(Item.class, (Object)itemId);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error reading Item", (item.getItemId() == itemId ? 1 : 0) != 0);
    }

    public void testReadOrder() {
        Order order = (Order)this.createEntityManager().find(Order.class, (Object)orderId);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error reading Order", (order.getOrderId() == orderId ? 1 : 0) != 0);
    }

    public void testUpdateCustomer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            customer.setCity("Dallas");
            em.merge((Object)customer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Customer newCustomer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error updating Customer", (boolean)newCustomer.getCity().equals("Dallas"));
    }

    public void testUpdateItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartsList pl = new PartsList();
            em.persist((Object)pl);
            ArrayList<PartsList> partsLists = new ArrayList<PartsList>();
            partsLists.add(pl);
            Item item = (Item)em.find(Item.class, (Object)itemId);
            item.setDescription("A Widget");
            item.setImage(new byte[1280]);
            item.setPartsLists(partsLists);
            em.merge((Object)item);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Item newItem = (Item)em.find(Item.class, (Object)itemId);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error updating Item description", (boolean)newItem.getDescription().equals("A Widget"));
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error updating Item image", (newItem.getImage().length == 1280 ? 1 : 0) != 0);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error updating Item parts lists", (newItem.getPartsLists().size() != 1 ? 1 : 0) != 0);
    }

    public void testUpdateOrder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            Order order = (Order)customer.getOrders().iterator().next();
            order.setQuantity(100);
            em.merge((Object)customer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Customer newCustomer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsIncompleteNonOwningJUnitTestCase.assertTrue((String)"Error updating Customer", (((Order)newCustomer.getOrders().iterator().next()).getQuantity() == 100 ? 1 : 0) != 0);
    }
}

