/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;

public class BaseType
extends FieldType {
    private int code;
    private Class javaClass;

    BaseType(int code) {
        this.code = code;
        this.javaClass = BaseType.javaClass(code);
    }

    private static Class javaClass(int code) {
        switch (code) {
            case 66: {
                return Byte.TYPE;
            }
            case 67: {
                return Character.TYPE;
            }
            case 68: {
                return Double.TYPE;
            }
            case 70: {
                return Float.TYPE;
            }
            case 73: {
                return Integer.TYPE;
            }
            case 74: {
                return Long.TYPE;
            }
            case 83: {
                return Short.TYPE;
            }
            case 90: {
                return Boolean.TYPE;
            }
            case 86: {
                return Void.TYPE;
            }
        }
        throw new IllegalArgumentException("invalid code: " + (char)code);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int arrayDepth() {
        return 0;
    }

    @Override
    public String elementTypeName() {
        return this.javaClass.getName();
    }

    @Override
    public String javaName() {
        return this.javaClass.getName();
    }

    @Override
    public Class javaClass() {
        return this.javaClass;
    }

    @Override
    public void appendDeclarationTo(StringBuffer sb) {
        sb.append(this.javaClass.getName());
    }

    @Override
    public void printDeclarationOn(PrintWriter writer) {
        writer.print(this.javaClass.getName());
    }

    @Override
    public String internalName() {
        return String.valueOf((char)this.code);
    }

    @Override
    void appendArrayJavaNameTo(StringBuffer sb) {
        sb.append((char)this.code);
    }

    @Override
    void appendArrayInternalNameTo(StringBuffer sb) {
        sb.append((char)this.code);
    }
}

