/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ExhaustivePartialStringComparatorEngine
implements PartialStringComparatorEngine {
    private final PartialStringComparator partialStringComparator;

    public ExhaustivePartialStringComparatorEngine(PartialStringComparator partialStringComparator) {
        this.partialStringComparator = partialStringComparator;
    }

    @Override
    public PartialStringComparatorEngine.StringHolderPair[] match(StringHolder[] stringHolders1, StringHolder[] stringHolders2) {
        PartialStringComparatorEngine.StringHolderPair[] stringHolderPairs = this.buildStringHolderPairs(stringHolders1, stringHolders2);
        this.calculateScores((InternalStringHolderPair[])stringHolderPairs, stringHolders2);
        this.setString2((InternalStringHolderPair[])stringHolderPairs, stringHolders2);
        return stringHolderPairs;
    }

    private InternalStringHolderPair[] buildStringHolderPairs(StringHolder[] stringHolders1, StringHolder[] stringHolders2) {
        int i;
        int len1 = stringHolders1.length;
        int len2 = stringHolders2.length;
        int len = Math.max(len1, len2);
        InternalStringHolderPair[] stringHolderPairs = new InternalStringHolderPair[len];
        for (i = 0; i < len1; ++i) {
            stringHolderPairs[i] = new SimpleInternalStringHolderPair(stringHolders1[i], len2);
        }
        if (len1 < len2) {
            for (i = len1; i < len2; ++i) {
                stringHolderPairs[i] = new NullInternalStringHolderPair();
            }
        }
        return stringHolderPairs;
    }

    private void calculateScores(InternalStringHolderPair[] stringHolderPairs, StringHolder[] stringHolders2) {
        PartialStringComparator psc = this.partialStringComparator;
        int i = stringHolderPairs.length;
        while (i-- > 0) {
            stringHolderPairs[i].calculateScores(psc, stringHolders2);
        }
    }

    private void setString2(InternalStringHolderPair[] stringHolderPairs, StringHolder[] stringHolders2) {
        int stringHolderPairsLength = stringHolderPairs.length;
        InternalStringHolderPair[] stringHolderPairsCopy = new InternalStringHolderPair[stringHolderPairsLength];
        System.arraycopy(stringHolderPairs, 0, stringHolderPairsCopy, 0, stringHolderPairsLength);
        int stringHolders2Length = stringHolders2.length;
        StringHolder[] stringHolders2Copy = new StringHolder[stringHolders2Length];
        System.arraycopy(stringHolders2, 0, stringHolders2Copy, 0, stringHolders2Length);
        int x = stringHolders2Length;
        while (x-- > 0) {
            double maxScore = -2.0;
            int maxIndex = -1;
            int i = stringHolderPairsLength;
            while (i-- > 0) {
                double stringHolderPairScore;
                InternalStringHolderPair stringHolderPair = stringHolderPairsCopy[i];
                if (stringHolderPair == null || !((stringHolderPairScore = stringHolderPair.maxScore()) > maxScore)) continue;
                maxScore = stringHolderPairScore;
                maxIndex = i;
            }
            int stringHolder2Index = stringHolderPairsCopy[maxIndex].setStringHolder2(stringHolders2Copy);
            stringHolders2Copy[stringHolder2Index] = null;
            stringHolderPairsCopy[maxIndex] = null;
            int i2 = stringHolderPairsLength;
            while (i2-- > 0) {
                InternalStringHolderPair stringPair = stringHolderPairsCopy[i2];
                if (stringPair == null) continue;
                stringPair.clearStringHolder2(stringHolder2Index);
            }
        }
        x = stringHolderPairsLength;
        while (x-- > stringHolders2Length) {
            int i = stringHolderPairsLength;
            while (i-- > 0) {
                InternalStringHolderPair stringHolderPair = stringHolderPairsCopy[i];
                if (stringHolderPair == null) continue;
                stringHolderPair.setStringHolder2(null);
            }
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.partialStringComparator);
    }

    private static class SimpleInternalStringHolderPair
    implements InternalStringHolderPair {
        private final StringHolder stringHolder1;
        private StringHolder stringHolder2;
        private double score;
        private double[] scores;
        private double maxScore;
        private int maxScoreIndex;

        SimpleInternalStringHolderPair(StringHolder stringHolder1, int stringHolders2Size) {
            this.stringHolder1 = stringHolder1;
            this.score = -1.0;
            this.scores = new double[stringHolders2Size];
            this.maxScore = -1.0;
            this.maxScoreIndex = -1;
        }

        @Override
        public StringHolder getStringHolder1() {
            return this.stringHolder1;
        }

        @Override
        public StringHolder getStringHolder2() {
            return this.stringHolder2;
        }

        @Override
        public double getScore() {
            return this.score;
        }

        @Override
        public void calculateScores(PartialStringComparator psc, StringHolder[] stringHolders2) {
            String localString1 = this.stringHolder1.getString();
            double[] localScores = this.scores;
            double localMaxScore = this.maxScore;
            int localMaxScoreIndex = this.maxScoreIndex;
            int i = stringHolders2.length;
            while (i-- > 0) {
                double localScore;
                localScores[i] = localScore = psc.compare(localString1, stringHolders2[i].getString());
                if (!(localScore > localMaxScore)) continue;
                localMaxScore = localScore;
                localMaxScoreIndex = i;
            }
            this.maxScore = localMaxScore;
            this.maxScoreIndex = localMaxScoreIndex;
        }

        @Override
        public double maxScore() {
            if (this.maxScore == -1.0) {
                this.recalculateMaxScoreAndIndex();
            }
            return this.maxScore;
        }

        private void recalculateMaxScoreAndIndex() {
            double[] localScores = this.scores;
            double localMaxScore = this.maxScore;
            int localMaxScoreIndex = this.maxScoreIndex;
            int i = localScores.length;
            while (i-- > 0) {
                double localScore = localScores[i];
                if (!(localScore > localMaxScore)) continue;
                localMaxScore = localScore;
                localMaxScoreIndex = i;
            }
            this.maxScore = localMaxScore;
            this.maxScoreIndex = localMaxScoreIndex;
        }

        @Override
        public int setStringHolder2(StringHolder[] stringHolders2) {
            int index = this.maxScoreIndex;
            if (stringHolders2 == null) {
                this.stringHolder2 = null;
                this.score = 0.0;
            } else {
                this.stringHolder2 = stringHolders2[index];
                this.score = this.scores[index];
            }
            this.scores = null;
            this.maxScore = 0.0;
            this.maxScoreIndex = -1;
            return index;
        }

        @Override
        public void clearStringHolder2(int index) {
            this.scores[index] = -1.0;
            this.maxScore = -1.0;
            this.maxScoreIndex = -1;
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.additionalInfo());
        }

        private String additionalInfo() {
            StringBuffer sb = new StringBuffer(200);
            sb.append("\"");
            sb.append(this.stringHolder1.getString());
            sb.append("\" vs. ");
            if (this.stringHolder2 == null) {
                sb.append("<null>");
            } else {
                sb.append('\"');
                sb.append(this.stringHolder2.getString());
                sb.append('\"');
            }
            sb.append(" => ");
            sb.append(this.score);
            return sb.toString();
        }
    }

    private static class NullInternalStringHolderPair
    implements InternalStringHolderPair {
        private StringHolder stringHolder2;

        private NullInternalStringHolderPair() {
        }

        @Override
        public StringHolder getStringHolder1() {
            return null;
        }

        @Override
        public StringHolder getStringHolder2() {
            return this.stringHolder2;
        }

        @Override
        public double getScore() {
            return 0.0;
        }

        @Override
        public void calculateScores(PartialStringComparator psc, StringHolder[] stringHolders2) {
        }

        @Override
        public double maxScore() {
            return -1.0;
        }

        @Override
        public int setStringHolder2(StringHolder[] stringHolders2) {
            int i = stringHolders2.length;
            while (i-- > 0) {
                if (stringHolders2[i] == null) continue;
                this.stringHolder2 = stringHolders2[i];
                return i;
            }
            throw new IllegalStateException("'stringHolders2' is empty");
        }

        @Override
        public void clearStringHolder2(int index) {
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            StringTools.buildSimpleToStringOn(this, sb);
            sb.append(" (");
            sb.append("<null> vs. ");
            if (this.stringHolder2 == null) {
                sb.append("<null>");
            } else {
                sb.append('\"');
                sb.append(this.stringHolder2.getString());
                sb.append('\"');
            }
            sb.append(" => 0");
            sb.append(')');
            return sb.toString();
        }
    }

    private static interface InternalStringHolderPair
    extends PartialStringComparatorEngine.StringHolderPair {
        public void calculateScores(PartialStringComparator var1, StringHolder[] var2);

        public double maxScore();

        public int setStringHolder2(StringHolder[] var1);

        public void clearStringHolder2(int var1);
    }
}

