/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.graphs;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.AttributeGroup;

public class NamedAttributeNodeMetadata
extends ORMetadata {
    protected String m_name;
    protected String m_subgraph;
    protected String m_keySubgraph;

    public NamedAttributeNodeMetadata() {
        super("<named-entity-graph>");
    }

    public NamedAttributeNodeMetadata(MetadataAnnotation namedAttributeNode, ClassAccessor accessor) {
        super(namedAttributeNode, accessor);
        this.m_name = namedAttributeNode.getAttributeString("value");
        this.m_subgraph = namedAttributeNode.getAttributeString("subgraph");
        this.m_keySubgraph = namedAttributeNode.getAttributeString("key-subgraph");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedAttributeNodeMetadata) {
            NamedAttributeNodeMetadata attributeNode = (NamedAttributeNodeMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, attributeNode.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_subgraph, attributeNode.getSubgraph())) {
                return false;
            }
            return this.valuesMatch(this.m_keySubgraph, attributeNode.getKeySubgraph());
        }
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public String getKeySubgraph() {
        return this.m_keySubgraph;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSubgraph() {
        return this.m_subgraph;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Map<String, Map<String, AttributeGroup>> attributeGraphs, AttributeGroup graph, AttributeGroup entityGraph) {
        if (this.getSubgraph() != null) {
            if (!attributeGraphs.containsKey(this.getName())) throw new IllegalArgumentException(ExceptionLocalization.buildMessage("managed_component_not_found", new Object[]{graph.getName(), this.getName(), this.getSubgraph()}));
            graph.addAttribute(this.getName(), attributeGraphs.get(this.getName()).values());
        } else {
            graph.addAttribute(this.getName());
        }
        if (this.getKeySubgraph() == null) return;
        if (!attributeGraphs.containsKey(attributeGraphs.get(entityGraph.getName()))) throw new IllegalArgumentException(ExceptionLocalization.buildMessage("managed_component_not_found", new Object[]{graph.getName(), this.getName(), this.getSubgraph()}));
        entityGraph.getItem(this.getName()).addKeyGroups(attributeGraphs.get(entityGraph.getName()).values());
    }

    public void setKeySubgraph(String keySubgraph) {
        this.m_keySubgraph = keySubgraph;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSubgraph(String subgraph) {
        this.m_subgraph = subgraph;
    }
}

