/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecordImpl;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class MarshalRecord<MARSHALLER extends Marshaller>
extends AbstractMarshalRecordImpl<CoreAbstractSession, DatabaseField, MARSHALLER, NamespaceResolver>
implements org.eclipse.persistence.internal.oxm.record.MarshalRecord<CoreAbstractSession, DatabaseField, MARSHALLER, NamespaceResolver> {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;
    protected XPathFragment textWrapperFragment;
    private CycleDetectionStack<Object> cycleDetectionStack = new CycleDetectionStack();
    private Stack<CoreAttributeGroup> attributeGroupStack;
    protected static final String COLON_W_SCHEMA_NIL_ATTRIBUTE = ":nil";
    protected static final String TRUE = "true";
    private static final Object[] EMPTY_CYCLE_DATA = new Object[8];

    public MarshalRecord() {
        super(null);
        this.namespaceResolver = new NamespaceResolver();
    }

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Node getDOM() {
        return null;
    }

    @Override
    public void addGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements == null) {
            this.groupingElements = new ArrayList(2);
        }
        this.groupingElements.add(xPathNode);
    }

    @Override
    public void removeGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements != null) {
            this.groupingElements.remove(xPathNode);
        }
    }

    public String transformToXML() {
        return null;
    }

    @Override
    public void setSession(CoreAbstractSession session) {
        super.setSession(session);
        if (session != null && session.getDatasourceLogin() instanceof XMLLogin) {
            this.equalNamespaceResolvers = ((XMLLogin)session.getDatasourceLogin()).hasEqualNamespaceResolvers();
        }
    }

    @Override
    public void add(DatabaseField key, Object value) {
        if (value == null) {
            return;
        }
        Field xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        if (lastFragment.nameIsText()) {
            this.characters(xmlField.getSchemaType(), value, null, xmlField.isCDATA());
        } else if (lastFragment.isAttribute()) {
            this.attribute(lastFragment, (NamespaceResolver)xmlField.getNamespaceResolver(), value, xmlField.getSchemaType());
        } else {
            this.element(lastFragment);
        }
    }

    @Override
    public Object put(DatabaseField key, Object value) {
        this.add(key, value);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (namespaceURI != null) {
            this.defaultNamespaceDeclaration(namespaceURI);
        }
        if (namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                String namespacePrefix = entry.getKey();
                this.namespaceDeclaration(namespacePrefix, entry.getValue());
            }
        }
    }

    @Override
    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (openGrouping) {
            XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
            this.closeStartGroupingElements(groupingFragment);
            return true;
        }
        return false;
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
        this.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceURI);
    }

    public void defaultNamespaceDeclaration(String defaultNamespace) {
        this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", defaultNamespace);
    }

    public abstract void startDocument(String var1, String var2);

    public void writeHeader() {
    }

    public abstract void endDocument();

    public void marshalWithoutRootElement(ObjectBuilder treeObjectBuilder, Object object, Descriptor descriptor, Root root, boolean isXMLRoot) {
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null && namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(XPathFragment var1);

    @Override
    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    @Override
    public abstract void attribute(String var1, String var2, String var3, String var4);

    @Override
    public abstract void closeStartElement();

    @Override
    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    @Override
    public abstract void characters(String var1);

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        }
    }

    @Override
    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA) {
        if (mimeType != null) {
            value = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.characters(convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue);
            }
        }
    }

    @Override
    public String getValueToWrite(QName schemaType, Object value, XMLConversionManager xmlConversionManager) {
        if (value == null) {
            return null;
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            return this.getStringForQName((QName)value);
        }
        if (value.getClass() == String.class) {
            return (String)value;
        }
        return (String)xmlConversionManager.convertObject(value, ClassConstants.STRING, schemaType);
    }

    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            if (this.getNamespaceResolver() != null && ((NamespaceResolver)this.getNamespaceResolver()).getDefaultNamespaceURI() != null) {
                this.defaultNamespaceDeclaration(namespaceURI);
            }
            return qName.getLocalPart();
        }
        Object namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(((NamespaceResolver)namespaceResolver).getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = ((NamespaceResolver)namespaceResolver).resolveNamespaceURI(namespaceURI);
        if (prefix == null) {
            prefix = ((NamespaceResolver)namespaceResolver).generatePrefix();
            this.namespaceDeclaration(prefix, namespaceURI);
        }
        if ("".equals(prefix)) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }

    @Override
    public abstract void cdata(String var1);

    @Override
    public void node(Node node, NamespaceResolver resolver) {
        this.node(node, resolver, null, null);
    }

    public abstract void node(Node var1, NamespaceResolver var2, String var3, String var4);

    @Override
    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (this.groupingElements == null) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int x = 0;
        int groupingElementsSize = this.groupingElements.size();
        while (x < groupingElementsSize) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            this.predicateAttribute(xPathFragment, namespaceResolver);
            if (x != groupingElementsSize - 1) {
                this.closeStartElement();
            }
            ++x;
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    @Override
    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (groupingFragment != null) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            String shortName = xPathFragment.getShortName();
            Integer index = (Integer)this.getPositionalNodes().get(shortName);
            int start = index == null ? 1 : index;
            int x = start;
            while (x < xPathFragment.getIndexValue()) {
                this.element(xPathFragment);
                ++x;
            }
            this.getPositionalNodes().put(shortName, xPathFragment.getIndexValue() + 1);
        }
    }

    @Override
    public void beforeContainmentMarshal(Object child) {
        XMLMarshalListener marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            try {
                marshalListener.beforeMarshal(child);
            }
            catch (EclipseLinkException e) {
                ErrorHandler errorHandler = this.marshaller.getErrorHandler();
                if (errorHandler == null) {
                    throw e;
                }
                try {
                    ValidatingMarshalRecord.MarshalSAXParseException saxParseException = new ValidatingMarshalRecord.MarshalSAXParseException(null, null, null, -1, -1, e, child);
                    errorHandler.error(saxParseException);
                }
                catch (SAXException sAXException) {
                    throw e;
                }
            }
        }
        this.setOwningObject(child);
    }

    @Override
    public void afterContainmentMarshal(Object parent, Object child) {
        XMLMarshalListener marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            try {
                marshalListener.afterMarshal(child);
            }
            catch (EclipseLinkException e) {
                ErrorHandler errorHandler = this.marshaller.getErrorHandler();
                if (errorHandler == null) {
                    throw e;
                }
                try {
                    ValidatingMarshalRecord.MarshalSAXParseException saxParseException = new ValidatingMarshalRecord.MarshalSAXParseException(null, null, null, -1, -1, e, child);
                    errorHandler.error(saxParseException);
                }
                catch (SAXException sAXException) {
                    throw e;
                }
            }
        }
        this.setOwningObject(parent);
    }

    @Override
    public ArrayList<XPathNode> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    public void setGroupingElement(ArrayList<XPathNode> elements) {
        this.groupingElements = elements;
    }

    @Override
    public void predicateAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment predicateXPathFragment;
        XPathPredicate predicate;
        if (xPathFragment != null && (predicate = xPathFragment.getPredicate()) != null && (predicateXPathFragment = predicate.getXPathFragment()).isAttribute()) {
            this.attribute(predicateXPathFragment, namespaceResolver, predicate.getValue());
        }
    }

    @Override
    public void startCollection() {
    }

    @Override
    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.attribute(xPathFragment, namespaceResolver, "");
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void emptySimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        StringBuilder qName = new StringBuilder(Constants.ATTRIBUTE.charValue());
        qName.append(xsiPrefix).append(COLON_W_SCHEMA_NIL_ATTRIBUTE);
        XPathFragment nilFragment = new XPathFragment(qName.toString());
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        XPathFragment nilFragment = new XPathFragment(Constants.ATTRIBUTE + xsiPrefix + COLON_W_SCHEMA_NIL_ATTRIBUTE);
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void endCollection() {
    }

    protected String processNamespaceResolverForXSIPrefix(NamespaceResolver namespaceResolver) {
        String xsiPrefix;
        if (namespaceResolver == null) {
            xsiPrefix = "xsi";
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiPrefix == null) {
                xsiPrefix = namespaceResolver.generatePrefix("xsi");
                this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        return xsiPrefix;
    }

    @Override
    public XPathFragment getTextWrapperFragment() {
        return null;
    }

    protected String getNameForFragment(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortName();
        }
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            return String.valueOf(prefix) + ':' + xPathFragment.getLocalName();
        }
        return xPathFragment.getLocalName();
    }

    protected byte[] getNameForFragmentBytes(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortNameBytes();
        }
        String name = xPathFragment.getLocalName();
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            name = String.valueOf(prefix) + ':' + xPathFragment.getLocalName();
        }
        byte[] bytes = null;
        try {
            bytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return bytes;
    }

    protected String getPrefixForFragment(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper) {
            return xPathFragment.getPrefix();
        }
        String uri = xPathFragment.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return "";
        }
        String defaultNamespace = ((NamespaceResolver)this.getNamespaceResolver()).getDefaultNamespaceURI();
        if (defaultNamespace != null && defaultNamespace.equals(uri)) {
            return "";
        }
        String prefix = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(uri);
        if (prefix != null) {
            return prefix;
        }
        for (Object next : ((NamespaceResolver)this.getNamespaceResolver()).getNamespaces()) {
            Namespace ns = (Namespace)next;
            uri = ns.getNamespaceURI();
            prefix = ns.getPrefix();
        }
        return xPathFragment.getPrefix();
    }

    @Override
    public CycleDetectionStack<Object> getCycleDetectionStack() {
        return this.cycleDetectionStack;
    }

    private Field convertToXMLField(CoreField field) {
        return (Field)field;
    }

    @Override
    public CoreAttributeGroup getCurrentAttributeGroup() {
        if (this.attributeGroupStack == null || this.attributeGroupStack.isEmpty()) {
            return DEFAULT_ATTRIBUTE_GROUP;
        }
        return this.attributeGroupStack.peek();
    }

    @Override
    public void pushAttributeGroup(CoreAttributeGroup group) {
        if (group == DEFAULT_ATTRIBUTE_GROUP && this.attributeGroupStack == null) {
            return;
        }
        if (this.attributeGroupStack == null) {
            this.attributeGroupStack = new Stack();
        }
        this.attributeGroupStack.push(group);
    }

    @Override
    public void popAttributeGroup() {
        if (this.attributeGroupStack != null) {
            this.attributeGroupStack.pop();
        }
    }

    static /* synthetic */ Object[] access$2() {
        return EMPTY_CYCLE_DATA;
    }

    public static class CycleDetectionStack<E>
    extends AbstractList<Object> {
        private Object[] data = MarshalRecord.access$2();
        int currentIndex = 0;

        public void push(E item) {
            if (this.currentIndex == this.data.length) {
                this.growArray();
            }
            this.data[this.currentIndex] = item;
            ++this.currentIndex;
        }

        private void growArray() {
            Object[] newArray = new Object[this.data.length * 2];
            System.arraycopy(this.data, 0, newArray, 0, this.data.length);
            this.data = newArray;
        }

        public Object pop() {
            Object o = this.data[this.currentIndex - 1];
            this.data[this.currentIndex - 1] = null;
            --this.currentIndex;
            return o;
        }

        public boolean contains(Object item, boolean equalsUsingIdentity) {
            if (equalsUsingIdentity) {
                int i = 0;
                while (i < this.currentIndex) {
                    if (this.data[i] == item) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.currentIndex) {
                    if (this.data[i] != null && this.data[i].equals(item)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String getCycleString() {
            Object x;
            StringBuilder sb = new StringBuilder();
            int i = this.size() - 1;
            Object obj = this.get(i);
            sb.append(obj);
            do {
                sb.append(" -> ");
                x = this.get(--i);
                sb.append(x);
            } while (obj != x);
            return sb.toString();
        }

        @Override
        public Object get(int index) {
            return this.data[index];
        }

        @Override
        public int size() {
            return this.currentIndex;
        }
    }
}

