/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ResourceRepositoryWrapper
implements ResourceRepository {
    private ResourceRepository localResourceRepository;
    private ResourceRepository wrappedResourceRepository;

    public ResourceRepositoryWrapper(ResourceRepository resourceRepository, Class resourceBundleClass) {
        this(resourceRepository, resourceBundleClass, null);
    }

    public ResourceRepositoryWrapper(ResourceRepository resourceRepository, IconResourceFileNameMap iconResourceFileNameMap) {
        this(resourceRepository, null, iconResourceFileNameMap);
    }

    public ResourceRepositoryWrapper(ResourceRepository resourceRepository, Class resourceBundleClass, IconResourceFileNameMap iconResourceFileNameMap) {
        if (resourceRepository == null) {
            throw new NullPointerException();
        }
        this.wrappedResourceRepository = resourceRepository;
        this.localResourceRepository = new DefaultResourceRepository(resourceBundleClass, iconResourceFileNameMap);
    }

    @Override
    public boolean hasString(String key) {
        return this.localResourceRepository.hasString(key) || this.wrappedResourceRepository.hasString(key);
    }

    @Override
    public String getString(String key) {
        if (this.localResourceRepository.hasString(key)) {
            return this.localResourceRepository.getString(key);
        }
        return this.wrappedResourceRepository.getString(key);
    }

    @Override
    public String getString(String key, Object argument) {
        if (this.localResourceRepository.hasString(key)) {
            return this.localResourceRepository.getString(key, argument);
        }
        return this.wrappedResourceRepository.getString(key, argument);
    }

    @Override
    public String getString(String key, Object argument1, Object argument2) {
        if (this.localResourceRepository.hasString(key)) {
            return this.localResourceRepository.getString(key, argument1, argument2);
        }
        return this.wrappedResourceRepository.getString(key, argument1, argument2);
    }

    @Override
    public String getString(String key, Object argument1, Object argument2, Object argument3) {
        if (this.localResourceRepository.hasString(key)) {
            return this.localResourceRepository.getString(key, argument1, argument2, argument3);
        }
        return this.wrappedResourceRepository.getString(key, argument1, argument2, argument3);
    }

    @Override
    public String getString(String key, Object[] arguments) {
        if (this.localResourceRepository.hasString(key)) {
            return this.localResourceRepository.getString(key, arguments);
        }
        return this.wrappedResourceRepository.getString(key, arguments);
    }

    @Override
    public boolean hasMnemonic(String key) {
        return this.localResourceRepository.hasMnemonic(key) || this.wrappedResourceRepository.hasMnemonic(key);
    }

    @Override
    public int getMnemonic(String key) {
        if (this.localResourceRepository.hasMnemonic(key)) {
            return this.localResourceRepository.getMnemonic(key);
        }
        return this.wrappedResourceRepository.getMnemonic(key);
    }

    @Override
    public int getMnemonicIndex(String key) {
        if (this.localResourceRepository.hasMnemonic(key)) {
            return this.localResourceRepository.getMnemonicIndex(key);
        }
        return this.wrappedResourceRepository.getMnemonicIndex(key);
    }

    @Override
    public boolean hasAccelerator(String key) {
        return this.localResourceRepository.hasAccelerator(key) || this.wrappedResourceRepository.hasAccelerator(key);
    }

    @Override
    public KeyStroke getAccelerator(String key) {
        if (this.localResourceRepository.hasAccelerator(key)) {
            return this.localResourceRepository.getAccelerator(key);
        }
        return this.wrappedResourceRepository.getAccelerator(key);
    }

    @Override
    public boolean hasIcon(String key) {
        return this.localResourceRepository.hasIcon(key) || this.wrappedResourceRepository.hasIcon(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (this.localResourceRepository.hasIcon(key)) {
            return this.localResourceRepository.getIcon(key);
        }
        return this.wrappedResourceRepository.getIcon(key);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

