/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class AddRemoveListPanel
extends AddRemovePanel {
    private JList list;

    public AddRemoveListPanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel) {
        this(context, adapter, listModel, 2);
    }

    public AddRemoveListPanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, int buttonOrientation) {
        this(context, adapter, listModel, buttonOrientation, (String)null);
    }

    public AddRemoveListPanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, int buttonOrientation, String initialAccessName) {
        this(context, adapter, listModel, buttonOrientation, initialAccessName, new NodeSelector.DefaultNodeSelector());
    }

    public AddRemoveListPanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, int buttonOrientation, String initialAccessName, NodeSelector nodeSelector) {
        super(context, adapter, listModel, buttonOrientation, nodeSelector);
        this.initializeLayout(initialAccessName);
    }

    public AddRemoveListPanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, String initialAccessName) {
        this(context, adapter, listModel, 2, initialAccessName);
    }

    @Override
    protected void initialize(ListValueModel listModel) {
        super.initialize(listModel);
        this.list = SwingComponentFactory.buildList(new ListModelAdapter(listModel));
        this.list.setSelectionModel(this.getSelectionModel());
        this.list.setCellRenderer(new DisplayableListCellRenderer());
        this.list.addKeyListener(this.buildF3KeyListener());
        this.helpManager().addItemsToPopupMenuForComponent(new JMenuItem[]{this.buildGoToMenuItem()}, this.list);
    }

    protected void initializeLayout(String accessibleName) {
        this.initializeListPanel(accessibleName);
        this.initializeButtonPanel();
    }

    protected void initializeListPanel(String accessibleName) {
        GridBagConstraints constraints = new GridBagConstraints();
        if (this.getButtonOrientation() == 1) {
            constraints.gridx = 0;
            constraints.gridy = 1;
        } else if (this.getButtonOrientation() == 4) {
            constraints.gridx = 1;
            constraints.gridy = 0;
        } else {
            constraints.gridx = 0;
            constraints.gridy = 0;
        }
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.list.getAccessibleContext().setAccessibleName(accessibleName);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setMinimumSize(new Dimension(1, 1));
        scrollPane.setPreferredSize(new Dimension(1, 1));
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.add((Component)scrollPane, constraints);
    }

    @Override
    public JComponent getComponent() {
        return this.list;
    }

    public JList getList() {
        return this.list;
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public Iterator selectedValues() {
        return CollectionTools.iterator((Object[])this.list.getSelectedValues());
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.list.setCellRenderer(cellRenderer);
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    public void setSelectedIndices(int[] indices) {
        this.list.setSelectedIndices(indices);
    }

    @Override
    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        this.list.setSelectedValue(anObject, shouldScroll);
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.list.setSelectionInterval(anchor, lead);
    }
}

