/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class ContainerPolicyPanel
extends AbstractSubjectPanel {
    private PropertyValueModel containerPolicyHolder;
    PropertyValueModel containerTypeHolder;
    private PropertyValueModel defaultingContainerClassHolder;
    private PropertyValueModel mapContainerPolicyHolder;
    private JCheckBox useSortingCheckBox;
    private static final String CONTAINER_TYPE_COLLECTION = "collection";
    private static final String CONTAINER_TYPE_LIST = "list";
    private static final String CONTAINER_TYPE_MAP = "map";
    private static final String CONTAINER_TYPE_SET = "set";

    public ContainerPolicyPanel(ValueModel containerMappingHolder, WorkbenchContextHolder contextHolder) {
        super(containerMappingHolder, contextHolder);
    }

    @Override
    protected void initialize(ValueModel containerMappingHolder) {
        super.initialize(containerMappingHolder);
        this.containerTypeHolder = this.buildContainerTypeHolder();
        this.containerPolicyHolder = this.buildContainerPolicyHolder();
        this.mapContainerPolicyHolder = this.buildMapContainerPolicyHolder(this.containerPolicyHolder);
        this.defaultingContainerClassHolder = this.buildDefaultingContainerClassHolder(this.containerPolicyHolder);
    }

    private PropertyValueModel buildContainerTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerPolicy"){

            @Override
            protected Object getValueFromSubject() {
                MWContainerPolicy cp = ((MWContainerMapping)this.subject).getContainerPolicy();
                if (cp instanceof MWCollectionContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_COLLECTION;
                }
                if (cp instanceof MWListContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_LIST;
                }
                if (cp instanceof MWSetContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_SET;
                }
                if (cp instanceof MWMapContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_MAP;
                }
                return null;
            }

            @Override
            protected void setValueOnSubject(Object value) {
                if (value == ContainerPolicyPanel.CONTAINER_TYPE_COLLECTION) {
                    ((MWContainerMapping)this.subject).setCollectionContainerPolicy();
                } else if (value == ContainerPolicyPanel.CONTAINER_TYPE_LIST) {
                    ((MWContainerMapping)this.subject).setListContainerPolicy();
                } else if (value == ContainerPolicyPanel.CONTAINER_TYPE_SET) {
                    ((MWContainerMapping)this.subject).setSetContainerPolicy();
                } else if (value == ContainerPolicyPanel.CONTAINER_TYPE_MAP) {
                    ((MWMapContainerMapping)this.subject).setMapContainerPolicy();
                }
            }
        };
    }

    private PropertyValueModel buildContainerPolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerPolicy"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWContainerMapping)this.subject).getContainerPolicy();
            }
        };
    }

    private PropertyValueModel buildMapContainerPolicyHolder(PropertyValueModel containerPolicyHolder) {
        return new FilteringPropertyValueModel(containerPolicyHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWMapContainerPolicy;
            }
        };
    }

    private PropertyValueModel buildDefaultingContainerClassHolder(PropertyValueModel containerPolicyHolder) {
        return new PropertyAspectAdapter(containerPolicyHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWContainerPolicy)this.subject).getDefaultingContainerClass();
            }
        };
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        Insets offset = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        offset.left += 5;
        offset.right += 5;
        JPanel containerTypeGroupBox = new JPanel(new GridBagLayout());
        containerTypeGroupBox.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("CONTAINER_POLICY_GROUP_BOX"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)containerTypeGroupBox, constraints);
        JPanel containerTypeSubPane = new JPanel(new GridLayout(1, 4, 20, 0));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        containerTypeGroupBox.add((Component)containerTypeSubPane, constraints);
        Spacer spacer = new Spacer();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        containerTypeGroupBox.add((Component)spacer, constraints);
        JRadioButton listContainerTypeRadioButton = this.buildListContainerTypeRadioButton();
        containerTypeSubPane.add(listContainerTypeRadioButton);
        buttonGroup.add(listContainerTypeRadioButton);
        JRadioButton setContainerTypeRadioButton = this.buildSetContainerTypeRadioButton();
        containerTypeSubPane.add(setContainerTypeRadioButton);
        buttonGroup.add(setContainerTypeRadioButton);
        JRadioButton collectionContainerTypeRadioButton = this.buildCollectionContainerTypeRadioButton();
        containerTypeSubPane.add(collectionContainerTypeRadioButton);
        buttonGroup.add(collectionContainerTypeRadioButton);
        JRadioButton mapContainerTypeRadioButton = this.buildMapContainerTypeRadioButton();
        containerTypeSubPane.add(mapContainerTypeRadioButton);
        buttonGroup.add(mapContainerTypeRadioButton);
        JCheckBox overrideDefaultContainerClassCheckBox = this.buildOverrideDefaultContainerClassCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, offset.left, 0, 0);
        this.add((Component)overrideDefaultContainerClassCheckBox, constraints);
        this.addAlignLeft(overrideDefaultContainerClassCheckBox);
        ClassChooserPanel containerClassChooserPanel = ClassChooserTools.buildPanel(this.buildContainerClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), new JLabel(overrideDefaultContainerClassCheckBox.getText()), this.getWorkbenchContextHolder());
        containerClassChooserPanel.setEnabled(overrideDefaultContainerClassCheckBox.isSelected());
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 5, 0, offset.right);
        this.add((Component)containerClassChooserPanel, constraints);
        this.addPaneForAlignment(containerClassChooserPanel);
        overrideDefaultContainerClassCheckBox.addItemListener(this.buildContainerClassChooserEnabler(containerClassChooserPanel));
        JComponent keyMethodWidgets = this.buildLabeledComponent("CONTAINER_POLICY_KEY_METHOD_CHOOSER", this.buildKeyMethodChooser());
        keyMethodWidgets.setEnabled(mapContainerTypeRadioButton.isSelected());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        this.add((Component)keyMethodWidgets, constraints);
        mapContainerTypeRadioButton.addItemListener(this.buildKeyMethodWidgetsEnabler(keyMethodWidgets));
        this.useSortingCheckBox = this.buildUseSortingCheckBox();
        this.useSortingCheckBox.setEnabled(setContainerTypeRadioButton.isSelected());
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, offset.left, 0, 0);
        this.add((Component)this.useSortingCheckBox, constraints);
        this.addAlignLeft(this.useSortingCheckBox);
        setContainerTypeRadioButton.addItemListener(this.buildUseSortingCheckboxEnabler(this.useSortingCheckBox));
        ClassChooserPanel comparatorClassChooserPanel = ClassChooserTools.buildPanel(this.buildComparatorClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), new JLabel(this.useSortingCheckBox.getText()), this.getWorkbenchContextHolder());
        comparatorClassChooserPanel.setEnabled(this.useSortingCheckBox.isSelected());
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 5, 0, offset.right);
        this.add((Component)comparatorClassChooserPanel, constraints);
        this.addPaneForAlignment(comparatorClassChooserPanel);
        setContainerTypeRadioButton.addItemListener(this.buildComparatorClassChooserSetEnabler(comparatorClassChooserPanel));
        this.useSortingCheckBox.addItemListener(this.buildComparatorClassChooserSortingEnabler(comparatorClassChooserPanel));
    }

    private JRadioButton buildCollectionContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_COLLECTION_CLASS_RADIO_BUTTON", this.buildCollectionContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildCollectionContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_COLLECTION);
    }

    private JRadioButton buildListContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_LIST_CLASS_RADIO_BUTTON", this.buildListContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildListContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_LIST);
    }

    private JRadioButton buildMapContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_MAP_CLASS_RADIO_BUTTON", this.buildMapContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildMapContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_MAP);
    }

    private JRadioButton buildSetContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_SET_CLASS_RADIO_BUTTON", this.buildSetContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildSetContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_SET);
    }

    private PropertyValueModel buildContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "containerClass", "usesDefaultContainerClass"){

            @Override
            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).getContainerClass();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DefaultingContainerClass)this.subject).setContainerClass((MWClass)value);
            }
        };
    }

    private PropertyValueModel buildComparatorClassHolder() {
        return new PropertyAspectAdapter(this.containerPolicyHolder, "comparatorClass", "sort"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWContainerPolicy)this.subject).getComparatorClass();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWContainerPolicy)this.subject).setComparatorClass((MWClass)value);
            }
        };
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return ((MWModel)ContainerPolicyPanel.this.subject()).getRepository();
            }
        };
    }

    private ItemListener buildContainerClassChooserEnabler(final ClassChooserPanel containerClassChooserPanel) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                containerClassChooserPanel.setEnabled(e.getStateChange() == 1);
            }
        };
    }

    private JCheckBox buildOverrideDefaultContainerClassCheckBox() {
        return this.buildCheckBox("CONTAINER_POLICY_OVERRIDE_DEFAULT_CLASS_CHECK_BOX", this.buildOverrideDefaultClassCheckBoxAdapter());
    }

    private ButtonModel buildOverrideDefaultClassCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildOverrideDefaultClassHolder());
    }

    private PropertyValueModel buildOverrideDefaultClassHolder() {
        return new TransformationPropertyValueModel(this.buildUseDefaultContainerClassHolder()){

            private Boolean oppositeValue(Boolean value) {
                return value == null ? null : Boolean.valueOf(value == false);
            }

            @Override
            protected Object reverseTransform(Object value) {
                return this.oppositeValue((Boolean)value);
            }

            @Override
            protected Object transform(Object value) {
                return this.oppositeValue((Boolean)value);
            }
        };
    }

    private PropertyValueModel buildUseDefaultContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "usesDefaultContainerClass"){

            @Override
            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).usesDefaultContainerClass();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DefaultingContainerClass)this.subject).setUseDefaultContainerClass(((Boolean)value).booleanValue());
            }
        };
    }

    private JCheckBox buildUseSortingCheckBox() {
        return this.buildCheckBox("CONTAINER_POLICY_USE_SORTING_CHECK_BOX", this.buildUseSortingCheckBoxAdapter());
    }

    private ButtonModel buildUseSortingCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseSortingHolder());
    }

    private PropertyValueModel buildUseSortingHolder() {
        return new PropertyAspectAdapter(this.containerPolicyHolder, "sort"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWContainerPolicy)this.subject).usesSorting();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWContainerPolicy)this.subject).setUsesSorting(((Boolean)value).booleanValue());
            }
        };
    }

    private ListChooser buildKeyMethodChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildKeyMethodComboBoxModel(), this.getWorkbenchContextHolder());
        chooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return chooser;
    }

    private ComboBoxModel buildKeyMethodComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildSortedCandidateKeyMethodsHolder(), this.buildKeyMethodHolder());
    }

    private ListValueModel buildSortedCandidateKeyMethodsHolder() {
        return new SortedListValueModelAdapter(this.buildCandidateKeyMethodsHolder());
    }

    private CollectionValueModel buildCandidateKeyMethodsHolder() {
        return new FilteringCollectionValueModel(this.buildReferenceTypeMethodsSignatureAdapter()){

            @Override
            protected boolean accept(Object value) {
                return ((MWMethod)value).isCandidateMapContainerPolicyKeyMethod();
            }
        };
    }

    private ListValueModel buildReferenceTypeMethodsSignatureAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildReferenceTypeLineageMethodsAdapter(), "signature");
    }

    private CollectionValueModel buildReferenceTypeLineageMethodsAdapter() {
        return new CompositeCollectionValueModel(this.buildReferenceTypeLineageAdapter()){

            @Override
            protected CollectionValueModel transform(Object value) {
                return ContainerPolicyPanel.this.buildMethodsAdapter((MWClass)value);
            }
        };
    }

    CollectionValueModel buildMethodsAdapter(MWClass type) {
        return new CollectionAspectAdapter("methods", (Model)type){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).methods();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWClass)this.subject).methodsSize();
            }
        };
    }

    private CollectionValueModel buildReferenceTypeLineageAdapter() {
        return new CollectionAspectAdapter(this.buildReferenceTypeAdapter(), "superclasses"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).lineage();
            }
        };
    }

    private ValueModel buildReferenceTypeAdapter() {
        return new PropertyAspectAdapter(this.buildReferenceDescriptorAdapter(), "mwClass"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    private ValueModel buildReferenceDescriptorAdapter() {
        return new PropertyAspectAdapter(this.buildMapContainerMappingAdapter(), "referenceDescriptor"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWReferenceObjectMapping)this.subject).getReferenceDescriptor();
            }
        };
    }

    private ValueModel buildMapContainerMappingAdapter() {
        return new TransformationPropertyValueModel(this.mapContainerPolicyHolder){

            @Override
            protected Object transform(Object value) {
                return value == null ? null : ((MWMapContainerPolicy)value).getMapContainerMapping();
            }

            @Override
            protected Object reverseTransform(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PropertyValueModel buildKeyMethodHolder() {
        return new PropertyAspectAdapter(this.mapContainerPolicyHolder, "keyMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWMapContainerPolicy)this.subject).getKeyMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWMapContainerPolicy)this.subject).setKeyMethod((MWMethod)value);
            }
        };
    }

    private ItemListener buildKeyMethodWidgetsEnabler(final JComponent keyMethodWidgets) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                keyMethodWidgets.setEnabled(e.getStateChange() == 1);
            }
        };
    }

    private ItemListener buildUseSortingCheckboxEnabler(final JComponent useJoiningCheckbox) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                useJoiningCheckbox.setEnabled(e.getStateChange() == 1);
            }
        };
    }

    private ItemListener buildComparatorClassChooserSetEnabler(final JComponent comparatorClassChooser) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                comparatorClassChooser.setEnabled(e.getStateChange() == 1 && ContainerPolicyPanel.this.useSortingCheckBox.isSelected());
            }
        };
    }

    private ItemListener buildComparatorClassChooserSortingEnabler(final JComponent comparatorClassChooser) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                comparatorClassChooser.setEnabled(e.getStateChange() == 1);
            }
        };
    }
}

