/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullValuePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class NullValuePolicyPanel
extends AbstractSubjectPanel {
    private PropertyValueModel nullValuePolicyHolder;

    public NullValuePolicyPanel(PropertyValueModel mappingHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)mappingHolder, contextHolder);
    }

    @Override
    protected void initialize(ValueModel subjectHolder) {
        super.initialize(subjectHolder);
        this.nullValuePolicyHolder = this.buildNullValuePolicyHolder();
    }

    protected PropertyValueModel buildNullValuePolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "usesNullValue"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDirectMapping)this.subject).getNullValuePolicy();
            }
        };
    }

    private PropertyChangeListener buildUsesNullValueListener(final Component component) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(NullValuePolicyPanel.this.usesNullValue());
            }
        };
    }

    private boolean usesNullValue() {
        return this.subject() == null ? false : ((MWDirectMapping)this.subject()).usesNullValue();
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JCheckBox useNullValueCheckBox = this.buildCheckBox("DEFAULT_NULL_VALUE_CHECK_BOX", this.buildUseNullValueCheckBoxModelAdapter());
        Pane nullValuePanel = new Pane(new GridBagLayout());
        this.nullValuePolicyHolder.addPropertyChangeListener("value", this.buildUsesNullValueListener(nullValuePanel));
        GroupBox groupBox = new GroupBox(useNullValueCheckBox, (JComponent)nullValuePanel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)groupBox, constraints);
        JComponent nullValueTypeWidgets = this.buildLabeledComponent("DEFAULT_NULL_VALUE_TYPE_LABEL", this.buildNullValueTypeListChooser());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        nullValuePanel.add((Component)nullValueTypeWidgets, constraints);
        JComponent nullValueValueWidgets = this.buildLabeledComponent("DEFAULT_NULL_VALUE_VALUE_LABEL", this.buildNullValueTextField());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        nullValuePanel.add((Component)nullValueValueWidgets, constraints);
        this.addHelpTopicId(this, "mapping.direct.nullValue");
    }

    private CheckBoxModelAdapter buildUseNullValueCheckBoxModelAdapter() {
        return new CheckBoxModelAdapter(this.buildUseNullValueHolder());
    }

    private PropertyValueModel buildUseNullValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "usesNullValue"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDirectMapping)this.subject).usesNullValue();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWDirectMapping)this.subject).setUseNullValue(((Boolean)value).booleanValue());
            }
        };
    }

    private ListChooser buildNullValueTypeListChooser() {
        DefaultListChooser chooser = new DefaultListChooser((ComboBoxModel)this.buildNullValueComboBoxModelAdapter(), this.getWorkbenchContextHolder(), this.buildNullValueTypeChooserDialogBuilder());
        chooser.setRenderer(this.buildMWClassListCellRenderer());
        return chooser;
    }

    private DefaultListChooserDialog.Builder buildNullValueTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("NULL_VALUE_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("NULL_VALUE_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildNullValueTypeStringConverter());
        return builder;
    }

    private ComboBoxModelAdapter buildNullValueComboBoxModelAdapter() {
        return new ComboBoxModelAdapter(this.buildNullValueTypeCollectionHolder(), this.buildNullValueTypeHolder());
    }

    private CollectionValueModel buildNullValueTypeCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder()){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWDirectMapping)this.subject).buildBasicTypes().iterator();
            }
        };
    }

    private PropertyValueModel buildNullValueTypeHolder() {
        return new PropertyAspectAdapter(this.nullValuePolicyHolder, "nullValueType"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWNullValuePolicy)this.subject).getNullValueType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWNullValuePolicy)this.subject).setNullValueType((MWTypeDeclaration)value);
            }
        };
    }

    private StringConverter buildNullValueTypeStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return ((MWTypeDeclaration)o).typeName();
            }
        };
    }

    private ListCellRenderer buildMWClassListCellRenderer() {
        return new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository()));
    }

    private JTextField buildNullValueTextField() {
        JTextField textField = new JTextField();
        textField.setDocument(new DocumentAdapter(this.buildNullValueHolder()));
        return textField;
    }

    private PropertyValueModel buildNullValueHolder() {
        return new PropertyAspectAdapter(this.nullValuePolicyHolder, "nullValue"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWNullValuePolicy)this.subject).getNullValue();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWNullValuePolicy)this.subject).setNullValue((String)value);
            }
        };
    }
}

