/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryParameterDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

public final class QueryParametersPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private AddRemoveTablePanel paramatersPanel;

    public QueryParametersPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout();
    }

    private String helpTopicId() {
        return "descriptor.queryManager.general.parameters";
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.paramatersPanel = this.buildQueryParametersTable();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.paramatersPanel, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)buttonPanel, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveTablePanel buildQueryParametersTable() {
        AddRemoveTablePanel tablePanel = new AddRemoveTablePanel(this.getApplicationContext(), this.buildParametersPanelAdapter(), this.buildParametersNameAdapter(), this.buildQueryParametersTableColumnAdapter(), 3){

            @Override
            protected void updateOptionalButton(JButton optionalButton) {
                boolean paramsSelected = this.getSelectionModel().getSelectedValuesSize() == 1;
                this.updateButton(optionalButton, paramsSelected);
            }

            @Override
            protected void updateRemoveButton(JButton removeButton) {
                boolean paramsSelected = this.getSelectionModel().getSelectedValue() != null;
                this.updateButton(removeButton, paramsSelected);
            }

            @Override
            protected void updateAddButton(JButton addButton) {
            }

            @Override
            protected String removeButtonKey() {
                return "REMOVE_PARAMETER_BUTTON";
            }

            @Override
            protected String addButtonKey() {
                return "ADD_PARAMETER_BUTTON";
            }

            private void updateButton(JButton button, boolean paramsSelected) {
                boolean canRemoveParams = true;
                button.setEnabled(paramsSelected && canRemoveParams);
            }
        };
        JTable table = (JTable)tablePanel.getComponent();
        table.getColumnModel().getColumn(0).setCellRenderer(this.buildTypeRenderer());
        return tablePanel;
    }

    protected TableCellRenderer buildTypeRenderer() {
        return new SimpleTableCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? null : ((MWClass)value).getName();
            }
        };
    }

    private AddRemovePanel.UpDownOptionAdapter buildParametersPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            @Override
            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    QueryParametersPanel.this.getQuery().moveParameterDown((MWQueryParameter)items[i]);
                }
            }

            @Override
            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    QueryParametersPanel.this.getQuery().moveParameterUp((MWQueryParameter)items[i]);
                }
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                QueryParametersPanel.this.removeSelectedQueryParameters(listSelectionModel);
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                QueryParametersPanel.this.addQueryParameter();
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                QueryParametersPanel.this.editSelectedQueryParameter((MWQueryParameter)listSelectionModel.getSelectedValue());
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public String optionalButtonKey() {
                return "EDIT_PARAMETER_BUTTON";
            }
        };
    }

    private ListValueModel buildParametersNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildQueryParametersHolder(), "name");
    }

    private ListValueModel buildQueryParametersHolder() {
        return new ListAspectAdapter(this.queryHolder, "parameters"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWAbstractQuery)this.subject).parameters();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWAbstractQuery)this.subject).parametersSize();
            }
        };
    }

    private ColumnAdapter buildQueryParametersTableColumnAdapter() {
        return new QueryParametersColumnAdapter(this.resourceRepository());
    }

    protected void removeSelectedQueryParameters(ObjectListSelectionModel model) {
        this.getQuery().removeParameters(CollectionTools.iterator((Object[])model.getSelectedValues()));
    }

    void addQueryParameter() {
        String newName = NameTools.uniqueNameFor((String)"arg", (Iterator)this.getQuery().parameterNames());
        QueryParameterDialog dialog = new QueryParameterDialog((MWQuery)this.getQuery(), this.getQuery().typeFor(String.class), newName, this.getWorkbenchContext(), this.resourceRepository().getString("QUERY_PARAMETER_DIALOG.title"));
        dialog.show();
        if (dialog.wasConfirmed()) {
            MWClass type = dialog.getParameterType();
            String name = dialog.getParameterName();
            MWQueryParameter parameter = this.getQuery().addParameter(type, name);
            this.selectParameter(parameter);
        }
    }

    void editSelectedQueryParameter(MWQueryParameter selectedParameter) {
        QueryParameterDialog dialog = new QueryParameterDialog((MWQuery)this.getQuery(), selectedParameter.getType(), selectedParameter.getName(), this.getWorkbenchContext(), this.resourceRepository().getString("QUERY_PARAMETER_DIALOG_EDIT.title"));
        dialog.show();
        if (dialog.wasConfirmed()) {
            selectedParameter.setType(dialog.getParameterType());
            selectedParameter.setName(dialog.getParameterName());
        }
    }

    MWAbstractQuery getQuery() {
        return (MWAbstractQuery)this.queryHolder.getValue();
    }

    public void selectParameter(MWQueryParameter parameter) {
        this.paramatersPanel.setSelectedValue(parameter, true);
    }

    public static class QueryParametersColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int TYPE_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"TYPE_COLUMN_HEADER", "NAME_COLUMN_HEADER"};

        protected QueryParametersColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isColumnEditable(int index) {
            return false;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWQueryParameter queryParameter = (MWQueryParameter)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildTypeAdapter(queryParameter), this.buildNameAdapter(queryParameter)};
            return result;
        }

        private PropertyValueModel buildTypeAdapter(MWQueryParameter queryParameter) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("type", (Model)queryParameter){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWQueryParameter)this.subject).getType();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWQueryParameter)this.subject).setType((MWClass)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildNameAdapter(MWQueryParameter queryParameter) {
            return new PropertyAspectAdapter("name", (Model)queryParameter){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWQueryParameter)this.subject).getName();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWQueryParameter)this.subject).setName((String)value);
                }
            };
        }
    }
}

