/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWLiteralArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

final class LiteralArgumentPanel
extends ArgumentPanel {
    private JTextField literalTextField;
    private PropertyValueModel typeHolder;

    LiteralArgumentPanel(PropertyValueModel argumentHolder, WorkbenchContextHolder contextHolder, Collection enablingComponents) {
        super(argumentHolder, contextHolder);
        this.initialize(enablingComponents);
    }

    private void initialize(Collection enablingComponents) {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel typeLabel = new JLabel(this.resourceRepository().getString("TYPE_LABEL:"));
        typeLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TYPE_LABEL:"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)typeLabel, constraints);
        enablingComponents.add(typeLabel);
        JComboBox typeChooser = this.buildTypeChooser();
        typeLabel.setLabelFor(typeChooser);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)typeChooser, constraints);
        enablingComponents.add(typeChooser);
        JLabel valueLabel = new JLabel(this.resourceRepository().getString("VALUE_LABEL:"));
        valueLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("VALUE_LABEL:"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)valueLabel, constraints);
        enablingComponents.add(valueLabel);
        this.literalTextField = this.buildLiteralTextField();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        valueLabel.setLabelFor(this.literalTextField);
        this.add((Component)this.literalTextField, constraints);
        enablingComponents.add(this.literalTextField);
    }

    private JComboBox buildTypeChooser() {
        JComboBox<Object> chooser = new JComboBox<Object>(this.buildAttributeTypeComboBoxModel());
        chooser.setRenderer(new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository())));
        return chooser;
    }

    private ComboBoxModel buildAttributeTypeComboBoxModel() {
        this.typeHolder = this.buildTypeHolder();
        return new ComboBoxModelAdapter(this.buildTypesCollectionHolder(), this.typeHolder);
    }

    private CollectionValueModel buildTypesCollectionHolder() {
        return new CollectionAspectAdapter(this.getArgumentHolder()){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).buildBasicTypes().iterator();
            }
        };
    }

    private PropertyValueModel buildTypeHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "type"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).getLiteralType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWLiteralArgument)this.subject).setType((MWTypeDeclaration)value);
            }
        };
    }

    private JTextField buildLiteralTextField() {
        JTextField textField = new JTextField(0);
        final PropertyValueModel literalHolder = this.buildLiteralHolder();
        textField.setDocument(new DocumentAdapter(literalHolder));
        this.typeHolder.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MWTypeDeclaration type = (MWTypeDeclaration)evt.getNewValue();
                if (type != null) {
                    if (type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Integer.class) || type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(BigInteger.class) || type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Long.class) || type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Short.class)) {
                        LiteralArgumentPanel.this.literalTextField.setDocument(new DocumentAdapter(literalHolder, new RegexpDocument(7)));
                    } else if (type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(BigDecimal.class) || type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Double.class) || type.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Float.class)) {
                        LiteralArgumentPanel.this.literalTextField.setDocument(new DocumentAdapter(literalHolder, new RegexpDocument(10)));
                    } else {
                        LiteralArgumentPanel.this.literalTextField.setDocument(new DocumentAdapter(literalHolder, new PlainDocument()));
                    }
                }
            }
        });
        return textField;
    }

    private PropertyValueModel buildLiteralHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "value"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).getValue();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWLiteralArgument)this.subject).setValue((String)value);
            }
        };
    }

    @Override
    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel argumentHolder) {
        return new FilteringPropertyValueModel(argumentHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWLiteralArgument;
            }
        };
    }
}

