/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Cursor;
import java.awt.Frame;
import org.eclipse.persistence.tools.workbench.uitools.AWTExceptionHandler;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.ExceptionBroadcaster;

public final class GlobalAWTExceptionHandler
implements AWTExceptionHandler.GlobalHandler {
    private final ExceptionBroadcaster broadcaster;

    public static void register(ExceptionBroadcaster broadcaster) {
        AWTExceptionHandler.setGlobalHandler(new GlobalAWTExceptionHandler(broadcaster));
        AWTExceptionHandler.register();
    }

    private GlobalAWTExceptionHandler(ExceptionBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    @Override
    public synchronized void handle(Throwable t) {
        this.restoreDefaultCursor();
        this.broadcaster.broadcast(Thread.currentThread(), t);
    }

    private void restoreDefaultCursor() {
        Cursor defaultCursor = Cursor.getDefaultCursor();
        Frame[] frames = Frame.getFrames();
        int i = frames.length;
        while (i-- > 0) {
            frames[i].setCursor(defaultCursor);
        }
    }

    public String toString() {
        return ClassTools.shortClassNameForObject((Object)this);
    }
}

