/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetweenExpression
extends AbstractExpression {
    private String andIdentifier;
    private String betweenIdentifier;
    private AbstractExpression expression;
    private boolean hasSpaceAfterAnd;
    private boolean hasSpaceAfterBetween;
    private boolean hasSpaceAfterLowerBound;
    private AbstractExpression lowerBoundExpression;
    private String notIdentifier;
    private AbstractExpression upperBoundExpression;

    public BetweenExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent, "BETWEEN");
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
        this.getLowerBoundExpression().accept(visitor);
        this.getUpperBoundExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
        children.add(this.getLowerBoundExpression());
        children.add(this.getUpperBoundExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.hasExpression()) {
            children.add(this.expression);
            children.add(this.buildStringExpression(' '));
        }
        if (this.notIdentifier != null) {
            children.add(this.buildStringExpression("NOT"));
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpaceAfterBetween) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.lowerBoundExpression != null) {
            children.add(this.lowerBoundExpression);
        }
        if (this.hasSpaceAfterLowerBound) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.andIdentifier != null) {
            children.add(this.buildStringExpression("AND"));
        }
        if (this.hasSpaceAfterAnd) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.upperBoundExpression != null) {
            children.add(this.upperBoundExpression);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.upperBoundExpression != null && this.upperBoundExpression.isAncestor(expression) || this.lowerBoundExpression != null && this.lowerBoundExpression.isAncestor(expression)) {
            return this.getQueryBNF("internal_between_expression");
        }
        if (this.expression != null && expression.isAncestor(expression)) {
            return this.getQueryBNF("scalar_expression");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualAndIdentifier() {
        return this.andIdentifier != null ? this.andIdentifier : "";
    }

    public String getActualBetweenIdentifier() {
        return this.betweenIdentifier;
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public String getBoundExpressionQueryBNFId() {
        return "internal_between_expression";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        return this.notIdentifier != null ? "NOT BETWEEN" : "BETWEEN";
    }

    public Expression getLowerBoundExpression() {
        if (this.lowerBoundExpression == null) {
            this.lowerBoundExpression = this.buildNullExpression();
        }
        return this.lowerBoundExpression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("between_expression");
    }

    public Expression getUpperBoundExpression() {
        if (this.upperBoundExpression == null) {
            this.upperBoundExpression = this.buildNullExpression();
        }
        return this.upperBoundExpression;
    }

    public boolean hasAnd() {
        return this.andIdentifier != null;
    }

    protected boolean hasBetween() {
        return this.betweenIdentifier != null;
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasLowerBoundExpression() {
        return this.lowerBoundExpression != null && !this.lowerBoundExpression.isNull();
    }

    public boolean hasNot() {
        return this.notIdentifier != null;
    }

    public boolean hasSpaceAfterAnd() {
        return this.hasSpaceAfterAnd;
    }

    public boolean hasSpaceAfterBetween() {
        return this.hasSpaceAfterBetween;
    }

    public boolean hasSpaceAfterLowerBound() {
        return this.hasSpaceAfterLowerBound;
    }

    public boolean hasUpperBoundExpression() {
        return this.upperBoundExpression != null && !this.upperBoundExpression.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("THEN") || word.equalsIgnoreCase("ELSE") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIgnoreCase('N')) {
            this.notIdentifier = wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        this.betweenIdentifier = wordParser.moveForward("BETWEEN");
        this.hasSpaceAfterBetween = wordParser.skipLeadingWhitespace() > 0;
        this.lowerBoundExpression = this.parse(wordParser, "internal_between_expression", tolerant);
        if (this.lowerBoundExpression != null) {
            boolean bl = this.hasSpaceAfterLowerBound = wordParser.skipLeadingWhitespace() > 0;
        }
        if (!tolerant || wordParser.startsWithIdentifier("AND")) {
            this.andIdentifier = wordParser.moveForward("AND");
            this.hasSpaceAfterAnd = wordParser.skipLeadingWhitespace() > 0;
        }
        this.upperBoundExpression = this.parse(wordParser, "internal_between_expression", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.hasExpression()) {
            this.expression.toParsedText(writer, actual);
            writer.append(' ');
        }
        if (this.notIdentifier != null) {
            writer.append(actual ? this.notIdentifier : "NOT");
            writer.append(' ');
        }
        if (this.betweenIdentifier != null) {
            writer.append(actual ? this.betweenIdentifier : "BETWEEN");
        }
        if (this.hasSpaceAfterBetween) {
            writer.append(' ');
        }
        if (this.lowerBoundExpression != null) {
            this.lowerBoundExpression.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterLowerBound) {
            writer.append(' ');
        }
        if (this.andIdentifier != null) {
            writer.append(actual ? this.andIdentifier : "AND");
        }
        if (this.hasSpaceAfterAnd) {
            writer.append(' ');
        }
        if (this.upperBoundExpression != null) {
            this.upperBoundExpression.toParsedText(writer, actual);
        }
    }
}

