/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.internal.jaxb.AttributeNodeImpl;
import org.eclipse.persistence.jaxb.AttributeNode;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.eclipse.persistence.jaxb.SubGraph;

public class ObjectGraphImpl<X>
extends AttributeNodeImpl<X>
implements ObjectGraph<X>,
SubGraph<X> {
    private CoreAttributeGroup attributeGroup;
    private Map<String, AttributeNode> attributeNodes;

    public ObjectGraphImpl(CoreAttributeGroup group) {
        this.attributeGroup = group;
        this.attributeNodes = new HashMap<String, AttributeNode>();
    }

    @Override
    public <X> Class<X> getClassType() {
        return this.attributeGroup.getType();
    }

    @Override
    public String getName() {
        return this.attributeGroup.getName();
    }

    @Override
    public <X> void addAttributeNodes(String ... attributeName) {
        String[] stringArray = attributeName;
        int n = attributeName.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            AttributeNodeImpl impl = new AttributeNodeImpl(attribute);
            this.attributeNodes.put(attribute, impl);
            this.attributeGroup.addAttribute(attribute);
            ++n2;
        }
    }

    @Override
    public <X> SubGraph<X> addSubGraph(String attribute) {
        CoreAttributeGroup group = new CoreAttributeGroup();
        if (this.attributeGroup.getItem(attribute) == null) {
            AttributeNodeImpl impl = new AttributeNodeImpl(attribute);
            this.attributeNodes.put(attribute, impl);
        }
        this.attributeGroup.addAttribute(attribute, group);
        return new ObjectGraphImpl<X>(group);
    }

    @Override
    public <X> SubGraph<X> addSubGraph(String attribute, Class<X> type) {
        CoreAttributeGroup group = new CoreAttributeGroup(null, type, true);
        if (this.attributeGroup.getItem(attribute) == null) {
            AttributeNodeImpl impl = new AttributeNodeImpl(attribute);
            this.attributeNodes.put(attribute, impl);
        }
        this.attributeGroup.addAttribute(attribute, group);
        return new ObjectGraphImpl<X>(group);
    }

    @Override
    public List<AttributeNode<?>> getAttributeNodes() {
        ArrayList nodes = new ArrayList();
        for (AttributeNode next : this.attributeNodes.values()) {
            nodes.add(next);
        }
        return nodes;
    }

    public CoreAttributeGroup getAttributeGroup() {
        return this.attributeGroup;
    }
}

